/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.common.time;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class HaltedClock
extends Clock {
    private final DateTime now;

    public HaltedClock(DateTime now) {
        this.now = now.toDateTime(DateTimeZone.UTC);
    }

    @Override
    public ZoneId getZone() {
        return ZoneOffset.UTC;
    }

    @Override
    public Clock withZone(ZoneId zoneId) {
        if (zoneId.equals(ZoneOffset.UTC)) {
            return this;
        }
        throw new IllegalArgumentException("Halted clock time zone cannot be changed");
    }

    @Override
    public long millis() {
        return this.now.getMillis();
    }

    @Override
    public Instant instant() {
        return Instant.ofEpochMilli(this.now.getMillis());
    }
}

