/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xpack.core.ccr.ShardFollowNodeTaskStatus;

public class FollowStatsAction
extends Action<StatsRequest, StatsResponses, StatsRequestBuilder> {
    public static final String NAME = "cluster:monitor/ccr/follow_stats";
    public static final FollowStatsAction INSTANCE = new FollowStatsAction();

    private FollowStatsAction() {
        super(NAME);
    }

    public StatsResponses newResponse() {
        return new StatsResponses();
    }

    public StatsRequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new StatsRequestBuilder(client, this);
    }

    public static class StatsRequestBuilder
    extends ActionRequestBuilder<StatsRequest, StatsResponses, StatsRequestBuilder> {
        public StatsRequestBuilder(ElasticsearchClient client, Action<StatsRequest, StatsResponses, StatsRequestBuilder> action) {
            super(client, action, (ActionRequest)new StatsRequest());
        }
    }

    public static class StatsResponse
    implements Writeable {
        private final ShardFollowNodeTaskStatus status;

        public ShardFollowNodeTaskStatus status() {
            return this.status;
        }

        public StatsResponse(ShardFollowNodeTaskStatus status) {
            this.status = status;
        }

        public StatsResponse(StreamInput in) throws IOException {
            this.status = new ShardFollowNodeTaskStatus(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.status.writeTo(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StatsResponse that = (StatsResponse)o;
            return Objects.equals(this.status, that.status);
        }

        public int hashCode() {
            return Objects.hash(this.status);
        }
    }

    public static class StatsRequest
    extends BaseTasksRequest<StatsRequest>
    implements IndicesRequest {
        private String[] indices;

        public StatsRequest() {
        }

        public StatsRequest(StreamInput in) throws IOException {
            super(in);
            this.indices = in.readOptionalStringArray();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalStringArray(this.indices);
        }

        public String[] indices() {
            return this.indices;
        }

        public void setIndices(String[] indices) {
            this.indices = indices;
        }

        public IndicesOptions indicesOptions() {
            return IndicesOptions.strictExpand();
        }

        public boolean match(Task task) {
            throw new UnsupportedOperationException();
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            StatsRequest that = (StatsRequest)((Object)o);
            return Arrays.equals(this.indices, that.indices);
        }

        public int hashCode() {
            return Arrays.hashCode(this.indices);
        }
    }

    public static class StatsResponses
    extends BaseTasksResponse
    implements ToXContentObject {
        private List<StatsResponse> statsResponse;

        public List<StatsResponse> getStatsResponses() {
            return this.statsResponse;
        }

        public StatsResponses() {
            this(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }

        public StatsResponses(List<TaskOperationFailure> taskFailures, List<? extends FailedNodeException> nodeFailures, List<StatsResponse> statsResponse) {
            super(taskFailures, nodeFailures);
            this.statsResponse = statsResponse;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            TreeMap<String, Map> taskResponsesByIndex = new TreeMap<String, Map>();
            for (StatsResponse statsResponse : this.statsResponse) {
                taskResponsesByIndex.computeIfAbsent(statsResponse.status().followerIndex(), k -> new TreeMap()).put(statsResponse.status().getShardId(), statsResponse);
            }
            builder.startObject();
            builder.startArray("indices");
            for (Map.Entry entry : taskResponsesByIndex.entrySet()) {
                builder.startObject();
                builder.field("index", (String)entry.getKey());
                builder.startArray("shards");
                for (Map.Entry shard : ((Map)entry.getValue()).entrySet()) {
                    ((StatsResponse)shard.getValue()).status().toXContent(builder, params);
                }
                builder.endArray();
                builder.endObject();
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.statsResponse = in.readList(StatsResponse::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeList(this.statsResponse);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            StatsResponses that = (StatsResponses)((Object)o);
            return Objects.equals(this.statsResponse, that.statsResponse);
        }

        public int hashCode() {
            return Objects.hash(this.statsResponse);
        }
    }
}

