/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.examples;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class FilterComparator
implements Comparator<Filter>,
Serializable {
    private static final FilterComparator INSTANCE = new FilterComparator();
    private static final long serialVersionUID = 7637416445464620770L;

    private FilterComparator() {
    }

    public static FilterComparator getInstance() {
        return INSTANCE;
    }

    @Override
    public int compare(Filter f1, Filter f2) {
        byte[] value2;
        int cmpValue;
        int cmpValue2;
        if (f1 == f2) {
            return 0;
        }
        Validator.ensureNotNull(f1, f2);
        byte type1 = f1.getFilterType();
        byte type2 = f2.getFilterType();
        if (type1 != type2) {
            return (type1 & 0x1F) - (type2 & 0x1F);
        }
        String name1 = StaticUtils.toLowerCase(f1.getAttributeName());
        String name2 = StaticUtils.toLowerCase(f2.getAttributeName());
        if (name1 != null && name2 != null && (cmpValue2 = name1.compareTo(name2)) != 0) {
            return cmpValue2;
        }
        byte[] value1 = f1.getAssertionValueBytes();
        if (value1 != null && (cmpValue = FilterComparator.compare(value1, value2 = f2.getAssertionValueBytes())) != 0) {
            return cmpValue;
        }
        switch (type1) {
            case -96: 
            case -95: {
                return FilterComparator.compareANDOrOR(f1, f2);
            }
            case -94: {
                return this.compare(f1.getNOTComponent(), f2.getNOTComponent());
            }
            case -121: 
            case -93: 
            case -91: 
            case -90: 
            case -88: {
                return 0;
            }
            case -92: {
                return FilterComparator.compareSubstring(f1, f2);
            }
            case -87: {
                return FilterComparator.compareExtensible(f1, f2);
            }
        }
        return 0;
    }

    private static int compareANDOrOR(Filter f1, Filter f2) {
        Filter comp2;
        Filter comp1;
        int compValue;
        TreeSet<Filter> set1 = new TreeSet<Filter>(INSTANCE);
        TreeSet<Filter> set2 = new TreeSet<Filter>(INSTANCE);
        set1.addAll(Arrays.asList(f1.getComponents()));
        set2.addAll(Arrays.asList(f2.getComponents()));
        Iterator<Filter> iterator1 = set1.iterator();
        Iterator<Filter> iterator2 = set2.iterator();
        do {
            if (!iterator1.hasNext()) {
                if (iterator2.hasNext()) {
                    return -1;
                }
                return 0;
            }
            comp1 = iterator1.next();
            if (!iterator2.hasNext()) {
                return 1;
            }
            comp2 = iterator2.next();
        } while ((compValue = INSTANCE.compare(comp1, comp2)) == 0);
        return compValue;
    }

    private static int compareSubstring(Filter f1, Filter f2) {
        byte[] sI1 = f1.getSubInitialBytes();
        byte[] sI2 = f2.getSubInitialBytes();
        if (sI1 == null) {
            if (sI2 != null) {
                return -1;
            }
        } else {
            if (sI2 == null) {
                return 1;
            }
            int cmpValue = FilterComparator.compare(sI1, sI2);
            if (cmpValue != 0) {
                return cmpValue;
            }
        }
        byte[][] sA1 = f1.getSubAnyBytes();
        byte[][] sA2 = f2.getSubAnyBytes();
        if (sA1.length == 0) {
            if (sA2.length > 0) {
                return -1;
            }
        } else {
            if (sA2.length == 0) {
                return 1;
            }
            int minLength = Math.min(sA1.length, sA2.length);
            for (int i = 0; i < minLength; ++i) {
                int cmpValue = FilterComparator.compare(sA1[i], sA2[i]);
                if (cmpValue == 0) continue;
                return cmpValue;
            }
            if (sA1.length < sA2.length) {
                return -1;
            }
            if (sA2.length < sA1.length) {
                return 1;
            }
        }
        byte[] sF1 = f1.getSubFinalBytes();
        byte[] sF2 = f2.getSubFinalBytes();
        if (sF1 == null) {
            if (sF2 != null) {
                return -1;
            }
            return 0;
        }
        if (sF2 == null) {
            return 1;
        }
        return FilterComparator.compare(sF1, sF2);
    }

    private static int compareExtensible(Filter f1, Filter f2) {
        String name1 = f1.getAttributeName();
        String name2 = f2.getAttributeName();
        if (name1 == null) {
            if (name2 != null) {
                return -1;
            }
        } else if (name2 == null) {
            return 1;
        }
        String mr1 = f1.getMatchingRuleID();
        String mr2 = f2.getMatchingRuleID();
        if (mr1 == null) {
            if (mr2 != null) {
                return -1;
            }
        } else {
            if (mr2 == null) {
                return 1;
            }
            int cmpValue = mr1.compareTo(mr2);
            if (cmpValue != 0) {
                return cmpValue;
            }
        }
        if (f1.getDNAttributes()) {
            if (f2.getDNAttributes()) {
                return 0;
            }
            return 1;
        }
        if (f2.getDNAttributes()) {
            return -1;
        }
        return 0;
    }

    private static int compare(byte[] a1, byte[] a2) {
        int length = Math.min(a1.length, a2.length);
        for (int i = 0; i < length; ++i) {
            int b1 = 0xFF & a1[i];
            int b2 = 0xFF & a2[i];
            if (b1 == b2) continue;
            return b1 - b2;
        }
        return a1.length - a2.length;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        return o != null && o instanceof FilterComparator;
    }
}

