/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.baseinfo;

import java.util.Properties;
import org.campagnelab.dl.varanalysis.protobuf.BaseInformationRecords;
import org.campagnelab.goby.baseinfo.StatAccumulator;

public class StatAccumulatorDistancesToReadVariations
extends StatAccumulator {
    public static final String STATS_DISTANCES_FORWARD = "stats.distancesToReadVariations.forward";
    public static final String STATS_DISTANCES_REVERSE = "stats.distancesToReadVariations.reverse";
    protected float minimumValueDistForward = Float.POSITIVE_INFINITY;
    protected float maximumValueDistForward = Float.NEGATIVE_INFINITY;
    protected float minimumValueDistReverse = Float.POSITIVE_INFINITY;
    protected float maximumValueDistReverse = Float.NEGATIVE_INFINITY;
    private String propertyName;

    public StatAccumulatorDistancesToReadVariations() {
        super(null, null);
    }

    @Override
    void setProperties(Properties properties) {
        this.propertyName = STATS_DISTANCES_FORWARD;
        if (this.isDefined(this.minimumValueDistForward)) {
            properties.setProperty(this.propertyName + ".min", Float.toString(this.minimumValueDistForward));
        }
        if (this.isDefined(this.maximumValueDistForward)) {
            properties.setProperty(this.propertyName + ".max", Float.toString(this.maximumValueDistForward));
        }
        this.propertyName = STATS_DISTANCES_REVERSE;
        if (this.isDefined(this.minimumValueDistReverse)) {
            properties.setProperty(this.propertyName + ".min", Float.toString(this.minimumValueDistReverse));
        }
        if (this.isDefined(this.maximumValueDistReverse)) {
            properties.setProperty(this.propertyName + ".max", Float.toString(this.maximumValueDistReverse));
        }
    }

    @Override
    void observe(BaseInformationRecords.BaseInformation record) {
        for (BaseInformationRecords.SampleInfo sample : record.getSamplesList()) {
            for (BaseInformationRecords.CountInfo count : sample.getCountsList()) {
                for (BaseInformationRecords.NumberWithFrequency freqvalue : count.getDistancesToReadVariationsForwardStrandList()) {
                    this.minimumValueDistForward = Math.min(this.minimumValueDistForward, (float)freqvalue.getNumber());
                    this.maximumValueDistForward = Math.max(this.maximumValueDistForward, (float)freqvalue.getNumber());
                }
                for (BaseInformationRecords.NumberWithFrequency freqvalue : count.getDistancesToReadVariationsReverseStrandList()) {
                    this.minimumValueDistReverse = Math.min(this.minimumValueDistReverse, (float)freqvalue.getNumber());
                    this.maximumValueDistReverse = Math.max(this.maximumValueDistReverse, (float)freqvalue.getNumber());
                }
            }
        }
    }

    @Override
    void mergeWith(Properties properties) {
        if (properties.get("stats.distancesToReadVariations.forward.min") != null) {
            this.minimumValueDistForward = Math.min(this.minimumValueDistForward, Float.parseFloat(properties.get("stats.distancesToReadVariations.forward.min").toString()));
        }
        if (properties.get("stats.distancesToReadVariations.reverse.min") != null) {
            this.minimumValueDistReverse = Math.min(this.minimumValueDistReverse, Float.parseFloat(properties.get("stats.distancesToReadVariations.reverse.min").toString()));
        }
        if (properties.get("stats.distancesToReadVariations.forward.max") != null) {
            this.maximumValueDistForward = Math.max(this.maximumValueDistForward, Float.parseFloat(properties.get("stats.distancesToReadVariations.forward.max").toString()));
        }
        if (properties.get("stats.distancesToReadVariations.reverse.max") != null) {
            this.maximumValueDistReverse = Math.max(this.maximumValueDistReverse, Float.parseFloat(properties.get("stats.distancesToReadVariations.reverse.max").toString()));
        }
    }
}

