/*
 * Decompiled with CFR 0.152.
 */
package free.util.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipURLConnection
extends URLConnection {
    private final File file;
    private final String zipEntryName;
    private ZipFile zipFile = null;
    private ZipEntry zipEntry = null;

    public ZipURLConnection(URL uRL, File file, String string) {
        super(uRL);
        this.file = file;
        this.zipEntryName = string;
    }

    public void connect() throws IOException {
        this.zipFile = new ZipFile(this.file);
        this.zipEntry = this.zipFile.getEntry(this.zipEntryName);
        if (this.zipEntry == null) {
            throw new IOException("Entry " + this.zipEntryName + " not found in file " + this.file);
        }
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.zipFile.getInputStream(this.zipEntry);
    }

    public int getContentLength() {
        if (!this.connected) {
            return -1;
        }
        return (int)this.zipEntry.getSize();
    }
}

