/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleaner;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Implicits$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g!B\u0001\u0003\u0003\u00039!!I!cgR\u0014\u0018m\u0019;M_\u001e\u001cE.Z1oKJLe\u000e^3he\u0006$\u0018n\u001c8UKN$(BA\u0002\u0005\u0003\rawn\u001a\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\n)\u0001\u0001\r\u00111A\u0005\u0002U\tqa\u00197fC:,'/F\u0001\u0017!\t\u0011r#\u0003\u0002\u0019\u0005\tQAj\\4DY\u0016\fg.\u001a:\t\u0013i\u0001\u0001\u0019!a\u0001\n\u0003Y\u0012aC2mK\u0006tWM]0%KF$\"\u0001H\u0010\u0011\u0005%i\u0012B\u0001\u0010\u000b\u0005\u0011)f.\u001b;\t\u000f\u0001J\u0012\u0011!a\u0001-\u0005\u0019\u0001\u0010J\u0019\t\u0013\t\u0002\u0001\u0019!A!B\u00131\u0012\u0001C2mK\u0006tWM\u001d\u0011\t\u000f\u0011\u0002!\u0019!C\u0001K\u00051An\\4ESJ,\u0012A\n\t\u0003O1j\u0011\u0001\u000b\u0006\u0003S)\n!![8\u000b\u0003-\nAA[1wC&\u0011Q\u0006\u000b\u0002\u0005\r&dW\r\u0003\u00040\u0001\u0001\u0006IAJ\u0001\bY><G)\u001b:!\u0011\u001d\t\u0004A1A\u0005\nI\nA\u0001\\8hgV\t1\u0007E\u00025smj\u0011!\u000e\u0006\u0003m]\nq!\\;uC\ndWM\u0003\u00029\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005i*$A\u0003'jgR\u0014UO\u001a4feB\u0011!\u0003P\u0005\u0003{\t\u00111\u0001T8h\u0011\u0019y\u0004\u0001)A\u0005g\u0005)An\\4tA!9\u0011\t\u0001b\u0001\n\u0013\u0011\u0015!\u00063fM\u0006,H\u000e^'bq6+7o]1hKNK'0Z\u000b\u0002\u0007B\u0011\u0011\u0002R\u0005\u0003\u000b*\u00111!\u00138u\u0011\u00199\u0005\u0001)A\u0005\u0007\u00061B-\u001a4bk2$X*\u0019=NKN\u001c\u0018mZ3TSj,\u0007\u0005C\u0004J\u0001\t\u0007I\u0011\u0002&\u0002;\u0011,g-Y;mi6Kgn\u00117fC:\f'\r\\3ESJ$\u0018PU1uS>,\u0012a\u0013\t\u0003\u00131K!!\u0014\u0006\u0003\u000b\u0019cw.\u0019;\t\r=\u0003\u0001\u0015!\u0003L\u0003y!WMZ1vYRl\u0015N\\\"mK\u0006t\u0017M\u00197f\t&\u0014H/\u001f*bi&|\u0007\u0005C\u0004R\u0001\t\u0007I\u0011\u0002*\u0002)\u0011,g-Y;mi\u000e{W\u000e]1di&|g\u000eT1h+\u0005\u0019\u0006CA\u0005U\u0013\t)&B\u0001\u0003M_:<\u0007BB,\u0001A\u0003%1+A\u000beK\u001a\fW\u000f\u001c;D_6\u0004\u0018m\u0019;j_:d\u0015m\u001a\u0011\t\u000fe\u0003!\u0019!C\u0005\u0005\u0006\u0011B-\u001a4bk2$H)\u001a7fi\u0016$U\r\\1z\u0011\u0019Y\u0006\u0001)A\u0005\u0007\u0006\u0019B-\u001a4bk2$H)\u001a7fi\u0016$U\r\\1zA!9Q\f\u0001b\u0001\n\u0013\u0011\u0015A\u00053fM\u0006,H\u000e^*fO6,g\u000e^*ju\u0016Daa\u0018\u0001!\u0002\u0013\u0019\u0015a\u00053fM\u0006,H\u000e^*fO6,g\u000e^*ju\u0016\u0004\u0003\"B1\u0001\r\u0003\u0011\u0017\u0001\u0002;j[\u0016,\u0012a\u0019\t\u0003I\u001el\u0011!\u001a\u0006\u0003M\u0012\tQ!\u001e;jYNL!\u0001[3\u0003\u00115{7m\u001b+j[\u0016DQA\u001b\u0001\u0005\u0002-\f\u0001\u0002^3be\u0012|wO\u001c\u000b\u00029!\u0012\u0011.\u001c\t\u0003]Nl\u0011a\u001c\u0006\u0003aF\fQA[;oSRT\u0011A]\u0001\u0004_J<\u0017B\u0001;p\u0005\u0015\te\r^3s\u0011\u00151\b\u0001\"\u0001x\u0003MawnZ\"p]\u001aLw\r\u0015:pa\u0016\u0014H/[3t)1Ah0!\u0001\u0002\u0006\u0005%\u0011QBA\t!\tIH0D\u0001{\u0015\tY(&\u0001\u0003vi&d\u0017BA?{\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u007fV\u0004\n\u00111\u0001y\u0003E\u0001(o\u001c9feRLxJ^3se&$Wm\u001d\u0005\u0007\u0003\u0007)\b\u0019A\"\u0002\u001d5\f\u00070T3tg\u0006<WmU5{K\"A\u0011qA;\u0011\u0002\u0003\u00071*\u0001\fnS:\u001cE.Z1oC\ndW\rR5sif\u0014\u0016\r^5p\u0011!\tY!\u001eI\u0001\u0002\u0004\u0019\u0016!D2p[B\f7\r^5p]2\u000bw\r\u0003\u0005\u0002\u0010U\u0004\n\u00111\u0001D\u0003-!W\r\\3uK\u0012+G.Y=\t\u0011\u0005MQ\u000f%AA\u0002\r\u000b1b]3h[\u0016tGoU5{K\"9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0011aC7bW\u0016\u001cE.Z1oKJ$RCFA\u000e\u0003\u0013\nY%a\u0014\u0002T\u0005U\u0013qKA-\u00037\n)\u0007\u0003\u0005\u0002\u001e\u0005U\u0001\u0019AA\u0010\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0007\u0003C\t\t$a\u000e\u000f\t\u0005\r\u0012Q\u0006\b\u0005\u0003K\tY#\u0004\u0002\u0002()\u0019\u0011\u0011\u0006\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011bAA\u0018\u0015\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u001a\u0003k\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003_Q\u0001\u0003BA\u001d\u0003\u000bj!!a\u000f\u000b\t\u0005u\u0012qH\u0001\u0007G>lWn\u001c8\u000b\u0007\u0015\t\tEC\u0002\u0002DE\fa!\u00199bG\",\u0017\u0002BA$\u0003w\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0005\u0002\b\u0005U\u0001\u0013!a\u0001\u0017\"I\u0011QJA\u000b!\u0003\u0005\raQ\u0001\u000b]VlG\u000b\u001b:fC\u0012\u001c\b\"CA)\u0003+\u0001\n\u00111\u0001T\u0003%\u0011\u0017mY6PM\u001al5\u000fC\u0005\u0002\u0004\u0005U\u0001\u0013!a\u0001\u0007\"I\u00111BA\u000b!\u0003\u0005\ra\u0015\u0005\n\u0003\u001f\t)\u0002%AA\u0002\rC\u0011\"a\u0005\u0002\u0016A\u0005\t\u0019A\"\t\u0015\u0005u\u0013Q\u0003I\u0001\u0002\u0004\ty&A\ndY\u0016\fg.\u001a:J_\n+hMZ3s'&TX\r\u0005\u0003\n\u0003C\u001a\u0015bAA2\u0015\t1q\n\u001d;j_:D\u0001b`A\u000b!\u0003\u0005\r\u0001\u001f\u0005\n\u0003S\u0002\u0011\u0013!C\u0001\u0003W\nQ\u0004\\8h\u0007>tg-[4Qe>\u0004XM\u001d;jKN$C-\u001a4bk2$H%M\u000b\u0003\u0003[R3\u0001_A8W\t\t\t\b\u0005\u0003\u0002t\u0005uTBAA;\u0015\u0011\t9(!\u001f\u0002\u0013Ut7\r[3dW\u0016$'bAA>\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0014Q\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CAB\u0001E\u0005I\u0011AAC\u0003uawnZ\"p]\u001aLw\r\u0015:pa\u0016\u0014H/[3tI\u0011,g-Y;mi\u0012\u001aTCAADU\rY\u0015q\u000e\u0005\n\u0003\u0017\u0003\u0011\u0013!C\u0001\u0003\u001b\u000bQ\u0004\\8h\u0007>tg-[4Qe>\u0004XM\u001d;jKN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u001fS3aUA8\u0011%\t\u0019\nAI\u0001\n\u0003\t)*A\u000fm_\u001e\u001cuN\u001c4jOB\u0013x\u000e]3si&,7\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\t9JK\u0002D\u0003_B\u0011\"a'\u0001#\u0003%\t!!&\u0002;1|wmQ8oM&<\u0007K]8qKJ$\u0018.Z:%I\u00164\u0017-\u001e7uIYB\u0011\"a(\u0001#\u0003%\t!!\"\u0002+5\f7.Z\"mK\u0006tWM\u001d\u0013eK\u001a\fW\u000f\u001c;%e!I\u00111\u0015\u0001\u0012\u0002\u0013\u0005\u0011QS\u0001\u0016[\u0006\\Wm\u00117fC:,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0011%\t9\u000bAI\u0001\n\u0003\ti)A\u000bnC.,7\t\\3b]\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\t\u0013\u0005-\u0006!%A\u0005\u0002\u0005U\u0015!F7bW\u0016\u001cE.Z1oKJ$C-\u001a4bk2$H%\u000e\u0005\n\u0003_\u0003\u0011\u0013!C\u0001\u0003\u001b\u000bQ#\\1lK\u000ecW-\u00198fe\u0012\"WMZ1vYR$c\u0007C\u0005\u00024\u0002\t\n\u0011\"\u0001\u0002\u0016\u0006)R.Y6f\u00072,\u0017M\\3sI\u0011,g-Y;mi\u0012:\u0004\"CA\\\u0001E\u0005I\u0011AAK\u0003Ui\u0017m[3DY\u0016\fg.\u001a:%I\u00164\u0017-\u001e7uIaB\u0011\"a/\u0001#\u0003%\t!!0\u0002+5\f7.Z\"mK\u0006tWM\u001d\u0013eK\u001a\fW\u000f\u001c;%sU\u0011\u0011q\u0018\u0016\u0005\u0003?\ny\u0007C\u0005\u0002D\u0002\t\n\u0011\"\u0001\u0002l\u00051R.Y6f\u00072,\u0017M\\3sI\u0011,g-Y;mi\u0012\n\u0004\u0007")
public abstract class AbstractLogCleanerIntegrationTest {
    private LogCleaner cleaner;
    private final File logDir = TestUtils$.MODULE$.tempDir();
    private final ListBuffer<Log> logs = (ListBuffer)ListBuffer$.MODULE$.empty();
    private final int defaultMaxMessageSize;
    private final float defaultMinCleanableDirtyRatio;
    private final long defaultCompactionLag;
    private final int defaultDeleteDelay;
    private final int defaultSegmentSize;

    public LogCleaner cleaner() {
        return this.cleaner;
    }

    public void cleaner_$eq(LogCleaner x$1) {
        this.cleaner = x$1;
    }

    public File logDir() {
        return this.logDir;
    }

    private ListBuffer<Log> logs() {
        return this.logs;
    }

    private int defaultMaxMessageSize() {
        return this.defaultMaxMessageSize;
    }

    private float defaultMinCleanableDirtyRatio() {
        return this.defaultMinCleanableDirtyRatio;
    }

    private long defaultCompactionLag() {
        return this.defaultCompactionLag;
    }

    private int defaultDeleteDelay() {
        return this.defaultDeleteDelay;
    }

    private int defaultSegmentSize() {
        return this.defaultSegmentSize;
    }

    public abstract MockTime time();

    @After
    public void teardown() {
        if (this.cleaner() != null) {
            this.cleaner().shutdown();
        }
        this.time().scheduler().shutdown();
        this.logs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    public Properties logConfigProperties(Properties propertyOverrides, int maxMessageSize, float minCleanableDirtyRatio, long compactionLag, int deleteDelay, int segmentSize) {
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(maxMessageSize));
        props.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        props.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(102400));
        props.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(deleteDelay));
        props.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        props.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.float2Float(minCleanableDirtyRatio));
        props.put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        props.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.long2Long(compactionLag));
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(propertyOverrides);
        return props;
    }

    public Properties logConfigProperties$default$1() {
        return new Properties();
    }

    public float logConfigProperties$default$3() {
        return this.defaultMinCleanableDirtyRatio();
    }

    public long logConfigProperties$default$4() {
        return this.defaultCompactionLag();
    }

    public int logConfigProperties$default$5() {
        return this.defaultDeleteDelay();
    }

    public int logConfigProperties$default$6() {
        return this.defaultSegmentSize();
    }

    public LogCleaner makeCleaner(Iterable<TopicPartition> partitions, float minCleanableDirtyRatio, int numThreads, long backOffMs, int maxMessageSize, long compactionLag, int deleteDelay, int segmentSize, Option<Object> cleanerIoBufferSize, Properties propertyOverrides) {
        Pool logMap = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            File dir = new File(this.logDir(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition.topic(), BoxesRunTime.boxToInteger((int)partition.partition())})));
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            LogConfig logConfig = new LogConfig((Map)this.logConfigProperties(propertyOverrides, maxMessageSize, minCleanableDirtyRatio, compactionLag, deleteDelay, segmentSize), LogConfig$.MODULE$.apply$default$2());
            File x$2 = dir;
            LogConfig x$3 = logConfig;
            long x$4 = 0L;
            long x$5 = 0L;
            MockScheduler x$6 = this.time().scheduler();
            MockTime x$7 = this.time();
            BrokerTopicStats x$8 = new BrokerTopicStats();
            int x$9 = 3600000;
            int x$10 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
            LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
            Log log = Log$.MODULE$.apply(x$2, x$3, x$4, x$5, (Scheduler)x$6, x$8, (Time)x$7, x$9, x$10, x$11);
            logMap.put(partition, (Object)log);
            return this.logs().$plus$eq((Object)log);
        });
        int x$12 = numThreads;
        int x$13 = BoxesRunTime.unboxToInt((Object)cleanerIoBufferSize.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> maxMessageSize / 2));
        int x$14 = maxMessageSize;
        long x$15 = backOffMs;
        long x$16 = CleanerConfig$.MODULE$.apply$default$2();
        double x$17 = CleanerConfig$.MODULE$.apply$default$3();
        double x$18 = CleanerConfig$.MODULE$.apply$default$6();
        boolean x$19 = CleanerConfig$.MODULE$.apply$default$8();
        String x$20 = CleanerConfig$.MODULE$.apply$default$9();
        CleanerConfig cleanerConfig = new CleanerConfig(x$12, x$16, x$17, x$13, x$14, x$18, x$15, x$19, x$20);
        return new LogCleaner(cleanerConfig, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}), logMap, new LogDirFailureChannel(1), (Time)this.time());
    }

    public float makeCleaner$default$2() {
        return this.defaultMinCleanableDirtyRatio();
    }

    public int makeCleaner$default$3() {
        return 1;
    }

    public long makeCleaner$default$4() {
        return 15000L;
    }

    public int makeCleaner$default$5() {
        return this.defaultMaxMessageSize();
    }

    public long makeCleaner$default$6() {
        return this.defaultCompactionLag();
    }

    public int makeCleaner$default$7() {
        return this.defaultDeleteDelay();
    }

    public int makeCleaner$default$8() {
        return this.defaultSegmentSize();
    }

    public Option<Object> makeCleaner$default$9() {
        return None$.MODULE$;
    }

    public Properties makeCleaner$default$10() {
        return new Properties();
    }

    public AbstractLogCleanerIntegrationTest() {
        this.defaultMaxMessageSize = 128;
        this.defaultMinCleanableDirtyRatio = 0.0f;
        this.defaultCompactionLag = 0L;
        this.defaultDeleteDelay = 1000;
        this.defaultSegmentSize = 256;
    }
}

