/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.codehaus.plexus.logging.console;

import org.jetbrains.kotlin.org.codehaus.plexus.logging.AbstractLogger;

public final class ConsoleLogger
extends AbstractLogger {
    private static final String[] TAGS = new String[]{"[DEBUG] ", "[INFO] ", "[WARNING] ", "[ERROR] ", "[FATAL ERROR] "};

    public ConsoleLogger(int threshold, String name) {
        super(threshold, name);
    }

    public ConsoleLogger() {
        this(1, "console");
    }

    @Override
    public void debug(String message, Throwable throwable) {
        if (this.isDebugEnabled()) {
            ConsoleLogger.log(0, message, throwable);
        }
    }

    @Override
    public void warn(String message, Throwable throwable) {
        if (this.isWarnEnabled()) {
            ConsoleLogger.log(2, message, throwable);
        }
    }

    private static void log(int level, String message, Throwable throwable) {
        System.out.println(TAGS[level].concat(message));
        if (throwable != null) {
            throwable.printStackTrace(System.out);
        }
    }
}

