/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg.variable;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cfg.ControlFlowInfo;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.BlockScope;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.VariableDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.Edges;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.PseudocodeTraverserKt;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.TraversalOrder;
import org.jetbrains.kotlin.cfg.variable.BlockScopeVariableInfo;
import org.jetbrains.kotlin.cfg.variable.BlockScopeVariableInfoImpl;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007Jw\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u000f0\r\"\"\b\u0000\u0010\u0010*\u001c\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u0012\u0012\u0002\b\u00030\u0011j\n\u0012\u0002\b\u0003\u0012\u0002\b\u0003`\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u0002H\u00102$\u0010\u0017\u001a \u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u000f0\u0018\u00a2\u0006\u0002\u0010\u001aJI\u0010\u001b\u001a\u0002H\u0010\"\"\b\u0000\u0010\u0010*\u001c\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u0012\u0012\u0002\b\u00030\u0011j\n\u0012\u0002\b\u0003\u0012\u0002\b\u0003`\u00132\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u0002H\u0010H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/cfg/variable/PseudocodeVariableDataCollector;", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "pseudocode", "Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;)V", "blockScopeVariableInfo", "Lorg/jetbrains/kotlin/cfg/variable/BlockScopeVariableInfo;", "getBlockScopeVariableInfo", "()Lorg/jetbrains/kotlin/cfg/variable/BlockScopeVariableInfo;", "collectData", "", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "Lorg/jetbrains/kotlin/cfg/pseudocodeTraverser/Edges;", "I", "Lorg/jetbrains/kotlin/cfg/ControlFlowInfo;", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "Lorg/jetbrains/kotlin/cfg/variable/VariableUsageControlFlowInfo;", "traversalOrder", "Lorg/jetbrains/kotlin/cfg/pseudocodeTraverser/TraversalOrder;", "initialInfo", "instructionDataMergeStrategy", "Lkotlin/Function2;", "", "(Lorg/jetbrains/kotlin/cfg/pseudocodeTraverser/TraversalOrder;Lorg/jetbrains/kotlin/cfg/ControlFlowInfo;Lkotlin/jvm/functions/Function2;)Ljava/util/Map;", "filterOutVariablesOutOfScope", "from", "to", "info", "(Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;Lorg/jetbrains/kotlin/cfg/ControlFlowInfo;)Lorg/jetbrains/kotlin/cfg/ControlFlowInfo;", "computeBlockScopeVariableInfo", "cfg"})
public final class PseudocodeVariableDataCollector {
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final Pseudocode pseudocode;
    @NotNull
    private final BlockScopeVariableInfo blockScopeVariableInfo;

    public PseudocodeVariableDataCollector(@NotNull BindingContext bindingContext, @NotNull Pseudocode pseudocode) {
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        Intrinsics.checkNotNullParameter(pseudocode, "pseudocode");
        this.bindingContext = bindingContext;
        this.pseudocode = pseudocode;
        this.blockScopeVariableInfo = this.computeBlockScopeVariableInfo(this.pseudocode);
    }

    @NotNull
    public final BlockScopeVariableInfo getBlockScopeVariableInfo() {
        return this.blockScopeVariableInfo;
    }

    @NotNull
    public final <I extends ControlFlowInfo<?, VariableDescriptor, ?>> Map<Instruction, Edges<I>> collectData(@NotNull TraversalOrder traversalOrder, @NotNull I initialInfo, @NotNull Function2<? super Instruction, ? super Collection<? extends I>, ? extends Edges<? extends I>> instructionDataMergeStrategy) {
        Intrinsics.checkNotNullParameter((Object)traversalOrder, "traversalOrder");
        Intrinsics.checkNotNullParameter(initialInfo, "initialInfo");
        Intrinsics.checkNotNullParameter(instructionDataMergeStrategy, "instructionDataMergeStrategy");
        return PseudocodeTraverserKt.collectData(this.pseudocode, traversalOrder, instructionDataMergeStrategy, (arg_0, arg_1, arg_2) -> PseudocodeVariableDataCollector.collectData$lambda$0(this, arg_0, arg_1, arg_2), initialInfo);
    }

    private final <I extends ControlFlowInfo<?, VariableDescriptor, ?>> I filterOutVariablesOutOfScope(Instruction from2, Instruction to, I info) {
        int toDepth = to.getBlockScope().getDepth();
        if (toDepth >= from2.getBlockScope().getDepth()) {
            return info;
        }
        Object obj = info.retainAll(arg_0 -> PseudocodeVariableDataCollector.filterOutVariablesOutOfScope$lambda$1(this, toDepth, arg_0));
        Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type I of org.jetbrains.kotlin.cfg.variable.PseudocodeVariableDataCollector.filterOutVariablesOutOfScope");
        return (I)obj;
    }

    private final BlockScopeVariableInfo computeBlockScopeVariableInfo(Pseudocode pseudocode) {
        BlockScopeVariableInfoImpl blockScopeVariableInfo = new BlockScopeVariableInfoImpl();
        PseudocodeTraverserKt.traverse(pseudocode, TraversalOrder.FORWARD, arg_0 -> PseudocodeVariableDataCollector.computeBlockScopeVariableInfo$lambda$2(this, blockScopeVariableInfo, arg_0));
        return blockScopeVariableInfo;
    }

    private static final ControlFlowInfo collectData$lambda$0(PseudocodeVariableDataCollector this$0, Instruction from2, Instruction to, ControlFlowInfo info) {
        Intrinsics.checkNotNullParameter(from2, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        Intrinsics.checkNotNullParameter(info, "info");
        return this$0.filterOutVariablesOutOfScope(from2, to, info);
    }

    private static final boolean filterOutVariablesOutOfScope$lambda$1(PseudocodeVariableDataCollector this$0, int $toDepth, VariableDescriptor variable) {
        BlockScope blockScope;
        Intrinsics.checkNotNullParameter(variable, "variable");
        BlockScope blockScope2 = blockScope = this$0.blockScopeVariableInfo.getDeclaredIn().get(variable);
        int depth = blockScope2 != null ? blockScope2.getDepth() : -1;
        return depth <= $toDepth;
    }

    private static final Unit computeBlockScopeVariableInfo$lambda$2(PseudocodeVariableDataCollector this$0, BlockScopeVariableInfoImpl $blockScopeVariableInfo, Instruction instruction) {
        Intrinsics.checkNotNullParameter(instruction, "instruction");
        if (instruction instanceof VariableDeclarationInstruction) {
            KtDeclaration variableDeclarationElement = ((VariableDeclarationInstruction)instruction).getVariableDeclarationElement();
            DeclarationDescriptor declarationDescriptor = this$0.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, variableDeclarationElement);
            if (declarationDescriptor == null) {
                return Unit.INSTANCE;
            }
            DeclarationDescriptor descriptor = declarationDescriptor;
            VariableDescriptor variableDescriptor = BindingContextUtils.variableDescriptorForDeclaration(descriptor);
            if (variableDescriptor == null) {
                throw new AssertionError((Object)("Variable or class descriptor should correspond to the instruction for " + ((VariableDeclarationInstruction)instruction).getElement().getText() + ".\nDescriptor: " + descriptor));
            }
            VariableDescriptor variableDescriptor2 = variableDescriptor;
            $blockScopeVariableInfo.registerVariableDeclaredInScope(variableDescriptor2, ((VariableDeclarationInstruction)instruction).getBlockScope());
        }
        return Unit.INSTANCE;
    }
}

