/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.rcs;

import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.jrcs.diff.AddDelta;
import org.apache.commons.jrcs.diff.Chunk;
import org.apache.commons.jrcs.diff.DeleteDelta;
import org.apache.commons.jrcs.diff.Diff;
import org.apache.commons.jrcs.diff.PatchFailedException;
import org.apache.commons.jrcs.diff.Revision;
import org.apache.commons.jrcs.rcs.Archive;
import org.apache.commons.jrcs.rcs.BranchNode;
import org.apache.commons.jrcs.rcs.DeltaAddTextLine;
import org.apache.commons.jrcs.rcs.DeltaDelTextLine;
import org.apache.commons.jrcs.rcs.DeltaText;
import org.apache.commons.jrcs.rcs.InvalidFileFormatException;
import org.apache.commons.jrcs.rcs.InvalidVersionNumberException;
import org.apache.commons.jrcs.rcs.Line;
import org.apache.commons.jrcs.rcs.NodeNotFoundException;
import org.apache.commons.jrcs.rcs.Path;
import org.apache.commons.jrcs.rcs.Phrases;
import org.apache.commons.jrcs.rcs.TrunkNode;
import org.apache.commons.jrcs.rcs.Version;
import org.apache.commons.jrcs.util.ToString;

public abstract class Node
extends ToString
implements Comparable {
    protected final Version version;
    protected Date date = new Date();
    protected String author = System.getProperty("user.name");
    protected String state = "Exp";
    protected String log = "";
    protected String locker = "";
    protected Object[] text;
    protected Node rcsnext;
    protected Node parent;
    protected Node child;
    protected TreeMap branches = null;
    protected Phrases phrases = null;
    protected boolean endWithNewLine = true;
    protected static final Format dateFormatter = new MessageFormat("\t{0,number,##00}.{1,number,00}.{2,number,00}.{3,number,00}.{4,number,00}.{5,number,00}");
    protected static final DateFormat dateFormat = new SimpleDateFormat("yy.MM.dd.HH.mm.ss");
    protected static final DateFormat dateFormat2K = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");

    protected Node(Node node) {
        this(node.version, null);
        this.date = node.date;
        this.author = node.author;
        this.state = node.state;
        this.log = node.log;
        this.locker = node.locker;
    }

    protected Node(Version version, Node node) {
        if (version == null) {
            throw new IllegalArgumentException(version.toString());
        }
        this.version = (Version)version.clone();
        this.setRCSNext(node);
    }

    static Node newNode(Version version, Node node) throws InvalidVersionNumberException {
        if (version.isTrunk()) {
            return new TrunkNode(version, (TrunkNode)node);
        }
        return new BranchNode(version, (BranchNode)node);
    }

    static Node newNode(Version version) throws InvalidVersionNumberException {
        return Node.newNode(version, null);
    }

    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        if (!(object instanceof Node)) {
            return -1;
        }
        return this.version.compareTo(((Node)object).version);
    }

    public boolean isGhost() {
        return this.version.isGhost() || this.text == null;
    }

    public BranchNode getBranch(int n) {
        if (this.branches == null) {
            return null;
        }
        if (n == 0) {
            Integer n2 = (Integer)this.branches.lastKey();
            return n2 == null ? null : this.branches.get(n2);
        }
        return (BranchNode)this.branches.get(new Integer(n));
    }

    public Node root() {
        Node node = this;
        while (node.parent != null) {
            node = node.parent;
        }
        return node;
    }

    public void setLocker(String string) {
        this.locker = string.intern();
    }

    public void setAuthor(String string) {
        this.author = string.intern();
    }

    public void setDate(int[] nArray) {
        this.date = new GregorianCalendar(nArray[0] + (nArray[0] <= 99 ? 1900 : 0), nArray[1] - 1, nArray[2], nArray[3], nArray[4], nArray[5]).getTime();
    }

    public void setState(String string) {
        this.state = string;
    }

    public void setRCSNext(Node node) {
        this.rcsnext = node;
    }

    public void setLog(String string) {
        this.log = string.endsWith("\n") ? string.substring(0, string.length() - 1) : string;
    }

    public void setText(String string) {
        this.text = Diff.stringToArray(string);
        if (!string.endsWith("\n")) {
            this.endWithNewLine = false;
        }
    }

    public void setText(Object[] objectArray) {
        this.text = Arrays.asList(objectArray).toArray();
    }

    public void addBranch(BranchNode branchNode) throws InvalidVersionNumberException {
        if (branchNode.version.isLessThan(this.version) || branchNode.version.size() != this.version.size() + 2) {
            throw new InvalidVersionNumberException("version must be grater");
        }
        int n = branchNode.version.at(this.version.size());
        if (this.branches == null) {
            this.branches = new TreeMap();
        }
        this.branches.put(new Integer(n), branchNode);
        branchNode.parent = this;
    }

    public Version nextVersion() {
        return this.version.next();
    }

    public Version newBranchVersion() {
        Version version = new Version(this.version);
        if (this.branches == null || this.branches.size() <= 0) {
            version.__addBranch(1);
        } else {
            version.__addBranch((int)((Integer)this.branches.lastKey()));
        }
        version.__addBranch(1);
        return version;
    }

    public Node getRCSNext() {
        return this.rcsnext;
    }

    public Path pathTo(Version version) throws NodeNotFoundException {
        return this.pathTo(version, false);
    }

    public Path pathTo(Version version, boolean bl) throws NodeNotFoundException {
        Path path = new Path();
        Node node = this;
        do {
            path.add(node);
        } while ((node = node.nextInPathTo(version, bl)) != null);
        return path;
    }

    public abstract Node nextInPathTo(Version var1, boolean var2) throws NodeNotFoundException;

    public abstract Node deltaRevision();

    public void patch(List list) throws InvalidFileFormatException, PatchFailedException {
        this.patch(list, false);
    }

    public void patch(List list, boolean bl) throws InvalidFileFormatException, PatchFailedException {
        Revision revision = new Revision();
        for (int i = 0; i < this.text.length; ++i) {
            int n;
            int n2;
            char c;
            String string = this.text[i].toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "ad ", true);
            try {
                c = stringTokenizer.nextToken().charAt(0);
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                stringTokenizer.nextToken();
                n = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                throw new InvalidFileFormatException(this.version + ":line::" + exception.getMessage());
            }
            if (c == 'd') {
                revision.addDelta(new DeleteDelta(new Chunk(n2 - 1, n)));
                continue;
            }
            if (c == 'a') {
                revision.addDelta(new AddDelta(n2, new Chunk(this.getTextLines(i + 1, i + 1 + n), 0, n, n2 - 1)));
                i += n;
                continue;
            }
            throw new InvalidFileFormatException(this.version.toString());
        }
        revision.applyTo(list);
    }

    void newpatch(List list, boolean bl, Node node) throws InvalidFileFormatException {
        DeltaText deltaText = new DeltaText(node, this.child, bl);
        for (int i = 0; i < this.text.length; ++i) {
            try {
                char c = ((String)this.text[i]).charAt(0);
                Scanner scanner = new Scanner(((String)this.text[i]).substring(1));
                int n = scanner.nextInt();
                int n2 = scanner.nextInt();
                switch (c) {
                    case 'a': {
                        deltaText.addDeltaText(new DeltaAddTextLine(n, n2, this.text, i + 1));
                        i += n2;
                        break;
                    }
                    case 'd': {
                        deltaText.addDeltaText(new DeltaDelTextLine(n, n2));
                        break;
                    }
                    default: {
                        throw new InvalidFileFormatException("Expected 'a' or 'd', got: '" + c + "' while parsing deltatext for revision: " + this.version);
                    }
                }
                continue;
            }
            catch (Exception exception) {
                throw new InvalidFileFormatException("While parsing delta text for revision: " + this.version + ", got: " + exception.getMessage());
            }
        }
        deltaText.patch(list);
    }

    public void toString(StringBuffer stringBuffer) {
        this.toString(stringBuffer, "\n");
    }

    public void toString(StringBuffer stringBuffer, String string) {
        Comparable<Calendar> comparable;
        Object object;
        String string2 = ";" + string;
        String string3 = string + "\t";
        stringBuffer.append(string);
        stringBuffer.append(this.version.toString() + string);
        stringBuffer.append("date");
        if (this.date != null) {
            object = dateFormat;
            comparable = new GregorianCalendar();
            comparable.setTime(this.date);
            if (comparable.get(1) > 1999) {
                object = dateFormat2K;
            }
            stringBuffer.append("\t" + ((DateFormat)object).format(this.date));
        }
        stringBuffer.append(";\tauthor");
        if (this.author != null) {
            stringBuffer.append(" " + this.author);
        }
        stringBuffer.append(";\tstate");
        if (this.state != null) {
            stringBuffer.append(" ");
            stringBuffer.append(this.state);
        }
        stringBuffer.append(string2);
        stringBuffer.append("branches");
        if (this.branches != null) {
            object = this.branches.values().iterator();
            while (object.hasNext()) {
                comparable = (Node)object.next();
                if (comparable == null) continue;
                stringBuffer.append(string3 + ((Node)comparable).version);
            }
        }
        stringBuffer.append(string2);
        stringBuffer.append("next\t");
        if (this.rcsnext != null) {
            stringBuffer.append(this.rcsnext.version.toString());
        }
        stringBuffer.append(string2);
    }

    public String toText() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toText(stringBuffer, "\n");
        return stringBuffer.toString();
    }

    public void toText(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string + string);
        stringBuffer.append(this.version.toString() + string);
        stringBuffer.append("log" + string);
        if (this.log.length() == 0) {
            stringBuffer.append(Archive.quoteString(""));
        } else {
            stringBuffer.append(Archive.quoteString(this.log + string));
        }
        stringBuffer.append(string);
        if (this.phrases != null) {
            stringBuffer.append(this.phrases.toString());
        }
        stringBuffer.append("text" + string);
        if (this.endWithNewLine) {
            stringBuffer.append(Archive.quoteString(Node.arrayToString(this.text, string) + string));
        } else {
            stringBuffer.append(Archive.quoteString(Node.arrayToString(this.text, string)));
        }
        stringBuffer.append(string);
        if (this.branches != null) {
            Iterator iterator = this.branches.values().iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (node == null) continue;
                node.toText(stringBuffer, string);
            }
        }
    }

    public List getTextLines() {
        return this.getTextLines(new LinkedList());
    }

    public List getTextLines(int n, int n2) {
        return this.getTextLines(new LinkedList(), n, n2);
    }

    public List getTextLines(List list) {
        return this.getTextLines(list, 0, this.text.length);
    }

    public List getTextLines(List list, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            list.add(new Line(this.deltaRevision(), this.text[i]));
        }
        return list;
    }

    public final Date getDate() {
        return this.date;
    }

    public final String getAuthor() {
        return this.author;
    }

    public final String getState() {
        return this.state;
    }

    public final String getLog() {
        return this.log;
    }

    public final String getLocker() {
        return this.locker;
    }

    public final Object[] getText() {
        return this.text;
    }

    public final Node getChild() {
        return this.child;
    }

    public final TreeMap getBranches() {
        return this.branches;
    }

    public final Node getParent() {
        return this.parent;
    }

    public final Version getVersion() {
        return this.version;
    }

    public Phrases getPhrases() {
        return this.phrases;
    }
}

