/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.analysis.sql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public final class Consts {
    private static final Set<String> reservedKeywords;

    private Consts() {
    }

    private static void populateKeywordSet(Set<String> set, String file) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Consts.class.getResourceAsStream(file), "US-ASCII"));){
            String line;
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                String lline = line.toLowerCase(Locale.US);
                if (line.charAt(0) == '#') continue;
                set.add(line);
                set.add(lline);
            }
        }
    }

    static Set<String> getReservedKeywords() {
        return reservedKeywords;
    }

    static {
        HashSet<String> kwds = new HashSet<String>();
        try {
            Consts.populateKeywordSet(kwds, "sql2011reserved.dat");
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        reservedKeywords = Collections.unmodifiableSet(kwds);
    }
}

