from django.utils.translation import gettext_lazy as _

#: A list of Latvian municipalities and republican cities.
#: Identifiers based on ISO 3166-2:LV. https://en.wikipedia.org/wiki/ISO_3166-2:LV
MUNICIPALITY_CHOICES = (
    # Republican cities (not part of any municipality)
    ('DGV', _('Daugavpils')),
    ('JEL', _('Jelgava')),
    ('JUR', _('Jūrmala')),
    ('LPX', _('Liepāja')),
    ('REZ', _('Rēzekne')),
    ('RIX', _('Riga')),
    ('VEN', _('Ventspils')),
    # Municipalities
    ('002', _('Aizkraukle municipality')),
    ('007', _('Alūksne municipality')),
    ('011', _('Ādaži municipality')),
    ('015', _('Balvi municipality')),
    ('016', _('Bauska municipality')),
    ('022', _('Cēsis municipality')),
    ('026', _('Dobele municipality')),
    ('033', _('Gulbene municipality')),
    ('041', _('Jelgava municipality')),
    ('042', _('Jēkabpils municipality')),
    ('047', _('Krāslava municipality')),
    ('050', _('Kuldīga municipality')),
    ('052', _('Ķekava municipality')),
    ('054', _('Limbaži municipality')),
    ('056', _('Līvāni municipality')),
    ('058', _('Ludza municipality')),
    ('059', _('Madona municipality')),
    ('062', _('Mārupe municipality')),
    ('067', _('Ogre municipality')),
    ('068', _('Olaine municipality')),
    ('073', _('Preiļi municipality')),
    ('077', _('Rēzekne municipality')),
    ('080', _('Ropaži municipality')),
    ('087', _('Salaspils municipality')),
    ('088', _('Saldus municipality')),
    ('089', _('Saulkrasti municipality')),
    ('091', _('Sigulda municipality')),
    ('094', _('Smiltene municipality')),
    ('097', _('Talsi municipality')),
    ('099', _('Tukums municipality')),
    ('101', _('Valka municipality')),
    ('102', _('Varakļāni municipality')),
    ('106', _('Ventspils municipality')),
    ('111', _('Augšdaugava municipality')),
    ('112', _('Dienvidkurzeme municipality')),
    ('113', _('Valmiera municipality')),
)
