/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.search.BooleanOptionDescription;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class PublicMethodBasedOptionDescription
extends BooleanOptionDescription {
    private final String myGetterName;
    private final String mySetterName;

    public PublicMethodBasedOptionDescription(String option, String configurableId, String getterName, String setterName) {
        super(option, configurableId);
        this.myGetterName = getterName;
        this.mySetterName = setterName;
    }

    public abstract Object getInstance();

    protected void fireUpdated() {
    }

    @Override
    public boolean isOptionEnabled() {
        try {
            Method method = this.getInstance().getClass().getMethod(this.myGetterName, new Class[0]);
            Object object = method.invoke(this.getInstance(), new Object[0]);
            return object instanceof Boolean && (Boolean)object != false;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return false;
        }
    }

    @Override
    public void setOptionState(boolean enabled) {
        try {
            Method method = this.getInstance().getClass().getMethod(this.mySetterName, Boolean.TYPE);
            method.invoke(this.getInstance(), enabled);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        this.fireUpdated();
    }
}

