/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cloudconfig;

import com.jetbrains.cloudconfig.AbstractHttpClient;
import com.jetbrains.cloudconfig.Configuration;
import com.jetbrains.cloudconfig.ETagStorage;
import com.jetbrains.cloudconfig.MultiUploadRequest;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class CloudConfigFileClient
extends AbstractHttpClient {
    private static final String LINE_FEED = "\r\n";
    private final ETagStorage eTagStorage;
    private static final ETagStorage DUMMY_ETAG_STORAGE = new ETagStorage(){

        @Override
        public String get(String path) {
            return null;
        }

        @Override
        public void store(String path, String value) {
        }
    };

    public CloudConfigFileClient(String endpoint) {
        super(endpoint);
        this.eTagStorage = DUMMY_ETAG_STORAGE;
    }

    public CloudConfigFileClient(String endpoint, Configuration config, ETagStorage eTagStorage) {
        super(endpoint, config);
        this.eTagStorage = eTagStorage;
    }

    public InputStream read(final String file) throws IOException {
        return this.download("GET", this.url(file), (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("Content-Type", "application/octet-stream");
                String etag = CloudConfigFileClient.this.eTagStorage.get(file);
                if (etag != null) {
                    this.put("If-None-Match", etag);
                }
            }
        }, (statusCode, headers, stream) -> {
            if (statusCode == 304) {
                this.closeSafely(stream);
                return null;
            }
            this.saveEtag(headers, file);
            return stream;
        }, false);
    }

    public void write(String file, InputStream content) throws IOException {
        this.upload("PUT", this.url(file), (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("Content-Type", "application/octet-stream");
            }
        }, stream -> this.drainStream(content, stream), (statusCode, headers, stream) -> {
            this.saveEtag(headers, file);
            return null;
        }, 204);
    }

    public OutputStream write(String file) throws IOException {
        final HttpURLConnection connection = this.config.openConnection(this.url(file));
        connection.setRequestProperty("Content-Type", "application/octet-stream");
        connection.setRequestMethod("PUT");
        connection.setDoOutput(true);
        OutputStream out = connection.getOutputStream();
        return new BufferedOutputStream(out){
            private final AtomicBoolean closed;
            {
                super(x0);
                this.closed = new AtomicBoolean(false);
            }

            @Override
            public void close() throws IOException {
                if (this.closed.get() || !this.closed.compareAndSet(false, true)) {
                    return;
                }
                super.close();
                CloudConfigFileClient.this.assertSuccess(connection, 204);
            }
        };
    }

    public void write(String path, MultiUploadRequest request) throws IOException {
        if (request.getUploads().isEmpty()) {
            throw new IllegalArgumentException("Nothing to upload");
        }
        final String boundary = Long.toHexString(System.currentTimeMillis());
        this.upload("PUT", this.url(path), (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("Content-Type", "multipart/form-data; boundary=" + boundary);
            }
        }, out -> {
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(out));
            for (Map.Entry<String, InputStream> entry : request.getUploads().entrySet()) {
                String name = entry.getKey();
                InputStream content = entry.getValue();
                writer.append("--").append(boundary).append(LINE_FEED);
                writer.append("Content-Disposition: form-data; name=\"").append(name).append("\"; filename=\"").append(name).append("\"").append(LINE_FEED);
                writer.append("Content-Type: application/octet-stream").append(LINE_FEED);
                writer.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
                writer.append(LINE_FEED);
                writer.flush();
                this.drainStream(content, out);
                writer.append(LINE_FEED);
            }
            writer.append("--").append(boundary).append("--").append(LINE_FEED);
            writer.flush();
        }, (statusCode, headers, stream) -> {
            Map etags = (Map)GSON.fromJson((Reader)new InputStreamReader(stream), Map.class);
            for (Map.Entry entry : etags.entrySet()) {
                this.eTagStorage.store((String)entry.getKey(), (String)entry.getValue());
            }
            return null;
        }, 200);
    }

    public void delete(String file) throws IOException {
        HttpURLConnection connection = this.config.openConnection(this.url(file));
        connection.setRequestMethod("DELETE");
        this.assertSuccess(connection, 204);
    }

    public List<String> list(String file) throws IOException {
        return this.download("OPTIONS", this.url(file), Collections.emptyMap(), (statusCode, headers, stream) -> (List)GSON.fromJson((Reader)new InputStreamReader(stream), List.class), true);
    }

    private URL url(String path) throws IOException {
        return new URL(String.format("%s/%s", this.endpoint, path.replaceFirst("^/", "")));
    }

    private void saveEtag(Map<String, List<String>> headers, String file) {
        List<String> etag = headers.get("ETag");
        if (etag != null && etag.size() == 1) {
            this.eTagStorage.store(file, etag.get(0));
        }
    }
}

