/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import b.h.la;
import com.intellij.CommonBundle;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.MemoryDumpHelper;
import com.intellij.util.SystemProperties;
import com.yourkit.api.Controller;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProfilingUtil {
    private static final Logger e;
    private static final NotificationGroup f;
    private static final boolean b;
    private static final boolean d;
    private static Controller c;
    private static boolean a;
    private static final long g;

    public static void reinitialize() {
        try {
            c = new Controller();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static boolean hasValidController() {
        return c != null;
    }

    public static boolean supportsTracing() {
        return ProfilingUtil.hasValidController() && d;
    }

    public static boolean isCPUProfiling() {
        return a;
    }

    public static void startCPUProfiling() {
        ProfilingUtil.startCPUProfiling(false);
    }

    public static void startCPUProfiling(boolean withCounts) {
        long l2 = g ^ 0x734998500FB9L;
        if (ProfilingUtil.hasValidController()) {
            try {
                if (withCounts) {
                    c.startCPUTracing(null);
                } else {
                    c.startCPUSampling(null);
                }
                a = true;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        } else {
            e.warn("ProfilingUtil is disabled, add -agentlib:yjpagent to the command line");
        }
    }

    public static String captureCPUSnapshot() {
        long l2 = g ^ 0x451FD0C013BDL;
        if (ProfilingUtil.hasValidController()) {
            try {
                String string = c.captureSnapshot(0L);
                c.stopCPUProfiling();
                e.info("CPU snapshot is generated at " + string);
                a = false;
                return string;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return null;
    }

    public static boolean canCaptureMemorySnapshot() {
        long l2 = g ^ 0x120A0E5297EBL;
        boolean bl2 = Boolean.getBoolean("profile.yourkit");
        return !bl2 && MemoryDumpHelper.memoryDumpAvailable() || ProfilingUtil.hasValidController();
    }

    public static String captureMemorySnapshot() {
        long l2 = g ^ 0x40EA9998E528L;
        boolean bl2 = Boolean.getBoolean("profile.yourkit");
        if (!bl2 && MemoryDumpHelper.memoryDumpAvailable()) {
            try {
                File file = FileUtil.createTempFile((String)"heapDump.", (String)".hprof");
                FileUtil.delete((File)file);
                String string = file.getPath();
                MemoryDumpHelper.captureMemoryDump((String)string);
                return string;
            }
            catch (Exception exception) {
                if (!ProfilingUtil.hasValidController()) {
                    throw new RuntimeException(exception);
                }
                e.debug((Throwable)exception);
            }
        }
        if (ProfilingUtil.hasValidController()) {
            try {
                return c.captureMemorySnapshot();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        e.warn("ProfilingUtil is disabled, add -agentlib:yjpagent to the command line");
        return null;
    }

    public static boolean canCaptureAllocations() {
        return ProfilingUtil.hasValidController() && b;
    }

    public static void startRecordAllocations() {
        long l2 = g ^ 0x2D2759803AFAL;
        if (ProfilingUtil.canCaptureAllocations()) {
            try {
                c.startAllocationRecording("exactStacks,sizeLimit=4096,recordEach=1");
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static String stopRecordAllocations() {
        if (ProfilingUtil.canCaptureAllocations()) {
            try {
                String string = c.captureMemorySnapshot();
                c.stopAllocationRecording();
                return string;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return null;
    }

    @NotNull
    public static String formatSnapshotName() {
        long l2 = g ^ 0x33A5A5B3EB33L;
        String string = ApplicationInfo.getInstance().getBuild().asString();
        String string2 = SystemProperties.getUserName();
        String string3 = new SimpleDateFormat("dd.MM.yyyy_HH.mm.ss").format(new Date());
        String string4 = string + '_' + string2 + '_' + string3;
        if (string4 == null) {
            ProfilingUtil.a(0);
        }
        return string4;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static File compressSnapshot(@NotNull String dumpFilePath, @NotNull String snapshotName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void copySnapshotAndNotify(@Nullable String dumpPath, @Nullable Project project) throws IOException {
        long l2 = g ^ 0x1AC5FF34B1D8L;
        if (dumpPath == null) {
            return;
        }
        File file = ProfilingUtil.compressSnapshot(dumpPath, ProfilingUtil.formatSnapshotName());
        if (file == null) {
            return;
        }
        e.info("CPU snapshot is moved to " + file.getAbsolutePath());
        String string = ProfilingUtil.a(file);
        String string2 = CommonBundle.message((String)"profiling.capture.snapshot.success", (Object[])new Object[]{file.getName(), string, ShowFilePathAction.getFileManagerName()});
        f.createNotification("", string2, NotificationType.INFORMATION, ShowFilePathAction.FILE_SELECTING_LISTENER).notify(project);
    }

    private static String a(File file) {
        long l2 = g ^ 0x42CD8B3C9EC2L;
        try {
            return file.toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return "file://" + file.getAbsolutePath();
        }
    }

    public static void notifyCapturingError(@NotNull Throwable t2, @Nullable Project project) {
        long l2 = g ^ 0x1A59B098F332L;
        if (t2 == null) {
            ProfilingUtil.a(3);
        }
        e.warn(t2);
        String string = CommonBundle.message((String)"profiling.capture.snapshot.error", (Object[])new Object[]{t2.getMessage()});
        f.createNotification(string, NotificationType.ERROR).notify(project);
    }

    static {
        g = la.a(3761627983342312370L, -1281365964295910554L, MethodHandles.lookup().lookupClass()).a(156094218596307L);
        long l2 = g ^ 0x15EC8676C3CDL;
        e = Logger.getInstance((String)"#com.intellij.util.ProfilingUtil");
        f = new NotificationGroup("Profiling", NotificationDisplayType.BALLOON, false);
        Controller controller = null;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            for (String string : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
                if (!string.startsWith("-agentlib:yjpagent") && (!string.startsWith("-agentpath:") || !string.contains("yjpagent"))) continue;
                controller = new Controller();
                boolean bl4 = string.contains("disableall");
                bl2 = bl4 || string.contains("disablealloc");
                bl3 = bl4 || string.contains("disabletracing");
                break;
            }
            if (controller == null) {
                e.info("Profiling agent is not enabled. Add -agentlib:yjpagent to idea.vmoptions if necessary to profile IDEA.");
            }
        }
        catch (Throwable throwable) {
            e.warn("YourKit controller initialization failed : " + throwable.getMessage(), throwable.getCause());
        }
        c = controller;
        b = !bl2;
        d = !bl3;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = g ^ 0x69DDEBF365AAL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ProfilingUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumpFilePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshotName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "formatSnapshotName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ProfilingUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "compressSnapshot";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "notifyCapturingError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

