/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.inspection;

import b.h.la;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.i18n.I18nTranslateCallType;
import org.jetbrains.plugins.ruby.i18n.dictionary.I18nDictionary;
import org.jetbrains.plugins.ruby.i18n.inspection.quickfixes.I18nCreatePropertyQuickFix;
import org.jetbrains.plugins.ruby.i18n.locales.LocaleEntry;
import org.jetbrains.plugins.ruby.i18n.namesValidator.I18nKeyNamesValidator;
import org.jetbrains.plugins.ruby.i18n.references.I18nTranslateReference;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;

public class I18nKeyInspectionVisitor
extends RubyInspectionVisitor {
    private static final long b = la.a(-4455158927646428538L, -3627363827434052486L, MethodHandles.lookup().lookupClass()).a(169152353528343L);

    public I18nKeyInspectionVisitor(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            I18nKeyInspectionVisitor.d(0);
        }
        super(holder);
    }

    @Override
    public void visitRCall(RCall rCall) {
        long l2 = b ^ 0x4D7E36D0CC67L;
        RubyCallType rubyCallType = rCall.getCallType();
        if (!(rubyCallType instanceof I18nTranslateCallType)) {
            return;
        }
        List list2 = rCall.getArguments();
        if (list2.isEmpty()) {
            this.registerProblem((PsiElement)rCall, RBundle.message((String)"inspection.rails.i18n.translate.call.wrong.arguments"));
            return;
        }
        for (PsiReference psiReference : rubyCallType.createReferences((RPossibleCall)rCall, list2)) {
            I18nTranslateReference i18nTranslateReference = (I18nTranslateReference)psiReference;
            String string2 = i18nTranslateReference.getCanonicalText();
            if (!I18nKeyNamesValidator.isValidKeyName(string2)) {
                this.registerProblem(i18nTranslateReference.getArgument(), RBundle.message((String)"inspection.rails.i18n.wrong.key.format", (Object[])new Object[]{string2}));
                continue;
            }
            I18nDictionary i18nDictionary = i18nTranslateReference.getDictionary();
            Collection<LocaleEntry> collection = i18nDictionary.getAllLocaleEntries();
            ResolveResult[] resolveResultArray = i18nTranslateReference.multiResolve(false);
            if (resolveResultArray.length == 0) {
                if (collection.isEmpty()) {
                    this.registerProblem(i18nTranslateReference.getArgument(), RBundle.message((String)"inspection.rails.i18n.key.not.found", (Object[])new Object[]{string2}));
                    continue;
                }
                this.registerProblem(i18nTranslateReference.getArgument(), RBundle.message((String)"inspection.rails.i18n.key.not.found", (Object[])new Object[]{string2}), new I18nCreatePropertyQuickFix());
                continue;
            }
            HashSet hashSet = new HashSet();
            i18nTranslateReference.getFullKeys().forEach(string -> hashSet.addAll(i18nDictionary.getLocalesByKey((String)string)));
            if (i18nDictionary.getAllLocales().size() <= hashSet.size()) continue;
            this.registerProblem(i18nTranslateReference.getArgument(), RBundle.message((String)"inspection.rails.i18n.key.not.defined", (Object[])new Object[]{string2}), ProblemHighlightType.WEAK_WARNING, new I18nCreatePropertyQuickFix());
        }
    }

    private static /* synthetic */ void d(int n2) {
        long l2 = b ^ 0x70F077169180L;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/ruby/i18n/inspection/I18nKeyInspectionVisitor", "<init>"));
    }
}

