/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.autoupload;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.jetbrains.plugins.webDeployment.AutoUploadComponent;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AutoUploader {
    @NotNull
    private final Project myProject;
    private PublishConfig myPublishConfig;
    private final WebServerConfig myServer;
    private final LinkedList<TransferOperation> myQueue;
    private final Map<TransferOperation, String> myExcludedPaths;
    private ProgressIndicator myProgressIndicator;

    AutoUploader(@NotNull Project project, PublishConfig publishConfig, WebServerConfig server) {
        if (project == null) {
            AutoUploader.$$$reportNull$$$0(0);
        }
        this.myQueue = new LinkedList();
        this.myExcludedPaths = new HashMap<TransferOperation, String>();
        this.myPublishConfig = publishConfig;
        this.myServer = server;
        this.myProject = project;
    }

    public WebServerConfig getServer() {
        return this.myServer;
    }

    public synchronized void stopUpload() {
        if (this.myProgressIndicator != null) {
            this.myProgressIndicator.cancel();
        }
    }

    public synchronized void setConfig(PublishConfig publishConfig) {
        this.myPublishConfig = publishConfig.clone();
        this.stopUpload();
    }

    @Nullable
    private synchronized WebServerConfig.RemotePath getDeployPath(String localPath, @Nullable Ref<String> excludedPathRef) {
        Pair<DeploymentPathMapping, Boolean> mappingPair = this.myPublishConfig.getNearestMappingForLocal(localPath, false, true, false, (Mappable)this.myServer);
        if (mappingPair.getFirst() == null) {
            if (excludedPathRef != null && Boolean.TRUE == mappingPair.getSecond()) {
                excludedPathRef.set((Object)localPath);
            }
            return null;
        }
        WebServerConfig.RemotePath remotePath = ((DeploymentPathMapping)mappingPair.getFirst()).mapToDeployPath(localPath, (Mappable)this.myServer);
        if (PublishConfig.isRemotePathExcluded(remotePath, (Mappable)this.myServer, this.myPublishConfig)) {
            if (excludedPathRef != null) {
                excludedPathRef.set((Object)remotePath.path);
            }
            return null;
        }
        return remotePath;
    }

    void handlePropertyChangeEvent(VirtualFilePropertyEvent event, boolean sourceMuted, boolean targetMuted, String oldPath, String newPath) {
        WebServerConfig.RemotePath remoteNewPath;
        String excludedPath = null;
        Ref excluded = new Ref();
        WebServerConfig.RemotePath remoteOldPath = this.getDeployPath(oldPath, (Ref<String>)excluded);
        if (remoteOldPath == null && !excluded.isNull()) {
            excludedPath = (String)excluded.get();
            excluded.set(null);
        }
        if ((remoteNewPath = this.getDeployPath(newPath, (Ref<String>)excluded)) == null && !excluded.isNull()) {
            excludedPath = (String)excluded.get();
        }
        if (remoteOldPath == null && remoteNewPath == null) {
            return;
        }
        if (remoteOldPath == null) {
            if (!targetMuted) {
                this.onCreate(newPath, event.getFile().isDirectory(), true, excludedPath);
            }
        } else if (remoteNewPath == null) {
            if (!sourceMuted) {
                this.onDelete(oldPath, event.getFile().isDirectory(), excludedPath);
            }
        } else if (sourceMuted && !targetMuted) {
            this.onCreate(newPath, event.getFile().isDirectory(), true, excludedPath);
        } else if (!sourceMuted && targetMuted) {
            this.onDelete(oldPath, event.getFile().isDirectory(), excludedPath);
        } else if (!sourceMuted && !targetMuted) {
            this.onMove(oldPath, newPath, event.getFile().isDirectory(), excludedPath);
        }
    }

    void handleFileMovedEvent(VirtualFileMoveEvent event, boolean sourceMuted, boolean targetMuted, String oldPath, String newPath) {
        WebServerConfig.RemotePath remoteNewPath;
        String excludedPath = null;
        Ref excluded = new Ref();
        WebServerConfig.RemotePath remoteOldPath = this.getDeployPath(oldPath, (Ref<String>)excluded);
        if (remoteOldPath == null && !excluded.isNull()) {
            excludedPath = (String)excluded.get();
            excluded.set(null);
        }
        if ((remoteNewPath = this.getDeployPath(newPath, (Ref<String>)excluded)) == null && !excluded.isNull()) {
            excludedPath = (String)excluded.get();
            excluded.set(null);
        }
        if (remoteOldPath == null && remoteNewPath == null) {
            return;
        }
        if (remoteOldPath == null) {
            if (!targetMuted) {
                this.onCreate(newPath, event.getFile().isDirectory(), true, excludedPath);
            }
        } else if (remoteNewPath == null) {
            if (!sourceMuted) {
                this.onDelete(oldPath, event.getFile().isDirectory(), excludedPath);
            }
        } else {
            if (!targetMuted && sourceMuted) {
                this.onCreate(newPath, event.getFile().isDirectory(), true, excludedPath);
            }
            if (!sourceMuted && targetMuted) {
                this.onDelete(oldPath, event.getFile().isDirectory(), excludedPath);
            }
            if (!sourceMuted && !targetMuted) {
                this.onMove(oldPath, newPath, event.getFile().isDirectory(), excludedPath);
            }
        }
    }

    synchronized void onCreate(String path, boolean isDirectory, boolean recursive, @Nullable String excludedPath) {
        WebServerConfig.RemotePath remotePath = this.getDeployPath(path, null);
        if (remotePath == null) {
            return;
        }
        if (isDirectory) {
            if (recursive) {
                this.offerTransferOperation(new CopyFolder(path, remotePath){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void handle(List<TransferOperation> newOperations) {
                        AutoUploader autoUploader = AutoUploader.this;
                        synchronized (autoUploader) {
                            AutoUploader.this.myQueue.addAll(newOperations);
                        }
                    }
                }, excludedPath);
            } else {
                this.offerTransferOperation(new TransferOperation.CreateFolder(this.getDeployPath(path, null)), excludedPath);
            }
        } else {
            this.offerTransferOperation(new TransferOperation.Copy(DeploymentPathUtils.getLocalFile(path), this.getDeployPath(path, null)), excludedPath);
        }
        this.ensureTaskRunning();
    }

    synchronized void onFileModified(String path) {
        WebServerConfig.RemotePath targetPath = this.getDeployPath(path, null);
        if (targetPath == null) {
            return;
        }
        this.offerTransferOperation(new TransferOperation.Copy(DeploymentPathUtils.getLocalFile(path), targetPath), null);
        this.ensureTaskRunning();
    }

    private synchronized void onMove(String oldPath, String newPath, boolean isDirectory, @Nullable String excludedPath) {
        if (oldPath.equals(newPath)) {
            return;
        }
        for (TransferOperation operation : this.myQueue) {
            try {
                operation.onLocalMove(DeploymentPathUtils.getLocalFile(oldPath), DeploymentPathUtils.getLocalFile(newPath));
            }
            catch (FileSystemException e) {
                AutoUploadComponent.LOG.error((Throwable)e);
            }
        }
        this.offerTransferOperation(new TransferOperation.RemoteMoveOrUpload(newPath, this.getDeployPath(oldPath, null), this.getDeployPath(newPath, null), isDirectory), excludedPath);
        this.ensureTaskRunning();
    }

    synchronized void onDelete(String path, boolean isDirectory, @Nullable String excludedPath) {
        WebServerConfig.RemotePath remotePath = this.getDeployPath(path, null);
        if (remotePath == null) {
            return;
        }
        this.offerTransferOperation(new TransferOperation.Delete(remotePath, isDirectory, true), excludedPath);
        this.ensureTaskRunning();
    }

    private void offerTransferOperation(TransferOperation e, @Nullable String excludedFolders) {
        this.myQueue.offer(e);
        if (excludedFolders != null) {
            this.myExcludedPaths.put(e, excludedFolders);
        }
    }

    private void ensureTaskRunning() {
        if (!this.myQueue.isEmpty() && this.myProgressIndicator == null) {
            String title = WDBundle.message("auto.upload.task.title", new Object[0]);
            FileTransferToolWindow.printWithTimestamp(this.myProject, this.myServer, title, ConsoleViewContentType.SYSTEM_OUTPUT, this.myPublishConfig.getTraceLevel());
            new TransferTask(this.myProject, ConnectionOwnerFactory.createConnectionOwner(this.myProject), true, this.myPublishConfig, Deployable.create(this.myServer), title, false, true, true, ProjectDeploymentRevisionTracker.getInstance(this.myProject)){
                private int myProcessed;
                {
                    this.myProcessed = 0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run(@NotNull ProgressIndicator pi) {
                    ArrayList operations;
                    if (pi == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    AutoUploader autoUploader = AutoUploader.this;
                    synchronized (autoUploader) {
                        if (AutoUploader.this.myProgressIndicator != null) {
                            return;
                        }
                        AutoUploader.this.myProgressIndicator = pi;
                        operations = new ArrayList(AutoUploader.this.myQueue);
                    }
                    try {
                        this.doRun(pi);
                    }
                    finally {
                        autoUploader = AutoUploader.this;
                        synchronized (autoUploader) {
                            AutoUploader.this.myQueue.removeAll(operations);
                            AutoUploader.this.myProgressIndicator = null;
                        }
                    }
                }

                @Override
                protected boolean isMultipleOperations() {
                    return true;
                }

                @Override
                protected boolean prepareOperations(ExecutionContext context) {
                    for (int i = 0; i < AutoUploader.this.myExcludedPaths.size(); ++i) {
                        context.incCounter("transfer.details.excluded");
                    }
                    return true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected TransferOperation getNextOperation() {
                    AutoUploader autoUploader = AutoUploader.this;
                    synchronized (autoUploader) {
                        TransferOperation info = (TransferOperation)AutoUploader.this.myQueue.poll();
                        if (info == null) {
                            return null;
                        }
                        ++this.myProcessed;
                        String excludedPath = (String)AutoUploader.this.myExcludedPaths.remove(info);
                        if (excludedPath != null) {
                            this.print(WDBundle.message("excluded.message", excludedPath), ConsoleViewContentType.NORMAL_OUTPUT);
                        }
                        return info;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected int getDoneStepsNumber() {
                    AutoUploader autoUploader = AutoUploader.this;
                    synchronized (autoUploader) {
                        return this.myProcessed - 1;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected int getTotalStepsNumber() {
                    AutoUploader autoUploader = AutoUploader.this;
                    synchronized (autoUploader) {
                        return this.myProcessed + AutoUploader.this.myQueue.size();
                    }
                }

                @Override
                protected void assertAllExecuted(int totalProcessed, int failed) {
                }

                @Override
                protected void showBalloon(MessageType type, String text, boolean isSummary) {
                    if (isSummary ? type != MessageType.INFO : type == MessageType.ERROR) {
                        super.showBalloon(type, text, isSummary);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/webDeployment/autoupload/AutoUploader$2", "run"));
                }
            }.queue();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/autoupload/AutoUploader", "<init>"));
    }

    private static abstract class CopyFolder
    extends TransferOperation {
        private String mySourcePath;
        private final WebServerConfig.RemotePath myTargetPath;

        protected abstract void handle(List<TransferOperation> var1);

        private CopyFolder(String sourcePath, WebServerConfig.RemotePath targetPath) {
            this.mySourcePath = sourcePath;
            this.myTargetPath = targetPath;
        }

        @Override
        public String getProgressText(ExecutionContext context) {
            return WDBundle.message("collecting.files", new Object[0]);
        }

        @Override
        public String getDetailedText(ExecutionContext context) {
            return WDBundle.message("preparing.upload.0.to.1", this.mySourcePath, context.getServer().getPresentablePath(this.myTargetPath));
        }

        @Override
        public void execute(ExecutionContext context) throws FileSystemException {
            FileObject source = DeploymentPathUtils.getLocalFile(this.mySourcePath);
            ArrayList<TransferOperation> newOperations = new ArrayList<TransferOperation>();
            DeploymentPathUtils.ErrorsAndExclusions errors = DeploymentPathUtils.processOutgoing(source, newOperations, context);
            for (String error : errors.getReadOnlyErrors()) {
                FileTransferToolWindow.printWithTimestamp(context.getProject(), context.getServer(), error, ConsoleViewContentType.SYSTEM_OUTPUT, context.getConfig().getTraceLevel());
            }
            for (String path : errors.getReadOnlyPaths()) {
                FileTransferToolWindow.printWithTimestamp(context.getProject(), context.getServer(), WDBundle.message("excluded.message", path), ConsoleViewContentType.NORMAL_OUTPUT, context.getConfig().getTraceLevel());
            }
            this.handle(newOperations);
        }

        @Override
        public String getErrorMessage(ExecutionContext serverConfig, String reason) {
            return WDBundle.message("preparing.upload.failed", this.mySourcePath, reason);
        }

        @Override
        public void onLocalMove(FileObject sourceFrom, FileObject sourceTo) {
            this.mySourcePath = CopyFolder.updateOnParentMove(this.mySourcePath, sourceFrom, sourceTo, SystemInfo.isFileSystemCaseSensitive);
        }
    }
}

