/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.AbstractUpdateEnvironment;
import org.jetbrains.idea.perforce.application.FileGrouper;
import org.jetbrains.idea.perforce.application.PerforceIntegratePanel;
import org.jetbrains.idea.perforce.application.PerforcePanel;
import org.jetbrains.idea.perforce.application.PerforceUpdateConfigurable;
import org.jetbrains.idea.perforce.perforce.ExecResult;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.ParticularConnectionSettings;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;

public class PerforceIntegrateEnvironment
extends AbstractUpdateEnvironment {
    @NonNls
    private static final Map<String, String> ourPatternToGroupId = new HashMap<String, String>();
    @NonNls
    private static final String INTEGRATED = "INTEGRATED";
    @NonNls
    private static final String CANT_INTEGRATE = "CANT_INTEGRATE";
    @NonNls
    @VisibleForTesting
    public static final String BRANCHED = "BRANCHED";

    public PerforceIntegrateEnvironment(Project project) {
        super(project);
    }

    public void fillGroups(UpdatedFiles updatedFiles) {
        updatedFiles.registerGroup(new FileGroup(PerforceBundle.message((String)"integrate.group.name.integrated", (Object[])new Object[0]), PerforceBundle.message((String)"integrate.group.name.integrated", (Object[])new Object[0]), false, INTEGRATED, false));
        updatedFiles.registerGroup(new FileGroup(PerforceBundle.message((String)"integrate.group.name.cant.integrate", (Object[])new Object[0]), PerforceBundle.message((String)"integrate.group.name.cant.integrate", (Object[])new Object[0]), false, CANT_INTEGRATE, false));
        updatedFiles.registerGroup(new FileGroup(PerforceBundle.message((String)"integrate.group.name.branched", (Object[])new Object[0]), PerforceBundle.message((String)"integrate.group.name.branched", (Object[])new Object[0]), false, BRANCHED, false));
    }

    @Override
    protected boolean isTryToResolveAutomatically(PerforceSettings settings) {
        return settings.INTEGRATE_RUN_RESOLVE;
    }

    @Override
    protected Map<String, String> getPatternToGroupId() {
        return ourPatternToGroupId;
    }

    @Override
    protected boolean isRevertUnchanged(PerforceSettings settings) {
        return settings.INTEGRATE_REVERT_UNCHANGED;
    }

    @Override
    protected ExecResult performUpdate(P4File p4Dir, PerforceSettings settings) throws VcsException {
        P4Connection connection = PerforceConnectionManager.getInstance(this.myProject).getConnectionForFile(p4Dir);
        if (connection == null) {
            throw new VcsException("Invalid Perforce settings for " + p4Dir.getLocalPath());
        }
        ParticularConnectionSettings connectionSettings = settings.getSettings(connection);
        String integrateChangeListNum = connectionSettings.INTEGRATE_CHANGE_LIST ? connectionSettings.INTEGRATED_CHANGE_LIST_NUMBER : null;
        return this.myRunner.integrate(connectionSettings.INTEGRATE_BRANCH_NAME, p4Dir, connectionSettings.INTEGRATE_TO_CHANGELIST_NUM, integrateChangeListNum, connectionSettings.INTEGRATE_REVERSE, connection);
    }

    public Configurable createConfigurable(Collection<FilePath> files) {
        final MultiMap<P4Connection, File> connectionToFiles = FileGrouper.distributeIoFilesByConnection(PerforceIntegrateEnvironment.convertToFiles(files), PerforceSettings.getSettings(this.myProject).getProject());
        return new PerforceUpdateConfigurable(PerforceSettings.getSettings(this.myProject)){

            @Override
            protected PerforcePanel createPanel() {
                return new PerforceIntegratePanel(PerforceIntegrateEnvironment.this.myProject, new ArrayList(connectionToFiles.keySet()));
            }

            @Override
            public String getHelpTopic() {
                return "reference.dialogs.versionControl.integrate.project.perforce";
            }
        };
    }

    private static Collection<File> convertToFiles(Collection<FilePath> files) {
        ArrayList<File> result = new ArrayList<File>();
        for (FilePath filePath : files) {
            result.add(filePath.getIOFile());
        }
        return result;
    }

    public boolean validateOptions(Collection<FilePath> roots) {
        return true;
    }

    static {
        ourPatternToGroupId.put(" - integrate from ", INTEGRATED);
        ourPatternToGroupId.put(" - sync/integrate from ", INTEGRATED);
        ourPatternToGroupId.put(" - can't integrate (already opened on this client)", CANT_INTEGRATE);
        ourPatternToGroupId.put(" - branch/sync from ", BRANCHED);
    }
}

