/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DatabaseArtifactManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverListener;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.url.template.UrlTemplate;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="LocalDatabaseDriverManager", storages={@Storage(value="databaseDrivers.xml")})
public class DatabaseDriverManagerImpl
extends DatabaseDriverManager
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(DatabaseDriverManagerImpl.class);
    private static final String VERSION_PRE_141 = null;
    private static final String VERSION_141 = "141+";
    private static final String VERSION_LATEST = "163";
    public static final String URL_DRIVERS_LOCATION = "resources/database-drivers.xml";
    private final Map<String, DatabaseDriverImpl> myDrivers = ContainerUtil.newLinkedHashMap();
    private final Map<String, DatabaseDriverImpl> myPredefinedDrivers = ContainerUtil.newLinkedHashMap();
    private final EventDispatcher<DatabaseDriverListener> myDispatcher = EventDispatcher.create(DatabaseDriverListener.class);
    private static final Map<String, String> MIGRATION_MAP = ContainerUtil.newHashMap((Pair)Pair.create((Object)"sqlite.zentus", (Object)"sqlite.xerial"), (Pair[])new Pair[]{Pair.create((Object)"h2.embedded", (Object)"h2.unified"), Pair.create((Object)"h2.in-memory", (Object)"h2.unified"), Pair.create((Object)"h2.remote", (Object)"h2.unified"), Pair.create((Object)"hsqldb.embedded", (Object)"hsqldb.local"), Pair.create((Object)"hsqldb.in-memory", (Object)"hsqldb.local")});

    public void dump(@NotNull StringBuilder sb) {
        if (sb == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(0);
        }
        ArrayList drivers = ContainerUtil.newArrayList(this.getDrivers());
        Collections.sort(drivers, (o1, o2) -> Comparing.compare((Comparable)((Object)o1.getId()), (Comparable)((Object)o2.getId())));
        for (DatabaseDriverImpl driver : drivers) {
            driver.dump(sb);
            sb.append("\n----\n");
        }
    }

    public static DatabaseDriverManagerImpl create(@NotNull String file) throws MalformedURLException {
        if (file == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(1);
        }
        return new DatabaseDriverManagerImpl(new File(file).toURI().toURL());
    }

    public DatabaseDriverManagerImpl() {
        this(DatabaseDriverManagerImpl.getPredefinedLocation());
    }

    @Nullable
    private static URL getPredefinedLocation() {
        return DatabaseDriverManagerImpl.class.getClassLoader().getResource(URL_DRIVERS_LOCATION);
    }

    private DatabaseDriverManagerImpl(@Nullable URL url) {
        try {
            if (url != null) {
                this.loadLatest(JDOMUtil.load((URL)url), false, true, VERSION_LATEST);
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        for (DatabaseDriverImpl driver : this.myDrivers.values()) {
            if (!driver.isPredefined()) continue;
            DatabaseDriverImpl backup = new DatabaseDriverImpl(driver.getId(), true);
            backup.loadState(driver.getState(null), false, true, Integer.MAX_VALUE);
            this.myPredefinedDrivers.put(backup.getId(), backup);
        }
        DatabaseArtifactManager.getInstance().addListener((artifactName, artifactVersion) -> {
            for (DatabaseDriverImpl driver : this.myDrivers.values()) {
                DatabaseDriver.ArtifactRef artifact = driver.getArtifact();
                if (artifact == null || artifactName != null && (!artifactName.equals(artifact.getName()) || !Comparing.equal((String)artifactVersion, (String)artifact.getVersion()))) continue;
                ((DatabaseDriverListener)this.myDispatcher.getMulticaster()).driverUpdated(driver);
            }
        }, null);
    }

    @NotNull
    private DatabaseDriverImpl addDriver(@NotNull DatabaseDriverImpl driver) {
        if (driver == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(2);
        }
        this.myDrivers.put(driver.getId(), driver);
        ((DatabaseDriverListener)this.getDispatcher().getMulticaster()).driverAdded(driver);
        DatabaseDriverImpl databaseDriverImpl = driver;
        if (databaseDriverImpl == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(3);
        }
        return databaseDriverImpl;
    }

    private void removeDriver(@NotNull String id) {
        DatabaseDriverImpl driver;
        if (id == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(4);
        }
        if ((driver = this.myDrivers.remove(id)) != null) {
            ((DatabaseDriverListener)this.getDispatcher().getMulticaster()).driverRemoved(driver);
        }
    }

    @NotNull
    private static List<Element> getDrivers(@NotNull Element state) {
        if (state == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(5);
        }
        List list = state.getChildren("driver");
        if (list == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    private static String getDriverId(@NotNull Element state) {
        String id;
        if (state == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(7);
        }
        return StringUtil.isEmpty((String)(id = state.getAttributeValue("id"))) || id.equals("odbc.sun") ? null : id;
    }

    @Nullable
    private DatabaseDriverImpl getOrCreateDriver(@NotNull String id, boolean predefined, boolean create) {
        DatabaseDriverImpl driver;
        if (id == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(8);
        }
        if ((driver = this.myDrivers.get(id)) == null && create) {
            driver = this.addDriver(new DatabaseDriverImpl(id, predefined));
        }
        return driver;
    }

    private void loadLatest(@NotNull Element state, boolean merge, boolean predefined, String version) {
        if (state == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(9);
        }
        int ver = DatabaseDriverManagerImpl.parseVersion(version);
        for (Element driverState : DatabaseDriverManagerImpl.getDrivers(state)) {
            String id = DatabaseDriverManagerImpl.getDriverId(driverState);
            DatabaseDriverImpl driver = id == null ? null : this.getOrCreateDriver(id, predefined, true);
            if (driver == null) continue;
            driver.loadState(driverState, merge, true, ver);
        }
    }

    private static int parseVersion(String version) {
        Matcher matcher = Pattern.compile("\\d+").matcher(version);
        try {
            if (matcher.find()) {
                return Integer.parseInt(version);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0;
    }

    private void loadPre141(@NotNull Element state, boolean merge, boolean predefined) {
        if (state == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(10);
        }
        this.loadPre141Impl(state, merge, new ArrayList<Element>(), predefined);
    }

    private void loadPre141Impl(@NotNull Element state, boolean merge, @NotNull List<Element> parents, boolean predefined) {
        if (state == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(11);
        }
        if (parents == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(12);
        }
        for (Element driverState : DatabaseDriverManagerImpl.getDrivers(state)) {
            boolean instantiable;
            String id = DatabaseDriverManagerImpl.getDriverId(driverState);
            DatabaseDriverImpl driver = null;
            boolean bl = instantiable = driverState.getChild("driver") == null && !MIGRATION_MAP.containsKey(id);
            if (id != null) {
                driver = this.getOrCreateDriver(id, predefined, instantiable);
            }
            parents.add(driverState);
            if (driver != null) {
                boolean submerge = merge;
                for (Element parent2 : parents) {
                    driver.loadState(parent2, submerge, false, 0);
                    submerge = true;
                }
            }
            this.loadPre141Impl(driverState, merge, parents, predefined);
            parents.remove(parents.size() - 1);
        }
    }

    EventDispatcher<DatabaseDriverListener> getDispatcher() {
        return this.myDispatcher;
    }

    @Nullable
    public Element getState() {
        Element result2 = new Element("LocalDatabaseDriverManager");
        result2.setAttribute("version", VERSION_LATEST);
        for (DatabaseDriverImpl driver : this.myDrivers.values()) {
            result2.addContent(driver.getState(this.myPredefinedDrivers.get(driver.getId())));
        }
        return result2;
    }

    public void loadState(@NotNull Element state) {
        String version;
        if (state == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(13);
        }
        if (Comparing.equal((String)(version = state.getAttributeValue("version")), (String)VERSION_PRE_141)) {
            this.loadPre141(state, true, false);
        } else if (Comparing.equal((String)version, (String)VERSION_141) || Comparing.equal((String)version, (String)VERSION_LATEST)) {
            this.loadLatest(state, true, false, version);
        } else {
            LOG.warn("Unknown drivers format version: " + version + "\nWon't load.");
        }
    }

    public Collection<DatabaseDriverImpl> getDrivers() {
        return Collections.unmodifiableCollection(this.myDrivers.values());
    }

    @Override
    public DatabaseDriverImpl getDriver(String id) {
        return this.myDrivers.get(StringUtil.notNullize((String)MIGRATION_MAP.get(id), (String)id));
    }

    @Override
    @NotNull
    public DatabaseDriverImpl createDriver(String name, String driverClass, UrlTemplate urlTemplate) {
        String driverId = driverClass;
        if (this.getDriver(driverId) != null) {
            driverId = null;
        }
        DatabaseDriverImpl databaseDriverImpl = new DatabaseDriverImpl(driverId, name, driverClass, urlTemplate);
        if (databaseDriverImpl == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(14);
        }
        return databaseDriverImpl;
    }

    @Override
    public void resetToPredefined(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(15);
        }
        DatabaseDriverImpl result2 = (DatabaseDriverImpl)driver;
        DatabaseDriverImpl backup = this.myPredefinedDrivers.get(driver.getId());
        ArrayList classPath = ContainerUtil.newArrayList(result2.getAdditionalClasspathElements());
        result2.loadState(backup.getState(null), false, true, Integer.MAX_VALUE);
        result2.setAdditionalClasspathElements(classPath);
    }

    @Override
    public boolean isInPredefinedState(@NotNull DatabaseDriver driver) {
        DatabaseDriverImpl backup;
        if (driver == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(16);
        }
        return (backup = this.myPredefinedDrivers.get(driver.getId())) == null || ((DatabaseDriverImpl)driver).equalConfiguration(backup, true);
    }

    @Override
    @Nullable
    public String getPredefinedArtifact(@NotNull String id) {
        DatabaseDriverImpl driver;
        if (id == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(17);
        }
        DatabaseDriver.ArtifactRef ref = (driver = this.myPredefinedDrivers.get(id)) == null ? null : driver.getArtifact();
        return ref == null ? null : ref.getName();
    }

    @Override
    public void updateDriver(@NotNull DatabaseDriver driver) {
        DatabaseDriverImpl driverImpl;
        if (driver == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(18);
        }
        if (!this.myDrivers.containsKey((driverImpl = (DatabaseDriverImpl)driver).getId())) {
            this.addDriver(driverImpl);
        }
    }

    @Override
    public void removeDriver(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(19);
        }
        if (this.myDrivers.containsKey(driver.getId())) {
            this.removeDriver(driver.getId());
        }
    }

    @Override
    public void addDriverListener(@NotNull DatabaseDriverListener listener, @NotNull Disposable parent2) {
        if (listener == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(20);
        }
        if (parent2 == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(21);
        }
        this.myDispatcher.addListener((EventListener)listener, parent2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 3: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseDriverManagerImpl";
                break;
            }
            case 4: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseDriverManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "addDriver";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDrivers";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createDriver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "dump";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addDriver";
                break;
            }
            case 3: 
            case 6: 
            case 14: {
                break;
            }
            case 4: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeDriver";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDrivers";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDriverId";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateDriver";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadLatest";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadPre141";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadPre141Impl";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resetToPredefined";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isInPredefinedState";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedArtifact";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "updateDriver";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addDriverListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

