/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.ChangeDialectAction;
import com.intellij.sql.dialects.SqlDialectsConfigurable;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeSqlDialectIntentionFix
extends IntentionAndQuickFixAction {
    @NotNull
    public String getName() {
        String string = this.getFamilyName();
        if (string == null) {
            ChangeSqlDialectIntentionFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = SqlMessages.message("quickfix.change.dialect.family.text", new Object[0]);
        if (string == null) {
            ChangeSqlDialectIntentionFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
        VirtualFile virtualFile;
        if (project == null) {
            ChangeSqlDialectIntentionFix.$$$reportNull$$$0(2);
        }
        if ((virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file)) == null) {
            return;
        }
        if (!ChangeDialectAction.FILE_FILTER(project).value((Object)virtualFile)) {
            SqlDialectsConfigurable.openDialectsConfigurable(project, file.getVirtualFile());
        } else {
            ListPopup popup = ChangeDialectAction.buildDialectsPopup(project, (JBIterable<? extends VirtualFile>)JBIterable.of((Object)virtualFile));
            if (editor != null) {
                popup.showInBestPositionFor(editor);
            } else {
                popup.showInFocusCenter();
            }
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/editor/ChangeSqlDialectIntentionFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/editor/ChangeSqlDialectIntentionFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

