/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.jetbrains.idea.svn.auth.CertificateAuthenticationData;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.UsernamePasswordCallback;

public class TwoWaySslCallback
extends UsernamePasswordCallback {
    private static final String ACCESS_TO_PREFIX = "Access to ";
    private static final String FORBIDDEN_STATUS = "forbidden";

    TwoWaySslCallback(@NotNull AuthenticationService authenticationService, Url url) {
        if (authenticationService == null) {
            TwoWaySslCallback.$$$reportNull$$$0(0);
        }
        super(authenticationService, url);
    }

    @Override
    public boolean canHandle(String error) {
        return error.contains(ACCESS_TO_PREFIX) && error.contains(FORBIDDEN_STATUS);
    }

    @Override
    public String getType() {
        return "svn.ssl.client-passphrase";
    }

    @Override
    public void updateParameters(@NotNull Command command) {
        if (command == null) {
            TwoWaySslCallback.$$$reportNull$$$0(1);
        }
        if (this.myAuthentication instanceof CertificateAuthenticationData) {
            CertificateAuthenticationData auth = (CertificateAuthenticationData)this.myAuthentication;
            command.put("--config-option");
            command.put("servers:global:ssl-client-cert-file=" + auth.getCertificatePath());
            command.put("--config-option");
            command.put("servers:global:ssl-client-cert-password=" + auth.getCertificatePassword());
            if (!auth.isStorageAllowed()) {
                command.put("--no-auth-cache");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authenticationService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/commandLine/TwoWaySslCallback";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateParameters";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

