/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.TrailingSpacesStripper;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.editorconfig.Utils;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.plugincomponents.SettingsProviderComponent;
import org.jetbrains.annotations.NotNull;

public class DocumentSettingsManager
implements FileDocumentManagerListener {
    public static final String trimTrailingWhitespaceKey = "trim_trailing_whitespace";
    public static final String insertFinalNewlineKey = "insert_final_newline";
    private static final Map<String, Boolean> newlineMap;
    private final Project myProject;

    public DocumentSettingsManager(Project project) {
        this.myProject = project;
    }

    public void beforeDocumentSaving(@NotNull Document document) {
        if (document == null) {
            DocumentSettingsManager.$$$reportNull$$$0(0);
        }
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        this.applySettings(file);
    }

    private void applySettings(VirtualFile file) {
        if (file == null) {
            return;
        }
        if (!Utils.isEnabled(CodeStyleSettingsManager.getInstance((Project)this.myProject).getCurrentSettings())) {
            file.putUserData(TrailingSpacesStripper.OVERRIDE_STRIP_TRAILING_SPACES_KEY, null);
            file.putUserData(TrailingSpacesStripper.OVERRIDE_ENSURE_NEWLINE_KEY, null);
            return;
        }
        List<EditorConfig.OutPair> outPairs = SettingsProviderComponent.getInstance().getOutPairs(this.myProject, file);
        String trimTrailingWhitespace = Utils.configValueForKey(outPairs, trimTrailingWhitespaceKey);
        this.applyConfigValueToUserData(file, TrailingSpacesStripper.OVERRIDE_STRIP_TRAILING_SPACES_KEY, trimTrailingWhitespaceKey, trimTrailingWhitespace, DocumentSettingsManager.getTrimMap());
        String insertFinalNewline = Utils.configValueForKey(outPairs, insertFinalNewlineKey);
        this.applyConfigValueToUserData(file, TrailingSpacesStripper.OVERRIDE_ENSURE_NEWLINE_KEY, insertFinalNewlineKey, insertFinalNewline, newlineMap);
    }

    private static Map<String, String> getTrimMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        String stripSpaces = EditorSettingsExternalizable.getInstance().getStripTrailingSpaces();
        String stripValue = "None".equals(stripSpaces) ? "Whole" : stripSpaces;
        map.put("true", stripValue);
        map.put("false", "None");
        return map;
    }

    private <T> void applyConfigValueToUserData(VirtualFile file, Key<T> userDataKey, String editorConfigKey, String configValue, Map<String, T> configMap) {
        if (configValue.isEmpty()) {
            file.putUserData(userDataKey, null);
            return;
        }
        T data = configMap.get(configValue);
        if (data == null) {
            Utils.invalidConfigMessage(this.myProject, configValue, editorConfigKey, file.getCanonicalPath());
        } else {
            file.putUserData(userDataKey, data);
        }
    }

    static {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("true", Boolean.TRUE);
        map.put("false", Boolean.FALSE);
        newlineMap = Collections.unmodifiableMap(map);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/editorconfig/configmanagement/DocumentSettingsManager", "beforeDocumentSaving"));
    }
}

