/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.gem.dependency;

import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.diagram.gem.dependency.DummyGemInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

public class GemDependencyVfsResolver
implements DiagramVfsResolver<GemInfo> {
    public String getQualifiedName(GemInfo element) {
        if (element instanceof DummyGemInfo) {
            return "#" + ((DummyGemInfo)element).getModule().getName();
        }
        return element.getName();
    }

    @Nullable
    public GemInfo resolveElementByFQN(String fqn, Project project) {
        GemInfo gemInfo = null;
        if (fqn.startsWith("#")) {
            String moduleName = fqn.substring(1);
            Module module = ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
            if (module != null) {
                Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
                gemInfo = new DummyGemInfo("Dummy", sdk, module);
            }
        } else {
            Module module = RModuleUtil.getInstance().getModuleWithRubySupport(project);
            if (module != null) {
                gemInfo = GemManager.findGem((Module)module, (String)fqn);
            }
        }
        return gemInfo;
    }
}

