/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.json.adapters;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.lsp4j.jsonrpc.json.adapters.TypeUtils;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Either3;

public class EitherTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        if (!TypeUtils.isEither(typeToken.getType())) {
            return null;
        }
        return new Adapter(gson, typeToken);
    }

    protected static class EitherTypeArgument<T> {
        protected final TypeToken<T> token;
        protected final TypeAdapter<T> adapter;
        protected final Collection<JsonToken> expectedTokens;

        public EitherTypeArgument(Gson gson, Type type) {
            this.token = TypeToken.get((Type)type);
            this.adapter = gson.getAdapter(this.token);
            this.expectedTokens = new HashSet<JsonToken>();
            for (Type expectedType : TypeUtils.getExpectedTypes(type)) {
                Class rawType = TypeToken.get((Type)expectedType).getRawType();
                JsonToken expectedToken = this.getExpectedToken(rawType);
                this.expectedTokens.add(expectedToken);
            }
        }

        protected JsonToken getExpectedToken(Class<?> rawType) {
            if (rawType.isArray() || Collection.class.isAssignableFrom(rawType)) {
                return JsonToken.BEGIN_ARRAY;
            }
            if (Boolean.class.isAssignableFrom(rawType)) {
                return JsonToken.BOOLEAN;
            }
            if (Number.class.isAssignableFrom(rawType) || Enum.class.isAssignableFrom(rawType)) {
                return JsonToken.NUMBER;
            }
            if (Character.class.isAssignableFrom(rawType) || String.class.isAssignableFrom(rawType)) {
                return JsonToken.STRING;
            }
            return JsonToken.BEGIN_OBJECT;
        }

        public boolean isAssignable(JsonToken token) {
            return this.expectedTokens.contains(token);
        }

        public void write(JsonWriter out, T value) throws IOException {
            this.adapter.write(out, value);
        }

        public T read(JsonReader in) throws IOException {
            return (T)this.adapter.read(in);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (JsonToken expectedToken : this.expectedTokens) {
                if (builder.length() != 0) {
                    builder.append(" | ");
                }
                builder.append(expectedToken);
            }
            return builder.toString();
        }
    }

    protected static class Adapter<L, R>
    extends TypeAdapter<Either<L, R>> {
        protected final TypeToken<Either<L, R>> typeToken;
        protected final EitherTypeArgument<L> left;
        protected final EitherTypeArgument<R> right;

        public Adapter(Gson gson, TypeToken<Either<L, R>> typeToken) {
            this.typeToken = typeToken;
            Type[] elementTypes = TypeUtils.getElementTypes(typeToken, Either.class);
            this.left = new EitherTypeArgument(gson, elementTypes[0]);
            this.right = new EitherTypeArgument(gson, elementTypes[1]);
        }

        public void write(JsonWriter out, Either<L, R> value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else if (value.isLeft()) {
                this.left.write(out, value.getLeft());
            } else {
                this.right.write(out, value.getRight());
            }
        }

        public Either<L, R> read(JsonReader in) throws IOException {
            JsonToken next = in.peek();
            if (next == JsonToken.NULL) {
                return null;
            }
            Either<L, R> result = this.create(next, in);
            if (result == null) {
                throw new IOException("Unexpected token " + next + ", expected " + this.left + " | " + this.right + " tokens.");
            }
            return result;
        }

        protected Either<L, R> create(JsonToken nextToken, JsonReader in) throws IOException {
            if (this.left.isAssignable(nextToken)) {
                if (Either3.class.isAssignableFrom(this.typeToken.getRawType())) {
                    return Either3.forLeft3(this.left.read(in));
                }
                return Either.forLeft(this.left.read(in));
            }
            if (this.right.isAssignable(nextToken)) {
                if (Either3.class.isAssignableFrom(this.typeToken.getRawType())) {
                    return Either3.forRight3((Either)this.right.read(in));
                }
                return Either.forRight(this.right.read(in));
            }
            return null;
        }
    }
}

