/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.javascript.nodejs.NodeUIUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRefList;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRenderer;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreterType;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreterType;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListUtil;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsInterpretersDialog
extends DialogWrapper {
    private static final String DIMENSION_SERVICE_KEY = "jetbrains.nodejs.interpreters-dialog";
    private static final String HELP_ID = "jetbrains.nodejs.interpreters-dialog.helpId";
    private final Project myProject;
    private final DefaultListModel<NodeJsInterpreterRef> myListModel;
    private final JBList<NodeJsInterpreterRef> myList;
    private final boolean myWithRemote;
    private final JComponent myCenterPanelComponent;
    private final boolean myProjectDefaultField;
    private final NodeJsInterpreterRef myPrevProjectInterpreterRef;
    private final Map<NodeJsInterpreterRef, NodeJsInterpreter> myChangesMap;

    public NodeJsInterpretersDialog(@NotNull Project project, boolean projectDefaultField, boolean withRemote) {
        if (project == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(0);
        }
        super(project, true);
        this.myChangesMap = ContainerUtil.newHashMap();
        this.myProject = project;
        this.myWithRemote = withRemote;
        this.myListModel = new DefaultListModel();
        this.myList = new JBList(this.myListModel);
        this.myList.setSelectionMode(2);
        this.myList.getEmptyText().setText(NodeJsInterpretersDialog.getEmptyText());
        this.myList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row;
                if (e.isPopupTrigger() && (row = NodeJsInterpretersDialog.this.myList.locationToIndex(e.getPoint())) >= 0) {
                    NodeJsInterpretersDialog.this.myList.setSelectedIndex(row);
                }
            }
        });
        this.myProjectDefaultField = projectDefaultField;
        this.myPrevProjectInterpreterRef = projectDefaultField ? null : NodeJsInterpreterManager.getInstance(project).getInterpreterRef();
        this.myList.setCellRenderer((ListCellRenderer)new NodeJsInterpreterRenderer(project, false));
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myList).setAddAction(button -> this.performAddAction((AnActionButton)button)).setRemoveAction(button -> ListUtil.removeSelectedItems(this.myList, interpreterRef -> interpreterRef != null && interpreterRef.isConstantRef())).setRemoveActionUpdater(e -> {
            NodeJsInterpreterRef ref = (NodeJsInterpreterRef)this.myList.getSelectedValue();
            return ref != null && ref.isConstantRef();
        }).setEditAction(button -> this.editSelected()).setEditActionUpdater(e -> this.isEditAvailable()).disableUpDownActions();
        decorator.setPanelBorder(IdeBorderFactory.createBorder((int)10));
        JPanel decoratorPanel = decorator.createPanel();
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                if (NodeJsInterpretersDialog.this.isEditAvailable()) {
                    NodeJsInterpretersDialog.this.editSelected();
                    return true;
                }
                return false;
            }
        }.installOn(this.myList);
        decoratorPanel.setPreferredSize((Dimension)JBUI.size((int)550, (int)300));
        JScrollPane pane = JBScrollPane.findScrollPane(this.myList);
        if (pane != null) {
            pane.setHorizontalScrollBarPolicy(31);
        }
        this.myCenterPanelComponent = decoratorPanel;
        this.setTitle("Node.js Interpreters");
        this.init();
        this.configurePopupHandler();
        this.fillList();
    }

    private void configurePopupHandler() {
        ArrayList actionList = ContainerUtil.newArrayList();
        if (!this.myProjectDefaultField) {
            actionList.add(new SetAsProjectDefaultInterpreterAction());
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup((List)actionList);
        for (AnAction action : actionList) {
            action.registerCustomShortcutSet(action.getShortcutSet(), this.myList);
        }
        PopupHandler.installPopupHandler(this.myList, (ActionGroup)actionGroup, (String)"unknown", (ActionManager)ActionManager.getInstance());
    }

    @Nullable
    private NodeJsInterpreterRef getSingleSelectedInterpreterRef() {
        if (this.myList.getMinSelectionIndex() != this.myList.getMaxSelectionIndex()) {
            return null;
        }
        return (NodeJsInterpreterRef)this.myList.getSelectedValue();
    }

    private boolean isEditAvailable() {
        NodeJsInterpreterRef interpreterRef = this.getSingleSelectedInterpreterRef();
        return interpreterRef != null && interpreterRef.isConstantRef();
    }

    private void editSelected() {
        NodeJsInterpreterRef interpreterRef;
        int selectedInd = this.myList.getSelectedIndex();
        if (selectedInd >= 0 && (interpreterRef = this.myListModel.getElementAt(selectedInd)) != null && interpreterRef.isConstantRef()) {
            NodeJsInterpreter interpreter = interpreterRef.resolve(this.myProject);
            if (interpreter == null) {
                return;
            }
            NodeJsInterpreterType<? extends NodeJsInterpreter> interpreterType = interpreter.getType();
            NodeJsInterpreter newInterpreter = interpreterType.edit(this.myProject, interpreter);
            if (newInterpreter != null) {
                NodeJsInterpreterRef newInterpreterRef = newInterpreter.toRef();
                int index = this.myListModel.indexOf(newInterpreterRef);
                if (index != -1 && index != selectedInd) {
                    this.myList.setSelectedIndex(index);
                    selectedInd = index;
                }
                this.myListModel.set(selectedInd, newInterpreterRef);
                this.myChangesMap.put(newInterpreterRef, newInterpreter);
            } else {
                NodeUIUtil.balloonInfo(this.myProject, "Cannot edit selected Node.js interpreter", this.myList.getLocationOnScreen(), MessageType.ERROR);
            }
        }
    }

    private void fillList() {
        NodeJsInterpreterRefList list = NodeJsInterpreterRefList.create(this.myWithRemote);
        List<NodeJsInterpreterRef> refs = list.getAllAvailableAsRefs(!this.myProjectDefaultField);
        for (NodeJsInterpreterRef ref : refs) {
            this.myListModel.addElement(ref);
        }
    }

    @NotNull
    private static String getEmptyText() {
        ShortcutSet shortcutSet = CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.ADD);
        Shortcut shortcut = (Shortcut)ArrayUtil.getFirstElement((Object[])shortcutSet.getShortcuts());
        if (shortcut != null) {
            String string = "Add interpreter with " + KeymapUtil.getShortcutText((Shortcut)shortcut);
            if (string == null) {
                NodeJsInterpretersDialog.$$$reportNull$$$0(1);
            }
            return string;
        }
        if ("No interpreters added" == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(2);
        }
        return "No interpreters added";
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(3);
        }
        return dialogStyle;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return DIMENSION_SERVICE_KEY;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myCenterPanelComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    @Nullable
    protected String getHelpId() {
        return HELP_ID;
    }

    @NotNull
    private List<NodeJsInterpreterType> getTypes() {
        List<NodeJsInterpreterType> list = NodeJsInterpreterRefList.getTypes(this.myWithRemote);
        if (list == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private List<NodeJsInterpreterRef> getInterpreterRefs() {
        ArrayList interpreterRefs = ContainerUtil.newArrayList();
        for (int i = 0; i < this.myListModel.size(); ++i) {
            NodeJsInterpreterRef interpreterRef = this.myListModel.elementAt(i);
            if (interpreterRef == null) continue;
            interpreterRefs.add(interpreterRef);
        }
        ArrayList arrayList = interpreterRefs;
        if (arrayList == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private void performAddAction(@NotNull AnActionButton button) {
        if (button == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(6);
        }
        JBPopup popup = NodeJsInterpretersDialog.createAddPopup(this.myProject, this.myWithRemote, button.getDataContext(), (Consumer<? super NodeJsInterpreter>)((Consumer)interpreter -> {
            NodeJsInterpreterRef interpreterRef = interpreter.toRef();
            this.myChangesMap.put(interpreterRef, (NodeJsInterpreter)interpreter);
            this.addIfNeededAndSelect(interpreterRef);
        }));
        RelativePoint point = button.getPreferredPopupPoint();
        if (point != null) {
            popup.show(point);
        } else {
            popup.showInBestPositionFor(button.getDataContext());
        }
    }

    @NotNull
    public static JBPopup createAddPopup(@NotNull Project project, boolean withRemote, @NotNull DataContext dataContext, @NotNull Consumer<? super NodeJsInterpreter> callback) {
        if (project == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(7);
        }
        if (dataContext == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(8);
        }
        if (callback == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(9);
        }
        ArrayList types = ContainerUtil.newArrayList((Object[])new NodeJsInterpreterType[]{NodeJsLocalInterpreterType.getInstance()});
        if (withRemote) {
            types.add(NodeJsRemoteInterpreterType.getInstance());
        }
        if (WslNodeInterpreterType.getInstance().isAvailable()) {
            types.add(WslNodeInterpreterType.getInstance());
        }
        DefaultActionGroup group = new DefaultActionGroup();
        for (NodeJsInterpreterType type : types) {
            group.add((AnAction)new AddInterpreterTypeAction(project, type, callback));
        }
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, dataContext, false, true, true, null, -1, null);
        if (listPopup == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(10);
        }
        return listPopup;
    }

    @Nullable
    public Ref<NodeJsInterpreterRef> showAndGetSelected(@Nullable NodeJsInterpreterRef interpreterToAddAndSelect) {
        if (interpreterToAddAndSelect != null && !interpreterToAddAndSelect.equals(NodeJsInterpreterField.NO_INTERPRETER_REF)) {
            this.addIfNeededAndSelect(interpreterToAddAndSelect);
        } else {
            this.myList.clearSelection();
        }
        if (this.showAndGet()) {
            MultiMap group = MultiMap.create();
            for (NodeJsInterpreterType type : this.getTypes()) {
                group.put((Object)type, (Collection)ContainerUtil.newArrayList());
            }
            List<NodeJsInterpreterRef> shownInterpreterRefs = this.getInterpreterRefs();
            for (NodeJsInterpreterRef interpreterRef : shownInterpreterRefs) {
                if (!interpreterRef.isConstantRef()) continue;
                NodeJsInterpreter interpreter = this.myChangesMap.get(interpreterRef);
                if (interpreter == null) {
                    interpreter = interpreterRef.resolve(this.myProject);
                }
                if (interpreter == null) continue;
                group.putValue(interpreter.getType(), (Object)interpreter);
            }
            for (Map.Entry entry : group.entrySet()) {
                NodeJsInterpreterType type = (NodeJsInterpreterType)entry.getKey();
                type.setInterpreters(ContainerUtil.newArrayList((Iterable)((Iterable)entry.getValue())));
            }
            return Ref.create((Object)this.myList.getSelectedValue());
        }
        if (this.myPrevProjectInterpreterRef != null) {
            NodeJsInterpreterManager.getInstance(this.myProject).setInterpreterRef(this.myPrevProjectInterpreterRef);
        }
        return null;
    }

    private void addIfNeededAndSelect(@NotNull NodeJsInterpreterRef interpreterRef) {
        int index;
        if (interpreterRef == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(11);
        }
        if ((index = this.myListModel.indexOf(interpreterRef)) == -1) {
            this.myListModel.addElement(interpreterRef);
            index = this.myListModel.size() - 1;
        }
        this.myList.setSelectedIndex(index);
        int finalIndex = index;
        UiNotifyConnector.doWhenFirstShown(this.myList, () -> ScrollingUtil.ensureIndexIsVisible(this.myList, (int)finalIndex, (int)1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterRefs";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createAddPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performAddAction";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAddPopup";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addIfNeededAndSelect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SetAsProjectDefaultInterpreterAction
    extends DumbAwareAction {
        protected SetAsProjectDefaultInterpreterAction() {
            super("Set as Project Interpreter");
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SetAsProjectDefaultInterpreterAction.$$$reportNull$$$0(0);
            }
            NodeJsInterpreterRef interpreterRef = NodeJsInterpretersDialog.this.getSingleSelectedInterpreterRef();
            e.getPresentation().setEnabledAndVisible(this.canUseAsProjectDefaultInterpreterRef(interpreterRef));
        }

        @Contract(value="null -> false")
        private boolean canUseAsProjectDefaultInterpreterRef(@Nullable NodeJsInterpreterRef interpreterRef) {
            if (interpreterRef == null || interpreterRef.isProjectRef()) {
                return false;
            }
            NodeJsInterpreter interpreter = interpreterRef.resolve(NodeJsInterpretersDialog.this.myProject);
            return interpreter instanceof NodeJsLocalInterpreter;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            NodeJsInterpreterRef interpreterRef;
            if (e == null) {
                SetAsProjectDefaultInterpreterAction.$$$reportNull$$$0(1);
            }
            if (this.canUseAsProjectDefaultInterpreterRef(interpreterRef = NodeJsInterpretersDialog.this.getSingleSelectedInterpreterRef())) {
                NodeJsInterpreterManager.getInstance(NodeJsInterpretersDialog.this.myProject).setInterpreterRef(interpreterRef);
                NodeJsInterpretersDialog.this.myList.repaint();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog$SetAsProjectDefaultInterpreterAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AddInterpreterTypeAction
    extends DumbAwareAction {
        private final Project myProject;
        private final NodeJsInterpreterType myType;
        private final Consumer<? super NodeJsInterpreter> myCallback;

        AddInterpreterTypeAction(@NotNull Project project, @NotNull NodeJsInterpreterType type, @NotNull Consumer<? super NodeJsInterpreter> callback) {
            if (project == null) {
                AddInterpreterTypeAction.$$$reportNull$$$0(0);
            }
            if (type == null) {
                AddInterpreterTypeAction.$$$reportNull$$$0(1);
            }
            if (callback == null) {
                AddInterpreterTypeAction.$$$reportNull$$$0(2);
            }
            super("Add " + StringUtil.capitalize((String)type.getName()) + "...");
            this.myProject = project;
            this.myType = type;
            this.myCallback = callback;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object addedInterpreter;
            if (e == null) {
                AddInterpreterTypeAction.$$$reportNull$$$0(3);
            }
            if ((addedInterpreter = this.myType.showAddDialog(this.myProject)) != null) {
                this.myCallback.consume(addedInterpreter);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddInterpreterTypeAction.$$$reportNull$$$0(4);
            }
            boolean available = this.myType.isAvailable();
            e.getPresentation().setEnabledAndVisible(available);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog$AddInterpreterTypeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

