/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.resolve;

import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptContextualTypeEvaluator;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.ES6QualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluatorBase;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.JavaScriptQualifiedItemProcessor;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeEvaluationFunction;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeSubstitutorType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeWithOuterGenerics;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericDeclarationTypeImpl;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericParameterImpl;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptGenericTypesEvaluator
extends JSGenericTypesEvaluatorBase {
    private static final TypeScriptGenericTypesEvaluator INSTANCE = new TypeScriptGenericTypesEvaluator();

    private TypeScriptGenericTypesEvaluator() {
    }

    public static TypeScriptGenericTypesEvaluator getInstance() {
        return INSTANCE;
    }

    @Override
    public final JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext context) {
        PsiElement element;
        if (context == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(0);
        }
        if (!TypeScriptGenericTypesEvaluator.canHaveGenericParameters(type) || methodExpression == null) {
            return type;
        }
        if (resolvedFunction == null && (resolvedFunction = type.getSourceElement()) instanceof JSDocComment && (element = JSStubBasedPsiTreeUtil.findAssociatedElement((JSDocComment)resolvedFunction)) != null) {
            resolvedFunction = element;
        }
        if (!TypeScriptGenericTypesEvaluator.checkNeedGenericsApplying(type = (JSType)this.getJSQualifierGenericsRemapper(methodExpression).fun((Object)type))) {
            return type;
        }
        boolean isCallContext = TypeScriptGenericTypesEvaluator.isCallContext(methodExpression);
        JSTypeSubstitutor substitutor = this.getAllGenericTypeSubstitutor(methodExpression, resolvedFunction, resolvedFunction, isCallContext, context);
        return JSTypeUtils.applyGenericArguments(type, substitutor, isCallContext, context.reporter);
    }

    private static boolean isCallContext(@NotNull JSExpression methodExpression) {
        PsiElement parent;
        if (methodExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(1);
        }
        return (parent = methodExpression.getParent()) instanceof JSCallExpression || parent instanceof ES6TaggedTemplateExpression;
    }

    @Override
    @NotNull
    public final JSGenericTypeEvaluationFunction getEvaluationFunction(@Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunctionOrField, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext context) {
        if (context == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(2);
        }
        if (methodExpression == null) {
            JSGenericTypeEvaluationFunction jSGenericTypeEvaluationFunction = JSGenericTypeEvaluationFunction.SELF;
            if (jSGenericTypeEvaluationFunction == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(3);
            }
            return jSGenericTypeEvaluationFunction;
        }
        NotNullLazyValue qualifierGenericTypeEvaluator = NotNullLazyValue.createValue(() -> this.getJSQualifierGenericsRemapper(methodExpression));
        boolean isCallContext = TypeScriptGenericTypesEvaluator.isCallContext(methodExpression);
        NotNullLazyValue substitutor = NotNullLazyValue.createValue(() -> {
            if (context == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(121);
            }
            return this.getAllGenericTypeSubstitutor(methodExpression, resolvedFunctionOrField, resolvedFunctionOrField, isCallContext, context);
        });
        JSGenericTypeEvaluationFunction jSGenericTypeEvaluationFunction = type -> {
            if (context == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(120);
            }
            if (!TypeScriptGenericTypesEvaluator.canHaveGenericParameters(type)) {
                return type;
            }
            type = (JSType)((Function.Mono)qualifierGenericTypeEvaluator.getValue()).fun((Object)type);
            if (!TypeScriptGenericTypesEvaluator.checkNeedGenericsApplying(type)) {
                return type;
            }
            return JSTypeUtils.applyGenericArguments(type, (JSTypeSubstitutor)substitutor.getValue(), isCallContext, context.reporter);
        };
        if (jSGenericTypeEvaluationFunction == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(4);
        }
        return jSGenericTypeEvaluationFunction;
    }

    @NotNull
    private JSTypeSubstitutor getAllGenericTypeSubstitutor(@NotNull JSExpression methodExpression, @Nullable PsiElement resolvedFunctionOrField, @Nullable PsiElement resolvedContext, boolean isCall, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext context) {
        JSTypeSubstitutor callSubstitutor;
        JSExpression qualifier;
        if (methodExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(5);
        }
        if (context == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(6);
        }
        JSTypeSubstitutor explicit = JSTypeSubstitutor.EMPTY;
        resolvedFunctionOrField = TypeScriptGenericTypesEvaluator.getResolvedFunction(methodExpression, resolvedFunctionOrField);
        if (methodExpression instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)methodExpression).getQualifier()) != null) {
            explicit = this.getQualifierTypeSubstitutor(qualifier, methodExpression, resolvedContext, resolvedFunctionOrField);
        }
        PsiElement callExpression = methodExpression.getParent();
        explicit = explicit.combine(TypeScriptGenericTypesEvaluator.getCallExplicitTypeSubstitutor(resolvedFunctionOrField, callExpression, JSTypeSubstitutor.EMPTY));
        explicit = explicit.combine(TypeScriptGenericTypesEvaluator.getSuperExpressionTypeSubstitutor(methodExpression, resolvedFunctionOrField));
        if (resolvedFunctionOrField != null && isCall && !(callSubstitutor = this.getInferredCallLikeTypeSubstitutor(methodExpression, resolvedFunctionOrField, context, explicit)).isEmpty()) {
            JSTypeSubstitutor callWithApplied = JSTypeSubstitutor.combineWithApplying((JSTypeSubstitutor)explicit, (JSTypeSubstitutor)callSubstitutor, JSTypeUtils::applyGenericArguments);
            JSTypeSubstitutor jSTypeSubstitutor = callWithApplied.combine(explicit);
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(7);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = explicit;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(8);
        }
        return jSTypeSubstitutor;
    }

    @Override
    @NotNull
    public JSType evaluateGenericsFromQualifier(@NotNull JSType type, @NotNull JSExpression qualifier, @NotNull JSExpression methodExpression) {
        if (type == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(9);
        }
        if (qualifier == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(10);
        }
        if (methodExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(11);
        }
        Function.Mono<JSType> mapper = this.getJSQualifierGenericsRemapper(methodExpression);
        JSTypeSubstitutor substitutor = this.getQualifierTypeSubstitutor(qualifier, methodExpression, type.getSourceElement(), null);
        JSType jSType = JSTypeUtils.applyGenericArguments((JSType)mapper.fun((Object)type), substitutor);
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(12);
        }
        return jSType;
    }

    private static boolean checkNeedGenericsApplying(@Nullable JSType startType) {
        if (!TypeScriptGenericTypesEvaluator.canHaveGenericParameters(startType)) {
            return false;
        }
        boolean hasThisOrGenericType = JSTypeUtils.hasTypes(startType, JSGenericParameterImpl.class, TypeScriptGenericThisTypeImpl.class);
        if (!hasThisOrGenericType) {
            if (!(startType instanceof JSResolvableType)) {
                return true;
            }
            JSResolvableType jsType = (JSResolvableType)startType;
            JSResolvedTypeInfo resolvedType = jsType.resolveType();
            if (!resolvedType.isLocal()) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    private JSTypeSubstitutor getQualifierTypeSubstitutor(@NotNull JSExpression qualifier, @NotNull JSExpression methodExpression, @Nullable PsiElement sourceElement, @Nullable PsiElement resolvedFunction) {
        JSType qualifierType;
        if (qualifier == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(13);
        }
        if (methodExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(14);
        }
        if ((qualifierType = JSResolveUtil.getElementJSType((PsiElement)qualifier, JSEvaluateContext.JSEvaluationPlace.QUALIFIER)) == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(15);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = this.getQualifierTypeSubstitutor(qualifierType, (PsiElement)methodExpression, resolvedFunction, sourceElement);
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(16);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public JSTypeSubstitutor getQualifierTypeSubstitutor(@Nullable JSType qualifierType, @NotNull PsiElement methodExpression, @Nullable PsiElement resolvedFunction, @Nullable PsiElement sourceElement) {
        if (methodExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(17);
        }
        if (qualifierType == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(18);
            }
            return jSTypeSubstitutor;
        }
        sourceElement = sourceElement != null && sourceElement.isValid() ? sourceElement : (PsiElement)ObjectUtils.coalesce((Object)resolvedFunction, (Object)methodExpression);
        JSType expanded = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(qualifierType);
        JSTypeSubstitutor result2 = new JSTypeSubstitutor();
        result2.putAll(this.getTypeSubstitutorForQualifierType(expanded, sourceElement, methodExpression));
        result2.putAll(TypeScriptGenericTypesEvaluator.getTypeSubstitutorForExplicitThisParameterType((Getter<? extends JSType>)((Getter)() -> expanded), resolvedFunction));
        if (qualifierType.isTypeScript() && (!(qualifierType instanceof JSRecordType) || TypeScriptGenericTypesEvaluator.isApplicableRecordTypeForThis((JSRecordType)qualifierType))) {
            result2.put(TypeScriptGenericThisTypeImpl.createThisTypeGenericId(qualifierType), qualifierType);
        }
        JSTypeSubstitutor jSTypeSubstitutor = result2;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(19);
        }
        return jSTypeSubstitutor;
    }

    private static boolean isApplicableRecordTypeForThis(@NotNull JSRecordType recordType) {
        if (recordType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(20);
        }
        if (!(recordType instanceof JSSimpleRecordTypeImpl)) {
            return false;
        }
        PsiElement sourceElement = recordType.getSource().getSourceElement();
        return sourceElement instanceof JSClassExpression;
    }

    public boolean hasGenericsCompatibilityErrors(@NotNull List<JSType> parameterTypes, @NotNull List<JSType> arguments, @NotNull TypeScriptFunction context) {
        Set ids;
        Condition condition;
        Object[] parameters;
        if (parameterTypes == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(21);
        }
        if (arguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(22);
        }
        if (context == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(23);
        }
        if ((parameters = TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)context)).length == 0) {
            return false;
        }
        List argumentProviders = arguments.stream().map(el -> () -> el).collect(Collectors.toList());
        MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> genericArguments = this.inferGenericArgumentsFromCall(parameterTypes, argumentProviders, -1, (PsiElement)context, (Condition<? super JSType>)(condition = arg_0 -> TypeScriptGenericTypesEvaluator.lambda$hasGenericsCompatibilityErrors$7(ids = StreamEx.of((Object[])parameters).map(el -> TypeScriptTypeParser.getTypeParameterId((TypeScriptGenericOrMappedTypeParameter)el)).toSet(), arg_0)));
        if (genericArguments.isEmpty()) {
            return false;
        }
        final Ref hasErrors = Ref.create((Object)false);
        JSGenericTypesEvaluator.GenericErrorReporter reporter = new JSGenericTypesEvaluator.GenericErrorReporter(){

            @Override
            public void error(@NotNull String parameter) {
                if (parameter == null) {
                    1.$$$reportNull$$$0(0);
                }
                hasErrors.set((Object)true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator$1", "error"));
            }
        };
        JSTypeSubstitutor substitutor = TypeScriptGenericTypesEvaluator.intersectGenerics(genericArguments, (PsiElement)context, reporter);
        if (((Boolean)hasErrors.get()).booleanValue()) {
            return true;
        }
        List<JSType> functionGenerics = TypeScriptGenericTypesEvaluator.buildGenericParameters((TypeScriptTypeParameter[])parameters);
        if (functionGenerics.isEmpty()) {
            return false;
        }
        for (JSType generic : functionGenerics) {
            JSTypeUtils.applyGenericArguments(generic, substitutor, true, reporter);
            if (!((Boolean)hasErrors.get()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private JSTypeSubstitutor getTypeSubstitutorForQualifierType(@NotNull JSType qualifierType, @Nullable PsiElement sourceElement, @Nullable PsiElement place) {
        JSClass parentClass;
        JSType constraintType;
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(24);
        }
        PsiElement context = (PsiElement)ObjectUtils.coalesce((Object)sourceElement, (Object)place);
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        if ((qualifierType = JSTypeUtils.unwrapDecorations(qualifierType)) instanceof JSIntersectionType) {
            for (JSType typeToProcess : ((JSIntersectionType)qualifierType).getTypes()) {
                JSTypeSubstitutor candidate = this.getTypeSubstitutorForQualifierType(typeToProcess, sourceElement, place);
                substitutor.putAll(candidate);
            }
            JSTypeSubstitutor jSTypeSubstitutor = substitutor;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(25);
            }
            return jSTypeSubstitutor;
        }
        if (qualifierType instanceof JSTypeWithOuterGenerics) {
            JSTypeSubstitutor outerArguments = ((JSTypeWithOuterGenerics)qualifierType).getOuterArguments();
            if (!outerArguments.isEmpty()) {
                substitutor.putAll(outerArguments);
            }
            qualifierType = ((JSTypeWithOuterGenerics)qualifierType).getType();
        }
        if (qualifierType instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)qualifierType;
            if (genericType.getType() instanceof TypeScriptGenericThisTypeImpl) {
                qualifierType = new JSGenericTypeImpl(genericType.getSource(), genericType.getType().substitute(), genericType.getArguments());
            }
        } else if (qualifierType instanceof JSRecordType) {
            PsiElement qualifierSource = qualifierType.getSource().getSourceElement();
            JSType objectType = null;
            if (qualifierSource instanceof TypeScriptObjectType) {
                objectType = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)((TypeScriptObjectType)qualifierSource));
            } else if (qualifierSource instanceof JSClass) {
                objectType = TypeScriptTypeParser.buildTypeFromClass((JSClass)qualifierSource, false);
            } else if (qualifierSource instanceof JSObjectLiteralExpression && DialectDetector.isTypeScript(qualifierSource)) {
                objectType = JSResolveUtil.getExpressionJSType((JSExpression)qualifierSource);
            }
            if (objectType != null) {
                if (objectType.isEquivalentTo(qualifierType, null, false)) {
                    JSTypeSubstitutor jSTypeSubstitutor = substitutor;
                    if (jSTypeSubstitutor == null) {
                        TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(26);
                    }
                    return jSTypeSubstitutor;
                }
                substitutor.putAll(TypeScriptGenericTypesEvaluator.findAndIntersectGenericsTypeValues(qualifierType, objectType, context));
            }
        } else if (qualifierType instanceof TypeScriptGenericThisTypeImpl) {
            qualifierType = qualifierType.substitute();
        }
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(qualifierType);
        if (arguments == null && qualifierType instanceof TypeScriptGenericParameterImpl && (constraintType = ((TypeScriptGenericParameterImpl)qualifierType).getConstraintType()) != null) {
            qualifierType = constraintType;
            arguments = JSTypeUtils.getGenericTypeArguments(qualifierType);
        }
        if (sourceElement != null && (arguments != null && JSTypeUtils.getQualifiedNameMatchingType(qualifierType, false) != null || qualifierType instanceof JSTypeImpl) && (parentClass = (JSClass)PsiTreeUtil.getContextOfType((PsiElement)sourceElement, (Class[])new Class[]{JSClass.class})) != null) {
            Collection<JSClass> qualifierClasses = TypeScriptGenericTypesEvaluator.getQualifierClasses(qualifierType, place);
            for (JSClass qualifierClass : qualifierClasses) {
                List<JSType> argumentsList = arguments == null || arguments.isEmpty() ? TypeScriptGenericTypesEvaluator.getArgumentsListForQualifierType(qualifierType, qualifierClass) : arguments;
                substitutor = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(qualifierClass, argumentsList, parentClass, substitutor);
            }
        }
        JSTypeSubstitutor jSTypeSubstitutor = substitutor;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(27);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private static List<JSType> getArgumentsListForQualifierType(@NotNull JSType qualifierType, @NotNull JSClass qualifierClass) {
        TypeScriptTypeParameter[] parameters;
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(28);
        }
        if (qualifierClass == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(29);
        }
        if (TypeScriptGenericTypesEvaluator.isInstanceJSTypeImpl(qualifierType) && (parameters = TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)qualifierClass)).length > 0) {
            List<JSType> list = Arrays.stream(parameters).map(JSGenericTypesEvaluatorBase::getTypeParameterDefaultType).collect(Collectors.toList());
            if (list == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(30);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(31);
        }
        return list;
    }

    private static boolean isInstanceJSTypeImpl(@NotNull JSType qualifierType) {
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(32);
        }
        return qualifierType instanceof JSTypeImpl && ((JSTypeImpl)qualifierType).getTypeContext().toJSContext() == JSContext.INSTANCE;
    }

    @NotNull
    public static JSType processClassWithGenericArguments(@Nullable JSClass aClass, @NotNull List<? extends JSType> typeArgumentsList, @Nullable JSClass requiredParentClass, @NotNull JSType appliedGenerics) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(33);
        }
        if (appliedGenerics == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(34);
        }
        JSTypeSubstitutor substitutor = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(aClass, typeArgumentsList, requiredParentClass, JSTypeSubstitutor.EMPTY);
        JSType jSType = JSTypeUtils.applyGenericArguments(appliedGenerics, substitutor);
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(35);
        }
        return jSType;
    }

    @NotNull
    public static JSTypeSubstitutor processClassWithGenericArguments(@Nullable JSClass startClass, @NotNull List<? extends JSType> typeArgumentsList, final @Nullable JSClass expectedGenericOwnerClass, final @NotNull JSTypeSubstitutor substitutor) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(36);
        }
        if (substitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(37);
        }
        if (!(expectedGenericOwnerClass instanceof TypeScriptTypeParameterListOwner) || startClass == null) {
            JSTypeSubstitutor jSTypeSubstitutor = substitutor;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(38);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor typeArguments = startClass instanceof TypeScriptTypeParameterListOwner ? TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)startClass, typeArgumentsList) : JSTypeSubstitutor.EMPTY;
        final Ref ref = Ref.create((Object)substitutor);
        JSClassUtils.processClassesInHierarchy(startClass, true, new TypeScriptUtil.JSClassHierarchyProcessor(){

            @Override
            public boolean process(@NotNull JSClass<?> contextClass, @NotNull JSTypeSubstitutor typeSubstitutor, boolean fromImplements) {
                if (contextClass == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (typeSubstitutor == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (contextClass.isEquivalentTo((PsiElement)expectedGenericOwnerClass)) {
                    if (!substitutor.isEmpty()) {
                        typeSubstitutor = new JSTypeSubstitutor(typeSubstitutor);
                        typeSubstitutor.putAll(substitutor);
                    }
                    ref.set((Object)typeSubstitutor);
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "contextClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "typeSubstitutor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator$2";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Condition<JSClass>)((Condition)superCandidate -> JSInheritanceUtil.isParentClass(superCandidate, expectedGenericOwnerClass, false)), typeArguments);
        JSTypeSubstitutor jSTypeSubstitutor = (JSTypeSubstitutor)ref.get();
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(39);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static List<JSType> getTypeArgumentsForDeclarations(@NotNull JSTypeDeclaration[] declarations, @Nullable JSTypeSubstitutor typeArguments) {
        if (declarations == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(40);
        }
        List mappedArguments = ContainerUtil.newSmartList();
        for (JSTypeDeclaration typeArgument : declarations) {
            JSType expandedType = TypeScriptTypeParser.buildTypeFromTypeScript(typeArgument);
            if (typeArguments != null) {
                expandedType = JSTypeUtils.applyGenericArguments(expandedType, typeArguments);
            }
            mappedArguments.add(expandedType);
        }
        List list = mappedArguments;
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(41);
        }
        return list;
    }

    @Nullable
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterListOwner typeParameterListOwner, @Nullable JSType genericType) {
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
        return arguments == null ? null : TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(typeParameterListOwner, arguments);
    }

    @NotNull
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterListOwner typeParameterListOwner, @NotNull List<? extends JSType> typeArgumentsList) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(42);
        }
        if (typeParameterListOwner == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(43);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(typeParameterListOwner.getTypeParameterList(), typeArgumentsList);
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(44);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterList typeParameterList, @NotNull List<? extends JSType> typeArgumentsList) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(45);
        }
        if (typeArgumentsList.isEmpty() || typeParameterList == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(46);
            }
            return jSTypeSubstitutor;
        }
        TypeScriptTypeParameter[] parameters = typeParameterList.getTypeParameters();
        JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(parameters, typeArgumentsList);
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(47);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@NotNull TypeScriptTypeParameter[] parameters, @NotNull List<? extends JSType> typeArgumentsList) {
        if (parameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(48);
        }
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(49);
        }
        if (typeArgumentsList.size() == 0 || parameters.length == 0) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(50);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor genericArguments = new JSTypeSubstitutor();
        for (int i = 0; i < parameters.length; ++i) {
            String name;
            TypeScriptTypeParameter parameter = parameters[i];
            JSType type = null;
            if (typeArgumentsList.size() > i) {
                type = typeArgumentsList.get(i);
            }
            if (TypeScriptGenericTypesEvaluator.addFromNamedSubstitutor(parameters, genericArguments, type)) continue;
            if (type == null) {
                type = JSTypeUtils.applyGenericArguments(TypeScriptGenericTypesEvaluator.getTypeParameterDefaultType(parameter), genericArguments);
            }
            if ((name = parameter.getName()) == null) continue;
            JSTypeSubstitutor.JSTypeGenericId id = TypeScriptTypeParser.getTypeParameterId((TypeScriptGenericOrMappedTypeParameter)parameter);
            genericArguments.put(id, type);
        }
        JSTypeSubstitutor jSTypeSubstitutor = genericArguments;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(51);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private JSTypeSubstitutor getInferredCallLikeTypeSubstitutor(@NotNull JSExpression methodExpression, @NotNull PsiElement resolvedFunction, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext context, @NotNull JSTypeSubstitutor explicitSubstitutor) {
        if (methodExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(52);
        }
        if (resolvedFunction == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(53);
        }
        if (context == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(54);
        }
        if (explicitSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(55);
        }
        if (!context.inferCallGenerics) {
            JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.getSubstitutorForDefaultParameters(resolvedFunction);
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(56);
            }
            return jSTypeSubstitutor;
        }
        PsiElement parent = methodExpression.getParent();
        if (parent instanceof JSCallExpression) {
            JSTypeSubstitutor jSTypeSubstitutor = this.inferGenericTypesForCall(resolvedFunction, (JSCallExpression)parent, context.reporter, explicitSubstitutor.keys(), context.paramToSkip);
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(57);
            }
            return jSTypeSubstitutor;
        }
        if (parent instanceof ES6TaggedTemplateExpression) {
            ES6TaggedTemplateExpression taggedTemplate = (ES6TaggedTemplateExpression)parent;
            JSTypeSubstitutor jSTypeSubstitutor = this.inferGenericTypesForTaggedTemplateCall(resolvedFunction, taggedTemplate, context.reporter, explicitSubstitutor.keys(), context.paramToSkip);
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(58);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(59);
        }
        return jSTypeSubstitutor;
    }

    @Nullable
    private static PsiElement getResolvedFunction(@Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction) {
        JSFunctionItem functionItem;
        if (resolvedFunction != null && (functionItem = JSPsiImplUtils.calculatePossibleFunction(resolvedFunction, (PsiElement)methodExpression, false)) != null) {
            resolvedFunction = functionItem;
        }
        return resolvedFunction;
    }

    private static JSTypeSubstitutor getSuperExpressionTypeSubstitutor(@NotNull JSExpression methodExpression, @Nullable PsiElement resolvedFunction) {
        JSReferenceList list;
        if (methodExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(60);
        }
        if (!TypeScriptGenericTypesEvaluator.isConstructorSuperCall(resolvedFunction, (PsiElement)methodExpression)) {
            return JSTypeSubstitutor.EMPTY;
        }
        TypeScriptClass tsClass = (TypeScriptClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)methodExpression, TypeScriptClass.class);
        if (tsClass != null && resolvedFunction instanceof TypeScriptFunction && (list = tsClass.getExtendsList()) != null) {
            if (tsClass.getIndirectSuperConstructors().contains(resolvedFunction)) {
                JSExpression element = (JSExpression)ArrayUtil.getFirstElement((Object[])list.getExpressions());
                List<JSType> typesForGenerics = element != null ? TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(TypeScriptPsiUtil.getNestedTypeArguments(element.getParent()), null) : ContainerUtil.emptyList();
                TypeScriptFunction tsFunction = (TypeScriptFunction)resolvedFunction;
                return TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)tsFunction, typesForGenerics);
            }
            JSClass parentClass = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)resolvedFunction, JSClass.class);
            return TypeScriptGenericTypesEvaluator.processClassWithGenericArguments((JSClass)tsClass, (List<? extends JSType>)ContainerUtil.emptyList(), parentClass, JSTypeSubstitutor.EMPTY);
        }
        return JSTypeSubstitutor.EMPTY;
    }

    @NotNull
    public JSTypeSubstitutor getTypeSubstitutorForMember(@Nullable PsiElement member, @Nullable PsiElement place, @Nullable JSTypeSubstitutor additionalSubstitutor) {
        if (member instanceof TypeScriptProxyImplicitElement) {
            member = ((TypeScriptProxyImplicitElement)member).getExplicitElement();
        }
        if (!(place instanceof JSExpression) || !(member instanceof JSQualifiedNamedElement)) {
            JSTypeSubstitutor jSTypeSubstitutor = additionalSubstitutor == null ? JSTypeSubstitutor.EMPTY : additionalSubstitutor;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(61);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        if (additionalSubstitutor != null) {
            substitutor.putAll(additionalSubstitutor);
        }
        boolean isCallContext = TypeScriptGenericTypesEvaluator.isCallContext((JSExpression)place);
        substitutor.putAll(TypeScriptGenericTypesEvaluator.getInstance().getAllGenericTypeSubstitutor((JSExpression)place, member, member, isCallContext, DEFAULT_CONTEXT));
        JSTypeSubstitutor jSTypeSubstitutor = substitutor;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(62);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public JSTypeSubstitutor getTypeSubstitutorForMember(@Nullable JSElement member, @NotNull PsiElement place) {
        List<JSFunctionWithSubstitutor> elements;
        JSFunctionWithSubstitutor functionWithSubstitutor;
        if (place == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(63);
        }
        if (member == null || !DialectDetector.isTypeScript((PsiElement)member) || !(place instanceof JSReferenceExpression)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(64);
            }
            return jSTypeSubstitutor;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)place;
        if (referenceExpression.getParent() instanceof JSCallExpression && (functionWithSubstitutor = (JSFunctionWithSubstitutor)ContainerUtil.getFirstItem(elements = TypeScriptSignatureChooser.resolveConstructorOrCallSignature((PsiElement)referenceExpression))) != null) {
            JSFunctionItem functionItem = functionWithSubstitutor.myFunctionItem;
            JSTypeSubstitutor additionalSubstitutor = functionWithSubstitutor.myTypeSubstitutor;
            JSTypeSubstitutor jSTypeSubstitutor = this.getTypeSubstitutorForMember((PsiElement)functionItem, place, additionalSubstitutor);
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(65);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = this.getTypeSubstitutorForMember((PsiElement)member, place, null);
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(66);
        }
        return jSTypeSubstitutor;
    }

    private static boolean isConstructorSuperCall(@Nullable PsiElement resolveResult, @Nullable PsiElement callExpression) {
        return callExpression instanceof JSSuperExpression && callExpression.getParent() instanceof JSCallExpression && resolveResult instanceof JSFunction && ((JSFunction)resolveResult).isConstructor();
    }

    @Nullable
    public static JSType getParameterExpressionType(@NotNull JSExpression expression, boolean contextual) {
        if (expression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(67);
        }
        if (contextual) {
            return TypeScriptGenericTypesEvaluator.getParameterExpressionType(TypeScriptContextualTypeEvaluator.getContextualType(expression));
        }
        Ref exprTypeRef = Ref.create(null);
        JSTypeEvaluator.processWithEvaluationGuard(expression, JSEvaluateContext.JSEvaluationPlace.PARAMETER_TYPE, e -> exprTypeRef.set((Object)JSTypeEvaluator.getExpressionType(e)));
        return TypeScriptGenericTypesEvaluator.getParameterExpressionType((JSTypeEvaluationResult)exprTypeRef.get());
    }

    @Nullable
    public static JSType getParameterExpressionType(@Nullable JSTypeEvaluationResult result2) {
        if (result2 == null) {
            return null;
        }
        List<JSTypeEvaluationResult.JSTypeEvaluationResultElement> results = result2.getResults();
        if (results.size() <= 1) {
            return JSTypeUtils.getValuableType(result2.getType());
        }
        ArrayList types = ContainerUtil.newArrayList();
        JSTypeSource source = null;
        for (JSTypeEvaluationResult.JSTypeEvaluationResultElement element : results) {
            JSType type = JSTypeUtils.getValuableType(element.getType());
            if (type == null) continue;
            types.add(type);
            JSTypeSource typeSource = type.getSource();
            source = source == null ? typeSource : JSTypeSourceFactory.copyTypeSource(source, source.isStrict() && typeSource.isStrict());
        }
        if (types.size() <= 1) {
            return (JSType)ContainerUtil.getFirstItem((List)types);
        }
        return new JSCompositeTypeImpl(source == null ? JSTypeSource.EMPTY_TS : source, types);
    }

    public static void fillExplicitGenericArguments(@NotNull TypeScriptTypeParameter[] typeParameters, @NotNull JSTypeDeclaration[] typeArguments, @NotNull JSTypeSubstitutor genericArguments) {
        if (typeParameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(68);
        }
        if (typeArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(69);
        }
        if (genericArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(70);
        }
        if (typeParameters.length == 0 || typeArguments.length == 0) {
            return;
        }
        for (int i = 0; i < typeParameters.length; ++i) {
            JSType type;
            TypeScriptTypeParameter parameter = typeParameters[i];
            JSTypeDeclaration typeArgument = typeArguments.length > i ? typeArguments[i] : null;
            JSType jSType = type = typeArgument != null ? TypeScriptTypeParser.buildTypeFromTypeScript(typeArgument) : null;
            if (TypeScriptGenericTypesEvaluator.addFromNamedSubstitutor(typeParameters, genericArguments, type)) continue;
            if (type == null) {
                type = TypeScriptGenericTypesEvaluator.getTypeParameterDefaultType(parameter);
            }
            genericArguments.put(TypeScriptTypeParser.getTypeParameterId((TypeScriptGenericOrMappedTypeParameter)parameter), type);
        }
    }

    private static boolean addFromNamedSubstitutor(@NotNull TypeScriptTypeParameter[] typeParameters, @NotNull JSTypeSubstitutor genericArguments, JSType type) {
        if (typeParameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(71);
        }
        if (genericArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(72);
        }
        if (!(type instanceof JSNamedTypeSubstitutorType)) {
            return false;
        }
        String genericName = ((JSNamedTypeSubstitutorType)type).getGenericName();
        Optional<TypeScriptTypeParameter> first = Arrays.stream(typeParameters).filter(p -> genericName.equals(p.getName())).findFirst();
        first.ifPresent(parameter -> {
            if (genericArguments == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(119);
            }
            genericArguments.put(TypeScriptTypeParser.getTypeParameterId((TypeScriptGenericOrMappedTypeParameter)parameter), ((JSNamedTypeSubstitutorType)type).getRealType());
        });
        return true;
    }

    @NotNull
    public static JSTypeSubstitutor getCallExplicitTypeSubstitutor(PsiElement resolveResult, PsiElement callExpression, @Nullable JSTypeSubstitutor genericArguments) {
        TypeScriptTypeParameter[] typeParameters;
        JSClass clazz;
        if (!(resolveResult instanceof TypeScriptTypeParameterListOwner)) {
            JSTypeSubstitutor jSTypeSubstitutor = genericArguments == null ? JSTypeSubstitutor.EMPTY : new JSTypeSubstitutor(genericArguments);
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(73);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor substitutor = genericArguments == null ? new JSTypeSubstitutor() : new JSTypeSubstitutor(genericArguments);
        TypeScriptTypeParameterList typeParameterList = ((TypeScriptTypeParameterListOwner)resolveResult).getTypeParameterList();
        if (typeParameterList != null) {
            TypeScriptTypeParameter[] typeParameters2 = typeParameterList.getTypeParameters();
            JSTypeDeclaration[] typeArguments = TypeScriptPsiUtil.getNestedTypeArguments(callExpression);
            TypeScriptGenericTypesEvaluator.fillExplicitGenericArguments(typeParameters2, typeArguments, substitutor);
        }
        if ((clazz = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)resolveResult, JSClass.class)) instanceof TypeScriptTypeParameterListOwner && (typeParameters = TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)clazz)).length > 0) {
            JSTypeDeclaration[] typeArguments = TypeScriptPsiUtil.getNewExpressionTypeArguments(callExpression);
            TypeScriptGenericTypesEvaluator.fillExplicitGenericArguments(typeParameters, typeArguments, substitutor);
        }
        JSTypeSubstitutor jSTypeSubstitutor = substitutor;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(74);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static List<JSType> getArgumentTypesForSignatureChecking(@NotNull JSExpression[] arguments, boolean contextual) {
        if (arguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(75);
        }
        if (arguments.length == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(76);
            }
            return list;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)ArrayUtil.getFirstElement((Object[])arguments));
        boolean isTypeScript = holder != null && holder.isTypeScript;
        List argumentTypes = ContainerUtil.newSmartList();
        for (JSExpression expression : arguments) {
            JSType type = TypeScriptGenericTypesEvaluator.getParameterExpressionType(expression, contextual);
            argumentTypes.add(isTypeScript && !contextual ? TypeScriptGenericTypesEvaluator.getExplicitTypeOrAny((PsiElement)expression, type) : (type != null ? type : JSAnyType.get((PsiElement)expression, false)));
        }
        List list = argumentTypes;
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(77);
        }
        return list;
    }

    @NotNull
    public static JSType getExplicitTypeOrAnyIfTypeScript(@Nullable PsiElement expression, @Nullable JSType type) {
        if (type == null) {
            JSAnyType jSAnyType = JSAnyType.get(expression, false);
            if (jSAnyType == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(78);
            }
            return jSAnyType;
        }
        if (expression == null || !expression.isValid()) {
            JSType jSType = type;
            if (jSType == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(79);
            }
            return jSType;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(expression);
        if (holder != null && holder.isTypeScript) {
            JSType jSType = TypeScriptGenericTypesEvaluator.getExplicitTypeOrAny(expression, type);
            if (jSType == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(80);
            }
            return jSType;
        }
        JSType jSType = type;
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(81);
        }
        return jSType;
    }

    @NotNull
    public static JSType getExplicitTypeOrAny(@NotNull PsiElement expression, @Nullable JSType type) {
        if (expression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(82);
        }
        JSType jSType = type == null ? JSAnyType.get(expression, false) : JSTypeUtils.replaceImplicitTypesWithAny(type);
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(83);
        }
        return jSType;
    }

    @NotNull
    public static Collection<JSClass> getQualifierClasses(@Nullable JSType qualifierType, @Nullable PsiElement place) {
        if (qualifierType == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(84);
            }
            return list;
        }
        JSTypeSource source = qualifierType.getSource();
        String type = JSTypeUtils.getQualifiedNameMatchingType(qualifierType, false);
        PsiElement element = source.getSourceElement();
        if (type == null || element == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(85);
            }
            return list;
        }
        Collection<? extends PsiElement> elements = TypeScriptGenericTypesEvaluator.getElementsForQualifierClassName(type, element, place);
        List result2 = ContainerUtil.newSmartList();
        for (PsiElement psiElement : elements) {
            if (!(psiElement instanceof JSClass)) continue;
            result2.add((JSClass)psiElement);
        }
        List list = result2;
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(86);
        }
        return list;
    }

    @NotNull
    private static Collection<? extends PsiElement> getElementsForQualifierClassName(@NotNull String type, @NotNull PsiElement element, @Nullable PsiElement place) {
        boolean isJSPlace;
        if (type == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(87);
        }
        if (element == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(88);
        }
        boolean bl = isJSPlace = place != null && !DialectDetector.isTypeScript(place);
        if (isJSPlace) {
            if (JSCorePredefinedLibrariesProvider.isLibraryElement(element)) {
                Collection<PsiElement> collection = JavaScriptQualifiedItemProcessor.resolveGlobalTypeElementsByName(type, place);
                if (collection == null) {
                    TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(89);
                }
                return collection;
            }
            if (!DialectDetector.isTypeScript(element)) {
                Collection<PsiElement> elements = new ES6QualifiedNameResolver(element).resolveQualifiedName(type);
                if (elements.size() > 0) {
                    Collection<PsiElement> collection = elements;
                    if (collection == null) {
                        TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(90);
                    }
                    return collection;
                }
                Collection<PsiElement> collection = JavaScriptQualifiedItemProcessor.resolveGlobalTypeElementsByName(type, place);
                if (collection == null) {
                    TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(91);
                }
                return collection;
            }
        }
        JSTypeResolveResult resolveResults = TypeScriptImportHandler.getInstance().resolveMainElementName(type, element, JSContext.UNKNOWN);
        Collection<? extends PsiElement> collection = resolveResults.getElements();
        if (collection == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(92);
        }
        return collection;
    }

    @NotNull
    public static List<TypeScriptGenericDeclarationTypeImpl> buildGenericParameterDeclarations(@NotNull TypeScriptTypeParameter[] parameters) {
        if (parameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(93);
        }
        if (parameters.length == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(94);
            }
            return list;
        }
        ArrayList generics = ContainerUtil.newArrayList();
        for (TypeScriptTypeParameter parameter : parameters) {
            TypeScriptGenericDeclarationTypeImpl declaration = TypeScriptGenericTypesEvaluator.buildGenericParameterDeclaration(parameter);
            generics.add(declaration);
        }
        ArrayList arrayList = generics;
        if (arrayList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(95);
        }
        return arrayList;
    }

    @NotNull
    public static List<JSType> buildGenericParameters(@NotNull TypeScriptTypeParameter[] parameters) {
        if (parameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(96);
        }
        List<JSType> list = TypeScriptGenericTypesEvaluator.buildGenericParameterDeclarations(parameters).stream().map(el -> el.toGenericParameter()).collect(Collectors.toList());
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(97);
        }
        return list;
    }

    @NotNull
    public static TypeScriptGenericDeclarationTypeImpl buildGenericParameterDeclaration(@NotNull TypeScriptTypeParameter parameter) {
        if (parameter == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(98);
        }
        TypeScriptType constraint = parameter.getTypeConstraint();
        TypeScriptType parameterDefault = parameter.getDefault();
        AtomicNotNullLazyValue constraintType = constraint == null ? null : AtomicNotNullLazyValue.createValue(() -> TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)constraint));
        AtomicNotNullLazyValue defaultType = parameterDefault == null ? null : AtomicNotNullLazyValue.createValue(() -> TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)parameterDefault));
        JSTypeSubstitutor.JSTypeGenericId genericId = TypeScriptTypeParser.getTypeParameterId((TypeScriptGenericOrMappedTypeParameter)parameter);
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)parameter, true);
        TypeScriptGenericDeclarationTypeImpl typeScriptGenericDeclarationTypeImpl = new TypeScriptGenericDeclarationTypeImpl(genericId, (NotNullLazyValue<? extends JSType>)constraintType, (NotNullLazyValue<? extends JSType>)defaultType, source);
        if (typeScriptGenericDeclarationTypeImpl == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(99);
        }
        return typeScriptGenericDeclarationTypeImpl;
    }

    @NotNull
    public static JSType applyTypeScriptGenericArguments(@NotNull JSFunctionTypeImpl functionType, @NotNull JSCallExpression callExpression) {
        if (functionType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(100);
        }
        if (callExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(101);
        }
        JSType jSType = TypeScriptGenericTypesEvaluator.applyTypeScriptGenericArguments(functionType, callExpression.getMethodExpression(), callExpression instanceof JSNewExpression, TypeScriptPsiUtil.getNestedTypeArguments((PsiElement)callExpression), functionType.getSource().getSourceElement());
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(102);
        }
        return jSType;
    }

    @NotNull
    public static JSType applyTypeScriptGenericArguments(@NotNull JSFunctionTypeImpl functionType, @Nullable JSExpression methodExpression, boolean isNewExpression, @NotNull JSTypeDeclaration[] typeArguments, @Nullable PsiElement sourceElement) {
        if (functionType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(103);
        }
        if (typeArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(104);
        }
        JSTypeSubstitutor defaultParamsSubstitutor = new JSTypeSubstitutor();
        JSFunctionTypeImpl resultType = isNewExpression && sourceElement instanceof JSClass && sourceElement instanceof TypeScriptTypeParameterListOwner ? TypeScriptGenericTypesEvaluator.wrapNewExpressionReturnTypeWithGenerics(functionType, defaultParamsSubstitutor, typeArguments, sourceElement) : functionType;
        JSType evaluatedType = JSGenericTypesEvaluator.getEvaluator((PsiElement)methodExpression).evaluateGenerics(resultType, methodExpression, sourceElement);
        JSType jSType = JSTypeUtils.applyGenericArguments(evaluatedType, defaultParamsSubstitutor);
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(105);
        }
        return jSType;
    }

    @NotNull
    private static JSType wrapNewExpressionReturnTypeWithGenerics(@NotNull JSFunctionTypeImpl functionType, @NotNull JSTypeSubstitutor defaultParamsSubstitutor, @NotNull JSTypeDeclaration[] typeArguments, @NotNull PsiElement sourceElement) {
        if (functionType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(106);
        }
        if (defaultParamsSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(107);
        }
        if (typeArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(108);
        }
        if (sourceElement == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(109);
        }
        JSType returnType = functionType.getReturnType();
        TypeScriptTypeParameter[] typeParameters = TypeScriptPsiUtil.getTypeParametersForOwner(sourceElement);
        if (typeParameters.length > 0 && returnType instanceof JSNamedType) {
            List<JSType> defaultGenerics;
            if (typeArguments.length == 0) {
                Arrays.stream(typeParameters).forEach(el -> {
                    if (defaultParamsSubstitutor == null) {
                        TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(118);
                    }
                    defaultParamsSubstitutor.put(TypeScriptTypeParser.getTypeParameterId((TypeScriptGenericOrMappedTypeParameter)el), TypeScriptGenericTypesEvaluator.getTypeParameterDefaultType(el));
                });
                defaultGenerics = TypeScriptGenericTypesEvaluator.buildGenericParameters(typeParameters);
            } else {
                defaultGenerics = TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(typeArguments, defaultParamsSubstitutor);
            }
            JSGenericTypeImpl newReturnType = new JSGenericTypeImpl(functionType.getSource(), returnType, defaultGenerics);
            JSFunctionTypeImpl jSFunctionTypeImpl = new JSFunctionTypeImpl(functionType.getSource(), functionType.getParameters(), newReturnType);
            if (jSFunctionTypeImpl == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(110);
            }
            return jSFunctionTypeImpl;
        }
        JSFunctionTypeImpl jSFunctionTypeImpl = functionType;
        if (jSFunctionTypeImpl == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(111);
        }
        return jSFunctionTypeImpl;
    }

    @NotNull
    public static JSTypeSubstitutor getTypeSubstitutorForExtendClass(@NotNull JSClass contextClass, @NotNull JSClass genericOwner) {
        if (contextClass == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(112);
        }
        if (genericOwner == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(113);
        }
        if (!(genericOwner instanceof TypeScriptTypeParameterListOwner)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(114);
            }
            return jSTypeSubstitutor;
        }
        TypeScriptTypeParameterList typeParameterList = ((TypeScriptTypeParameterListOwner)genericOwner).getTypeParameterList();
        if (typeParameterList == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(115);
            }
            return jSTypeSubstitutor;
        }
        TypeScriptTypeParameter[] parameters = typeParameterList.getTypeParameters();
        if (parameters.length <= 0) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(116);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(contextClass, (List<? extends JSType>)ContainerUtil.emptyList(), genericOwner, JSTypeSubstitutor.EMPTY);
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(117);
        }
        return jSTypeSubstitutor;
    }

    private static /* synthetic */ boolean lambda$hasGenericsCompatibilityErrors$7(Set ids, JSType type) {
        return type instanceof JSGenericParameterImpl && ids.contains(((JSGenericParameterImpl)type).getGenericId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 35: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 50: 
            case 51: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 97: 
            case 99: 
            case 102: 
            case 105: 
            case 110: 
            case 111: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 35: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 50: 
            case 51: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 97: 
            case 99: 
            case 102: 
            case 105: 
            case 110: 
            case 111: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 14: 
            case 17: 
            case 52: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 35: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 50: 
            case 51: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 97: 
            case 99: 
            case 102: 
            case 105: 
            case 110: 
            case 111: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator";
                break;
            }
            case 9: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 22: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 24: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierClass";
                break;
            }
            case 33: 
            case 36: 
            case 42: 
            case 45: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArgumentsList";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appliedGenerics";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 48: 
            case 93: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedFunction";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitSubstitutor";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 67: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 68: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 69: 
            case 104: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 70: 
            case 72: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericArguments";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 100: 
            case 103: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 107: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultParamsSubstitutor";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextClass";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluationFunction";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllGenericTypeSubstitutor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateGenericsFromQualifier";
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierTypeSubstitutor";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForQualifierType";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentsListForQualifierType";
                break;
            }
            case 35: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "processClassWithGenericArguments";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArgumentsForDeclarations";
                break;
            }
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutorForTypeArguments";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getInferredCallLikeTypeSubstitutor";
                break;
            }
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForMember";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallExplicitTypeSubstitutor";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentTypesForSignatureChecking";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitTypeOrAnyIfTypeScript";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitTypeOrAny";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierClasses";
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsForQualifierClassName";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "buildGenericParameterDeclarations";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "buildGenericParameters";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "buildGenericParameterDeclaration";
                break;
            }
            case 102: 
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "applyTypeScriptGenericArguments";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapNewExpressionReturnTypeWithGenerics";
                break;
            }
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForExtendClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "evaluateGenerics";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isCallContext";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEvaluationFunction";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 35: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 50: 
            case 51: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 97: 
            case 99: 
            case 102: 
            case 105: 
            case 110: 
            case 111: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllGenericTypeSubstitutor";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "evaluateGenericsFromQualifier";
                break;
            }
            case 13: 
            case 14: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierTypeSubstitutor";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableRecordTypeForThis";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "hasGenericsCompatibilityErrors";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForQualifierType";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentsListForQualifierType";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceJSTypeImpl";
                break;
            }
            case 33: 
            case 34: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "processClassWithGenericArguments";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getTypeArgumentsForDeclarations";
                break;
            }
            case 42: 
            case 45: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutorForTypeArguments";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getInferredCallLikeTypeSubstitutor";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getSuperExpressionTypeSubstitutor";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForMember";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getParameterExpressionType";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "fillExplicitGenericArguments";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "addFromNamedSubstitutor";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentTypesForSignatureChecking";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitTypeOrAny";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getElementsForQualifierClassName";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "buildGenericParameterDeclarations";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "buildGenericParameters";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "buildGenericParameterDeclaration";
                break;
            }
            case 100: 
            case 101: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "applyTypeScriptGenericArguments";
                break;
            }
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "wrapNewExpressionReturnTypeWithGenerics";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForExtendClass";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "lambda$wrapNewExpressionReturnTypeWithGenerics$15";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addFromNamedSubstitutor$11";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getEvaluationFunction$2";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getEvaluationFunction$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 35: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 50: 
            case 51: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 97: 
            case 99: 
            case 102: 
            case 105: 
            case 110: 
            case 111: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

