/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.BraceMatcherTerminationAspect;
import com.intellij.codeInsight.highlighting.NontrivialBraceMatcher;
import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PairedBraceMatcherAdapter
implements NontrivialBraceMatcher,
PairedBraceMatcher {
    private final PairedBraceMatcher myMatcher;
    private final Language myLanguage;

    public PairedBraceMatcherAdapter(@NotNull PairedBraceMatcher matcher, @NotNull Language language) {
        if (matcher == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(0);
        }
        if (language == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(1);
        }
        this.myMatcher = matcher;
        this.myLanguage = language;
    }

    @NotNull
    public BracePair[] getPairs() {
        BracePair[] bracePairArray = this.myMatcher.getPairs();
        if (bracePairArray == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(2);
        }
        return bracePairArray;
    }

    @Override
    public int getBraceTokenGroupId(IElementType tokenType) {
        BracePair[] pairs;
        for (BracePair pair : pairs = this.myMatcher.getPairs()) {
            if (tokenType != pair.getLeftBraceType() && tokenType != pair.getRightBraceType()) continue;
            return this.myLanguage.hashCode();
        }
        return -1;
    }

    @Nullable
    public BracePair findPair(boolean left, HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        BracePair[] pairs;
        IElementType tokenType = iterator.getTokenType();
        for (BracePair pair : pairs = this.myMatcher.getPairs()) {
            if (tokenType != (left ? pair.getLeftBraceType() : pair.getRightBraceType())) continue;
            return pair;
        }
        return null;
    }

    @Override
    public boolean isLBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        return this.findPair(true, iterator, fileText, fileType) != null;
    }

    @Override
    public boolean isRBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        return this.findPair(false, iterator, fileText, fileType) != null;
    }

    @Override
    public IElementType getOppositeBraceTokenType(@NotNull IElementType type) {
        BracePair[] pairs;
        if (type == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(3);
        }
        for (BracePair pair : pairs = this.myMatcher.getPairs()) {
            if (type == pair.getRightBraceType()) {
                return pair.getLeftBraceType();
            }
            if (type != pair.getLeftBraceType()) continue;
            return pair.getRightBraceType();
        }
        return null;
    }

    @Override
    public boolean isPairBraces(IElementType tokenType, IElementType tokenType2) {
        BracePair[] pairs;
        for (BracePair pair : pairs = this.myMatcher.getPairs()) {
            if ((tokenType != pair.getLeftBraceType() || tokenType2 != pair.getRightBraceType()) && (tokenType != pair.getRightBraceType() || tokenType2 != pair.getLeftBraceType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStructuralBrace(HighlighterIterator iterator, CharSequence text, FileType fileType) {
        BracePair[] pairs;
        IElementType tokenType = iterator.getTokenType();
        for (BracePair pair : pairs = this.myMatcher.getPairs()) {
            if (tokenType != pair.getRightBraceType() && tokenType != pair.getLeftBraceType()) continue;
            return pair.isStructural();
        }
        return false;
    }

    @Override
    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        if (lbraceType == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(4);
        }
        return this.myMatcher.isPairedBracesAllowedBeforeType(lbraceType, contextType);
    }

    @Override
    public int getCodeConstructStart(PsiFile file2, int openingBraceOffset) {
        return this.myMatcher.getCodeConstructStart(file2, openingBraceOffset);
    }

    @Override
    @NotNull
    public List<IElementType> getOppositeBraceTokenTypes(@NotNull IElementType type) {
        if (type == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(5);
        }
        List<IElementType> result2 = null;
        for (BracePair pair : this.myMatcher.getPairs()) {
            IElementType match = null;
            if (type == pair.getRightBraceType()) {
                match = pair.getLeftBraceType();
            }
            if (type == pair.getLeftBraceType()) {
                match = pair.getRightBraceType();
            }
            if (match == null) continue;
            if (result2 == null) {
                result2 = new ArrayList<IElementType>(2);
            }
            result2.add(match);
        }
        List<IElementType> list2 = result2 != null ? result2 : Collections.emptyList();
        if (list2 == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    public boolean shouldStopMatch(boolean forward, @NotNull IElementType braceType, @NotNull HighlighterIterator iterator) {
        if (braceType == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(7);
        }
        if (iterator == null) {
            PairedBraceMatcherAdapter.$$$reportNull$$$0(8);
        }
        if (this.myMatcher instanceof BraceMatcherTerminationAspect) {
            return ((BraceMatcherTerminationAspect)this.myMatcher).shouldStopMatch(forward, braceType, iterator);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/PairedBraceMatcherAdapter";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lbraceType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "braceType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/PairedBraceMatcherAdapter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPairs";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOppositeBraceTokenTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOppositeBraceTokenType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPairedBracesAllowedBeforeType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOppositeBraceTokenTypes";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "shouldStopMatch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

