/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.bigPopup;

import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class ShowFilterAction
extends ToggleAction
implements DumbAware {
    @NotNull
    private final Disposable myParentDisposable;
    @NotNull
    private final Project myProject;
    private JBPopup myFilterPopup;

    public ShowFilterAction(@NotNull Disposable parentDisposable, @NotNull Project project) {
        if (parentDisposable == null) {
            ShowFilterAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ShowFilterAction.$$$reportNull$$$0(1);
        }
        super("Filter", "Filter files by type", AllIcons.General.Filter);
        this.myParentDisposable = parentDisposable;
        this.myProject = project;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowFilterAction.$$$reportNull$$$0(2);
        }
        return this.myFilterPopup != null && !this.myFilterPopup.isDisposed();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        if (e == null) {
            ShowFilterAction.$$$reportNull$$$0(3);
        }
        if (state) {
            this.showPopup(e.getInputEvent().getComponent());
        } else if (this.myFilterPopup != null && !this.myFilterPopup.isDisposed()) {
            this.myFilterPopup.cancel();
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowFilterAction.$$$reportNull$$$0(4);
        }
        Icon icon = this.getTemplatePresentation().getIcon();
        e.getPresentation().setIcon(this.isActive() ? ExecutionUtil.getLiveIndicator((Icon)icon) : icon);
        e.getPresentation().setEnabled(this.isEnabled());
        e.getPresentation().putClientProperty("selected", (Object)this.isSelected(e));
    }

    protected abstract boolean isEnabled();

    protected abstract boolean isActive();

    private void showPopup(Component anchor2) {
        if (this.myFilterPopup != null) {
            return;
        }
        JBPopupListener popupCloseListener = new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                ShowFilterAction.this.myFilterPopup = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/actions/bigPopup/ShowFilterAction$1", "onClosed"));
            }
        };
        this.myFilterPopup = JBPopupFactory.getInstance().createComponentPopupBuilder(this.createFilterPanel(), null).setModalContext(false).setFocusable(false).setResizable(true).setCancelOnClickOutside(false).setMinSize(new Dimension(200, 200)).setDimensionServiceKey(this.myProject, "Search_Everywhere_Filter_Popup", false).addListener(popupCloseListener).createPopup();
        Disposer.register((Disposable)this.myParentDisposable, (Disposable)this.myFilterPopup);
        this.myFilterPopup.showUnderneathOf(anchor2);
    }

    private JComponent createFilterPanel() {
        final ElementsChooser<?> chooser = this.createChooser();
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel2.add(chooser);
        JPanel buttons = new JPanel();
        JButton all = new JButton("All");
        all.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                chooser.setAllElementsMarked(true);
            }
        });
        buttons.add(all);
        JButton none = new JButton("None");
        none.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                chooser.setAllElementsMarked(false);
            }
        });
        buttons.add(none);
        JButton invert2 = new JButton("Invert");
        invert2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                chooser.invertSelection();
            }
        });
        buttons.add(invert2);
        panel2.add(buttons);
        return panel2;
    }

    protected abstract ElementsChooser<?> createChooser();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/bigPopup/ShowFilterAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelected";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelected";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

