/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.newui.CellPluginComponent;
import com.intellij.ide.plugins.newui.DetailsPagePluginComponent;
import com.intellij.ide.plugins.newui.GridCellPluginComponent;
import com.intellij.ide.plugins.newui.InstallPluginInfo;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MyPluginModel
extends InstalledPluginsTableModel
implements PluginManagerMain.PluginEnabler {
    private final List<ListPluginComponent> myListComponents = new ArrayList<ListPluginComponent>();
    private final Map<IdeaPluginDescriptor, List<ListPluginComponent>> myListMap = new HashMap<IdeaPluginDescriptor, List<ListPluginComponent>>();
    private final Map<IdeaPluginDescriptor, List<GridCellPluginComponent>> myGridMap = new HashMap<IdeaPluginDescriptor, List<GridCellPluginComponent>>();
    private final List<PluginsGroup> myEnabledGroups = new ArrayList<PluginsGroup>();
    private PluginsGroupComponent myDownloadedPanel;
    private PluginsGroup myDownloaded;
    private PluginsGroup myInstalling;
    private PluginsGroup myUpdates;
    private Configurable.TopComponentController myTopController;
    private static final Set<IdeaPluginDescriptor> myInstallingPlugins = new HashSet<IdeaPluginDescriptor>();
    private static final Set<IdeaPluginDescriptor> myInstallingWithUpdatesPlugins = new HashSet<IdeaPluginDescriptor>();
    private static final Map<IdeaPluginDescriptor, InstallPluginInfo> myInstallingInfos = new HashMap<IdeaPluginDescriptor, InstallPluginInfo>();
    public boolean needRestart;
    public boolean createShutdownCallback = true;
    public DetailsPagePluginComponent detailPanel;
    private StatusBarEx myStatusBar;

    public MyPluginModel() {
        Window window = ProjectUtil.getActiveFrameOrWelcomeScreen();
        this.myStatusBar = MyPluginModel.getStatusBar(window);
        if (this.myStatusBar == null && window != null) {
            this.myStatusBar = MyPluginModel.getStatusBar(window.getOwner());
        }
    }

    @Nullable
    private static StatusBarEx getStatusBar(@Nullable Window frame) {
        if (frame instanceof IdeFrame && !(frame instanceof WelcomeFrame)) {
            return (StatusBarEx)((IdeFrame)frame).getStatusBar();
        }
        return null;
    }

    public void addComponent(@NotNull CellPluginComponent component) {
        if (component == null) {
            MyPluginModel.$$$reportNull$$$0(0);
        }
        if (component instanceof ListPluginComponent) {
            if (myInstallingPlugins.contains(component.myPlugin)) {
                return;
            }
            this.myListComponents.add((ListPluginComponent)component);
            List<ListPluginComponent> components = this.myListMap.get(component.myPlugin);
            if (components == null) {
                components = new ArrayList<ListPluginComponent>();
                this.myListMap.put(component.myPlugin, components);
            }
            components.add((ListPluginComponent)component);
        } else {
            List<GridCellPluginComponent> components = this.myGridMap.get(component.myPlugin);
            if (components == null) {
                components = new ArrayList<GridCellPluginComponent>();
                this.myGridMap.put(component.myPlugin, components);
            }
            components.add((GridCellPluginComponent)component);
        }
    }

    public void removeComponent(@NotNull CellPluginComponent component) {
        if (component == null) {
            MyPluginModel.$$$reportNull$$$0(1);
        }
        if (component instanceof ListPluginComponent) {
            this.myListComponents.remove((ListPluginComponent)component);
            List<ListPluginComponent> components = this.myListMap.get(component.myPlugin);
            if (components != null) {
                components.remove(component);
                if (components.isEmpty()) {
                    this.myListMap.remove(component.myPlugin);
                }
            }
        } else {
            List<GridCellPluginComponent> components = this.myGridMap.get(component.myPlugin);
            if (components != null) {
                components.remove(component);
                if (components.isEmpty()) {
                    this.myGridMap.remove(component.myPlugin);
                }
            }
        }
    }

    public void setTopController(@NotNull Configurable.TopComponentController topController) {
        if (topController == null) {
            MyPluginModel.$$$reportNull$$$0(2);
        }
        this.myTopController = topController;
        for (InstallPluginInfo info : myInstallingInfos.values()) {
            info.fromBackground(this);
        }
        if (!myInstallingInfos.isEmpty()) {
            this.myTopController.showProgress(true);
        }
    }

    @NotNull
    public static Set<IdeaPluginDescriptor> getInstallingPlugins() {
        Set<IdeaPluginDescriptor> set = myInstallingPlugins;
        if (set == null) {
            MyPluginModel.$$$reportNull$$$0(3);
        }
        return set;
    }

    public static boolean isInstallingOrUpdate(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            MyPluginModel.$$$reportNull$$$0(4);
        }
        return myInstallingWithUpdatesPlugins.contains(descriptor);
    }

    public void installOrUpdatePlugin(@NotNull IdeaPluginDescriptor descriptor, boolean install) {
        PluginNode pluginNode;
        if (descriptor == null) {
            MyPluginModel.$$$reportNull$$$0(5);
        }
        if (!PluginManagerMain.checkThirdPartyPluginsAllowed(Collections.singletonList(descriptor))) {
            return;
        }
        if (descriptor instanceof PluginNode) {
            pluginNode = (PluginNode)descriptor;
        } else {
            pluginNode = new PluginNode(descriptor.getPluginId(), descriptor.getName(), "-1");
            pluginNode.setDepends(Arrays.asList(descriptor.getDependentPluginIds()), descriptor.getOptionalDependentPluginIds());
            pluginNode.setRepositoryName("__unknown_repository__");
        }
        ArrayList pluginsToInstall = ContainerUtil.newArrayList((Object[])new PluginNode[]{pluginNode});
        PluginManagerMain.suggestToEnableInstalledDependantPlugins(this, pluginsToInstall);
        this.needRestart = true;
        MyPluginModel.installPlugin(pluginsToInstall, this.getAllRepoPlugins(), this, this.prepareToInstall(descriptor, install));
    }

    private static void installPlugin(@NotNull List<PluginNode> pluginsToInstall, @NotNull List<IdeaPluginDescriptor> allPlugins, @NotNull PluginManagerMain.PluginEnabler pluginEnabler, @NotNull InstallPluginInfo info) {
        if (pluginsToInstall == null) {
            MyPluginModel.$$$reportNull$$$0(6);
        }
        if (allPlugins == null) {
            MyPluginModel.$$$reportNull$$$0(7);
        }
        if (pluginEnabler == null) {
            MyPluginModel.$$$reportNull$$$0(8);
        }
        if (info == null) {
            MyPluginModel.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (pluginsToInstall == null) {
                MyPluginModel.$$$reportNull$$$0(36);
            }
            if (allPlugins == null) {
                MyPluginModel.$$$reportNull$$$0(37);
            }
            if (pluginEnabler == null) {
                MyPluginModel.$$$reportNull$$$0(38);
            }
            if (info == null) {
                MyPluginModel.$$$reportNull$$$0(39);
            }
            boolean cancel = false;
            boolean error = false;
            try {
                error = !PluginInstaller.prepareToInstall(pluginsToInstall, allPlugins, pluginEnabler, info.indicator);
            }
            catch (ProcessCanceledException e) {
                cancel = true;
            }
            catch (Throwable e) {
                PluginManagerMain.LOG.error(e);
                error = true;
            }
            boolean success2 = !error;
            boolean _cancel = cancel;
            ApplicationManager.getApplication().invokeLater(() -> {
                if (info == null) {
                    MyPluginModel.$$$reportNull$$$0(40);
                }
                info.finish(success2, _cancel);
            }, ModalityState.any());
        });
    }

    public void toBackground() {
        for (InstallPluginInfo info : myInstallingInfos.values()) {
            info.toBackground(this.myStatusBar);
        }
    }

    @NotNull
    private InstallPluginInfo prepareToInstall(@NotNull IdeaPluginDescriptor descriptor, boolean install) {
        List<ListPluginComponent> listComponents;
        List<GridCellPluginComponent> gridComponents;
        if (descriptor == null) {
            MyPluginModel.$$$reportNull$$$0(10);
        }
        InstallPluginInfo info = new InstallPluginInfo(descriptor, this, install);
        myInstallingInfos.put(descriptor, info);
        if (myInstallingWithUpdatesPlugins.isEmpty()) {
            this.myTopController.showProgress(true);
        }
        myInstallingWithUpdatesPlugins.add(descriptor);
        if (install) {
            myInstallingPlugins.add(descriptor);
        }
        if (install && this.myInstalling != null) {
            if (this.myInstalling.ui == null) {
                this.myInstalling.descriptors.add(descriptor);
                this.myDownloadedPanel.addGroup(this.myInstalling, 0);
            } else {
                this.myDownloadedPanel.addToGroup(this.myInstalling, descriptor);
            }
            this.myInstalling.titleWithCount();
            this.myDownloadedPanel.doLayout();
        }
        if ((gridComponents = this.myGridMap.get(descriptor)) != null) {
            for (GridCellPluginComponent gridComponent : gridComponents) {
                gridComponent.showProgress();
            }
        }
        if ((listComponents = this.myListMap.get(descriptor)) != null) {
            for (ListPluginComponent listComponent : listComponents) {
                listComponent.showProgress();
            }
        }
        if (this.detailPanel != null && this.detailPanel.myPlugin == descriptor) {
            this.detailPanel.showProgress();
        }
        InstallPluginInfo installPluginInfo = info;
        if (installPluginInfo == null) {
            MyPluginModel.$$$reportNull$$$0(11);
        }
        return installPluginInfo;
    }

    public void finishInstall(@NotNull IdeaPluginDescriptor descriptor, boolean success2, boolean showErrors) {
        List<ListPluginComponent> listComponents;
        List<GridCellPluginComponent> gridComponents;
        if (descriptor == null) {
            MyPluginModel.$$$reportNull$$$0(12);
        }
        InstallPluginInfo info = MyPluginModel.finishInstall(descriptor);
        if (myInstallingWithUpdatesPlugins.isEmpty()) {
            this.myTopController.showProgress(false);
        }
        if ((gridComponents = this.myGridMap.get(descriptor)) != null) {
            for (GridCellPluginComponent gridCellPluginComponent : gridComponents) {
                gridCellPluginComponent.hideProgress(success2);
            }
        }
        if ((listComponents = this.myListMap.get(descriptor)) != null) {
            for (ListPluginComponent listComponent : listComponents) {
                listComponent.hideProgress(success2);
            }
        }
        if (this.detailPanel != null && this.detailPanel.myPlugin == descriptor) {
            this.detailPanel.hideProgress(success2);
        }
        if (info.install) {
            if (this.myInstalling != null && this.myInstalling.ui != null) {
                this.clearInstallingProgress(descriptor);
                if (myInstallingPlugins.isEmpty()) {
                    this.myDownloadedPanel.removeGroup(this.myInstalling);
                } else {
                    this.myDownloadedPanel.removeFromGroup(this.myInstalling, descriptor);
                    this.myInstalling.titleWithCount();
                }
                this.myDownloadedPanel.doLayout();
            }
            if (success2) {
                this.appendOrUpdateDescriptor(descriptor);
            }
        } else if (success2) {
            PluginId pluginId;
            CellPluginComponent component;
            if (this.myDownloaded != null && this.myDownloaded.ui != null && (component = (CellPluginComponent)ContainerUtil.find(this.myDownloaded.ui.plugins, arg_0 -> MyPluginModel.lambda$finishInstall$2(pluginId = descriptor.getPluginId(), arg_0))) != null) {
                ((ListPluginComponent)component).changeUpdateToRestart();
            }
            if (this.myUpdates != null) {
                this.myUpdates.titleWithCount();
            }
        }
        info.indicator.cancel();
        if (!success2 && showErrors) {
            Messages.showErrorDialog((String)("Plugin " + descriptor.getName() + " download or installing failed"), (String)IdeBundle.message((String)"action.download.and.install.plugin", (Object[])new Object[0]));
        }
    }

    private void clearInstallingProgress(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            MyPluginModel.$$$reportNull$$$0(13);
        }
        if (myInstallingPlugins.isEmpty()) {
            for (CellPluginComponent listComponent : this.myInstalling.ui.plugins) {
                ((ListPluginComponent)listComponent).clearProgress();
            }
        } else {
            for (CellPluginComponent listComponent : this.myInstalling.ui.plugins) {
                if (listComponent.myPlugin != descriptor) continue;
                ((ListPluginComponent)listComponent).clearProgress();
                return;
            }
        }
    }

    @NotNull
    public static InstallPluginInfo finishInstall(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            MyPluginModel.$$$reportNull$$$0(14);
        }
        InstallPluginInfo info = myInstallingInfos.remove(descriptor);
        myInstallingWithUpdatesPlugins.remove(descriptor);
        if (info.install) {
            myInstallingPlugins.remove(descriptor);
        }
        InstallPluginInfo installPluginInfo = info;
        if (installPluginInfo == null) {
            MyPluginModel.$$$reportNull$$$0(15);
        }
        return installPluginInfo;
    }

    public void addProgress(@NotNull IdeaPluginDescriptor descriptor, @NotNull ProgressIndicatorEx indicator) {
        if (descriptor == null) {
            MyPluginModel.$$$reportNull$$$0(16);
        }
        if (indicator == null) {
            MyPluginModel.$$$reportNull$$$0(17);
        }
        MyPluginModel.myInstallingInfos.get((Object)descriptor).indicator.addStateDelegate(indicator);
    }

    public void removeProgress(@NotNull IdeaPluginDescriptor descriptor, @NotNull ProgressIndicatorEx indicator) {
        if (descriptor == null) {
            MyPluginModel.$$$reportNull$$$0(18);
        }
        if (indicator == null) {
            MyPluginModel.$$$reportNull$$$0(19);
        }
        MyPluginModel.myInstallingInfos.get((Object)descriptor).indicator.removeStateDelegate(indicator);
    }

    public void addEnabledGroup(@NotNull PluginsGroup group) {
        if (group == null) {
            MyPluginModel.$$$reportNull$$$0(20);
        }
        this.myEnabledGroups.add(group);
    }

    public void setDownloadedGroup(@NotNull PluginsGroupComponent panel2, @NotNull PluginsGroup downloaded, @NotNull PluginsGroup installing) {
        if (panel2 == null) {
            MyPluginModel.$$$reportNull$$$0(21);
        }
        if (downloaded == null) {
            MyPluginModel.$$$reportNull$$$0(22);
        }
        if (installing == null) {
            MyPluginModel.$$$reportNull$$$0(23);
        }
        this.myDownloadedPanel = panel2;
        this.myDownloaded = downloaded;
        this.myInstalling = installing;
    }

    public void setUpdateGroup(@NotNull PluginsGroup group) {
        if (group == null) {
            MyPluginModel.$$$reportNull$$$0(24);
        }
        this.myUpdates = group;
    }

    @Override
    public void appendOrUpdateDescriptor(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            MyPluginModel.$$$reportNull$$$0(25);
        }
        super.appendOrUpdateDescriptor(descriptor);
        this.needRestart = true;
        if (this.myDownloaded == null) {
            return;
        }
        if (this.myDownloaded.ui == null) {
            this.myDownloaded.descriptors.add(descriptor);
            this.myDownloaded.titleWithEnabled(this);
            this.myDownloadedPanel.addGroup(this.myDownloaded, this.myInstalling == null || this.myInstalling.ui == null ? 0 : 1);
            this.myDownloadedPanel.setSelection(this.myDownloaded.ui.plugins.get(0));
            this.myDownloadedPanel.doLayout();
            this.addEnabledGroup(this.myDownloaded);
        } else {
            String pluginId = descriptor.getPluginId().getIdString();
            for (CellPluginComponent component : this.myDownloaded.ui.plugins) {
                if (!pluginId.equals(component.myPlugin.getPluginId().getIdString())) continue;
                ((ListPluginComponent)component).changeUpdateToRestart();
                return;
            }
            this.myDownloadedPanel.addToGroup(this.myDownloaded, descriptor);
            this.myDownloaded.titleWithEnabled(this);
            this.myDownloadedPanel.setSelection(this.myDownloaded.ui.plugins.get(this.myDownloaded.descriptors.indexOf(descriptor)));
            this.myDownloadedPanel.doLayout();
        }
    }

    public boolean isEnabled(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            MyPluginModel.$$$reportNull$$$0(26);
        }
        return this.isEnabled(plugin.getPluginId());
    }

    @NotNull
    public String getEnabledTitle(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            MyPluginModel.$$$reportNull$$$0(27);
        }
        String string = this.isEnabled(plugin) ? "Disable" : "Enable";
        if (string == null) {
            MyPluginModel.$$$reportNull$$$0(28);
        }
        return string;
    }

    public void changeEnableDisable(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            MyPluginModel.$$$reportNull$$$0(29);
        }
        this.enableRows(new IdeaPluginDescriptor[]{plugin}, !this.isEnabled(plugin.getPluginId()));
        this.updateAfterEnableDisable();
    }

    public void changeEnableDisable(@NotNull IdeaPluginDescriptor[] plugins2, boolean state) {
        if (plugins2 == null) {
            MyPluginModel.$$$reportNull$$$0(30);
        }
        this.enableRows(plugins2, state);
        this.updateAfterEnableDisable();
    }

    @Override
    public void enablePlugins(Set<IdeaPluginDescriptor> disabled) {
        this.changeEnableDisable(disabled.toArray(new IdeaPluginDescriptor[0]), true);
    }

    @Override
    public void disablePlugins(Set<IdeaPluginDescriptor> disabled) {
        this.changeEnableDisable(disabled.toArray(new IdeaPluginDescriptor[0]), false);
    }

    public void enableRequiredPlugins(@NotNull IdeaPluginDescriptor descriptor) {
        Set<PluginId> requiredPluginIds;
        if (descriptor == null) {
            MyPluginModel.$$$reportNull$$$0(31);
        }
        if (ContainerUtil.isEmpty(requiredPluginIds = this.getRequiredPlugins(descriptor.getPluginId()))) {
            return;
        }
        List<IdeaPluginDescriptor> allPlugins = this.getAllPlugins();
        HashSet<IdeaPluginDescriptor> requiredPlugins = new HashSet<IdeaPluginDescriptor>();
        for (PluginId pluginId : requiredPluginIds) {
            IdeaPluginDescriptor result2 = (IdeaPluginDescriptor)ContainerUtil.find(allPlugins, d -> pluginId.equals(d.getPluginId()));
            if (result2 == null && PluginManagerCore.isModuleDependency(pluginId) && (result2 = (IdeaPluginDescriptor)ContainerUtil.find(allPlugins, d -> {
                if (d instanceof IdeaPluginDescriptorImpl) {
                    List<String> modules = ((IdeaPluginDescriptorImpl)d).getModules();
                    return modules != null && modules.contains(pluginId.getIdString());
                }
                return false;
            })) != null) {
                this.getEnabledMap().put(pluginId, Boolean.TRUE);
            }
            if (result2 == null) continue;
            requiredPlugins.add(result2);
        }
        if (!requiredPlugins.isEmpty()) {
            this.enablePlugins(requiredPlugins);
        }
    }

    private void updateAfterEnableDisable() {
        for (ListPluginComponent component : this.myListComponents) {
            component.updateEnabledState();
        }
        for (PluginsGroup group : this.myEnabledGroups) {
            group.titleWithEnabled(this);
        }
    }

    public boolean showUninstallDialog(@NotNull List<CellPluginComponent> selection) {
        int size;
        if (selection == null) {
            MyPluginModel.$$$reportNull$$$0(32);
        }
        return this.showUninstallDialog((size = selection.size()) == 1 ? selection.get((int)0).myPlugin.getName() : null, size);
    }

    public boolean showUninstallDialog(@Nullable String singleName, int count) {
        String message = singleName == null ? IdeBundle.message((String)"prompt.uninstall.several.plugins", (Object[])new Object[]{count}) : IdeBundle.message((String)"prompt.uninstall.plugin", (Object[])new Object[]{singleName});
        return Messages.showYesNoDialog((String)message, (String)IdeBundle.message((String)"title.plugin.uninstall", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
    }

    public void doUninstall(@NotNull Component uiParent, @NotNull IdeaPluginDescriptor descriptor, @Nullable Runnable update) {
        List<ListPluginComponent> listComponents;
        String title;
        String message;
        if (uiParent == null) {
            MyPluginModel.$$$reportNull$$$0(33);
        }
        if (descriptor == null) {
            MyPluginModel.$$$reportNull$$$0(34);
        }
        if (!this.dependent((IdeaPluginDescriptorImpl)descriptor).isEmpty() && Messages.showYesNoDialog((Component)uiParent, (String)(message = IdeBundle.message((String)"several.plugins.depend.on.0.continue.to.remove", (Object[])new Object[]{descriptor.getName()})), (String)(title = IdeBundle.message((String)"title.plugin.uninstall", (Object[])new Object[0])), (Icon)Messages.getQuestionIcon()) != 0) {
            return;
        }
        try {
            ((IdeaPluginDescriptorImpl)descriptor).setDeleted(true);
            PluginInstaller.prepareToUninstall(descriptor.getPluginId());
            this.needRestart |= descriptor.isEnabled();
        }
        catch (IOException e) {
            PluginManagerMain.LOG.error((Throwable)e);
        }
        if (update != null) {
            update.run();
        }
        if ((listComponents = this.myListMap.get(descriptor)) != null) {
            for (ListPluginComponent listComponent : listComponents) {
                listComponent.updateAfterUninstall();
            }
        }
        for (ListPluginComponent component : this.myListComponents) {
            component.updateErrors();
        }
    }

    public boolean hasErrors(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            MyPluginModel.$$$reportNull$$$0(35);
        }
        return PluginManagerCore.isIncompatible(plugin) || this.hasProblematicDependencies(plugin.getPluginId());
    }

    private static /* synthetic */ boolean lambda$finishInstall$2(PluginId pluginId, CellPluginComponent _component) {
        return pluginId.equals(_component.myPlugin.getPluginId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topController";
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/MyPluginModel";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 25: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsToInstall";
                break;
            }
            case 7: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allPlugins";
                break;
            }
            case 8: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginEnabler";
                break;
            }
            case 9: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloaded";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installing";
                break;
            }
            case 26: 
            case 27: 
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/MyPluginModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallingPlugins";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareToInstall";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "finishInstall";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeComponent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setTopController";
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 28: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInstallingOrUpdate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "installOrUpdatePlugin";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "installPlugin";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prepareToInstall";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "finishInstall";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "clearInstallingProgress";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addProgress";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeProgress";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addEnabledGroup";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setDownloadedGroup";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setUpdateGroup";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "appendOrUpdateDescriptor";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getEnabledTitle";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "changeEnableDisable";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "enableRequiredPlugins";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "showUninstallDialog";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "doUninstall";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "hasErrors";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$installPlugin$1";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

