/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.facet.frameworks.SettingsConnectionService;
import com.intellij.internal.statistic.eventLog.EventLogSettingsService;
import com.intellij.internal.statistic.eventLog.LogEventCompositeFilter;
import com.intellij.internal.statistic.eventLog.LogEventFilter;
import com.intellij.internal.statistic.eventLog.LogEventSnapshotBuildFilter;
import com.intellij.internal.statistic.eventLog.LogEventWhitelistFilter;
import com.intellij.internal.statistic.service.fus.FUStatisticsWhiteListGroupsService;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EventLogExternalSettingsService
extends SettingsConnectionService
implements EventLogSettingsService {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.internal.statistic.eventLog.EventLogExternalSettingsService");
    private static final String APPROVED_GROUPS_SERVICE = "white-list-service";
    private static final String PERCENT_TRAFFIC = "percent-traffic";

    public static EventLogExternalSettingsService getInstance() {
        return new EventLogExternalSettingsService();
    }

    protected EventLogExternalSettingsService() {
        super(((ApplicationInfoImpl)ApplicationInfoImpl.getShadowInstance()).getEventLogSettingsUrl(), null);
    }

    @NotNull
    public String[] getAttributeNames() {
        String[] stringArray = ArrayUtil.mergeArrays((String[])super.getAttributeNames(), (String[])new String[]{PERCENT_TRAFFIC, APPROVED_GROUPS_SERVICE});
        if (stringArray == null) {
            EventLogExternalSettingsService.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    @Override
    public int getPermittedTraffic() {
        String permitted = this.getSettingValue(PERCENT_TRAFFIC);
        if (permitted != null) {
            try {
                return Integer.parseInt(permitted);
            }
            catch (NumberFormatException e) {
                LOG.trace("Permitted traffic is not defined or has invalid format: '" + permitted + "'");
            }
        }
        return 0;
    }

    @NotNull
    public Set<String> getApprovedGroups() {
        Set<String> set = this.getWhitelistedGroups();
        if (set == null) {
            EventLogExternalSettingsService.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @NotNull
    public LogEventFilter getEventFilter() {
        Set<String> whitelist = this.getWhitelistedGroups();
        LogEventCompositeFilter logEventCompositeFilter = new LogEventCompositeFilter(new LogEventWhitelistFilter(whitelist), LogEventSnapshotBuildFilter.INSTANCE);
        if (logEventCompositeFilter == null) {
            EventLogExternalSettingsService.$$$reportNull$$$0(2);
        }
        return logEventCompositeFilter;
    }

    @NotNull
    private Set<String> getWhitelistedGroups() {
        String approvedGroupsServiceUrl = this.getSettingValue(APPROVED_GROUPS_SERVICE);
        if (approvedGroupsServiceUrl == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                EventLogExternalSettingsService.$$$reportNull$$$0(3);
            }
            return set;
        }
        BuildNumber build2 = ApplicationInfo.getInstance().getBuild();
        String productUrl = approvedGroupsServiceUrl + build2.getProductCode() + ".json";
        Set<String> set = FUStatisticsWhiteListGroupsService.getApprovedGroups(productUrl, EventLogExternalSettingsService.toReportedBuild(build2));
        if (set == null) {
            EventLogExternalSettingsService.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    private static BuildNumber toReportedBuild(@NotNull BuildNumber build2) {
        if (build2 == null) {
            EventLogExternalSettingsService.$$$reportNull$$$0(5);
        }
        if (build2.isSnapshot()) {
            String buildString = build2.asStringWithoutProductCodeAndSnapshot();
            BuildNumber buildNumber = BuildNumber.fromString((String)(buildString.endsWith(".") ? buildString + "0" : buildString));
            if (buildNumber == null) {
                EventLogExternalSettingsService.$$$reportNull$$$0(6);
            }
            return buildNumber;
        }
        BuildNumber buildNumber = build2;
        if (buildNumber == null) {
            EventLogExternalSettingsService.$$$reportNull$$$0(7);
        }
        return buildNumber;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/EventLogExternalSettingsService";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "build";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getApprovedGroups";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventFilter";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitelistedGroups";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/EventLogExternalSettingsService";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toReportedBuild";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toReportedBuild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

