/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.update.AbstractTreeNode;
import com.intellij.openapi.vcs.update.DirectoryTreeNode;
import com.intellij.openapi.vcs.update.FileOrDirectoryTreeNode;
import com.intellij.openapi.vcs.update.FileTreeNode;
import com.intellij.openapi.vcs.update.GroupByPackages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroupTreeNode
extends AbstractTreeNode
implements Disposable {
    private final String myName;
    private final boolean mySupportsDeletion;
    private final List<String> myFilePaths;
    private final Map<String, String> myErrorsMap;
    private final SimpleTextAttributes myInvalidAttributes;
    private final Project myProject;
    private final String myFileGroupId;

    public GroupTreeNode(@NotNull String name, boolean supportsDeletion, @NotNull SimpleTextAttributes invalidAttributes, @NotNull Project project, @NotNull Map<String, String> errorsMap, String id) {
        if (name == null) {
            GroupTreeNode.$$$reportNull$$$0(0);
        }
        if (invalidAttributes == null) {
            GroupTreeNode.$$$reportNull$$$0(1);
        }
        if (project == null) {
            GroupTreeNode.$$$reportNull$$$0(2);
        }
        if (errorsMap == null) {
            GroupTreeNode.$$$reportNull$$$0(3);
        }
        this.myFilePaths = new ArrayList<String>();
        this.myName = name;
        this.mySupportsDeletion = supportsDeletion;
        this.myInvalidAttributes = invalidAttributes;
        this.myProject = project;
        this.myErrorsMap = errorsMap;
        this.myFileGroupId = id;
    }

    public String getFileGroupId() {
        return this.myFileGroupId;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            GroupTreeNode.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public Icon getIcon(boolean expanded) {
        return AllIcons.Nodes.Folder;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getVirtualFiles() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            result2.addAll(((AbstractTreeNode)this.getChildAt(i)).getVirtualFiles());
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            GroupTreeNode.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<File> getFiles() {
        ArrayList<File> result2 = new ArrayList<File>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            result2.addAll(((AbstractTreeNode)this.getChildAt(i)).getFiles());
        }
        ArrayList<File> arrayList = result2;
        if (arrayList == null) {
            GroupTreeNode.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Override
    protected int getItemsCount() {
        int result2 = 0;
        Enumeration<TreeNode> children2 = this.children();
        while (children2.hasMoreElements()) {
            AbstractTreeNode treeNode = (AbstractTreeNode)children2.nextElement();
            result2 += treeNode.getItemsCount();
        }
        return result2;
    }

    @Override
    protected boolean showStatistics() {
        return true;
    }

    @Override
    @NotNull
    public SimpleTextAttributes getAttributes() {
        SimpleTextAttributes simpleTextAttributes = this.myFilterAttributes == null ? SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES : this.myFilterAttributes;
        if (simpleTextAttributes == null) {
            GroupTreeNode.$$$reportNull$$$0(7);
        }
        return simpleTextAttributes;
    }

    @Override
    public boolean getSupportsDeletion() {
        return this.mySupportsDeletion;
    }

    public void addFilePath(@NotNull String filePath) {
        if (filePath == null) {
            GroupTreeNode.$$$reportNull$$$0(8);
        }
        this.myFilePaths.add(filePath);
    }

    public void rebuild(boolean groupByPackages, @Nullable Pair<PackageSetBase, NamedScopesHolder> filter, boolean showOnlyFilteredItems) {
        this.myFilterAttributes = null;
        if (this.containsGroups()) {
            this.rebuildGroups(groupByPackages, filter, showOnlyFilteredItems);
        } else {
            this.rebuildFiles(groupByPackages, filter, showOnlyFilteredItems);
        }
    }

    private void rebuildGroups(boolean groupByPackages, @Nullable Pair<PackageSetBase, NamedScopesHolder> filter, boolean showOnlyFilteredItems) {
        boolean apply2 = false;
        for (int i = 0; i < this.getChildCount(); ++i) {
            GroupTreeNode childGroup = (GroupTreeNode)this.getChildAt(i);
            childGroup.rebuild(groupByPackages, filter, showOnlyFilteredItems);
            apply2 |= childGroup.myFilterAttributes != null;
        }
        this.applyFilter(apply2);
    }

    private void rebuildFiles(boolean groupByPackages, @Nullable Pair<PackageSetBase, NamedScopesHolder> filter, boolean showOnlyFilteredItems) {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            TreeNode node = this.getChildAt(i);
            if (!(node instanceof Disposable)) continue;
            Disposer.dispose((Disposable)((Disposable)node));
        }
        this.removeAllChildren();
        if (groupByPackages) {
            this.buildPackages();
            this.acceptFilter(filter, showOnlyFilteredItems);
        } else {
            this.buildFiles(filter, showOnlyFilteredItems);
        }
        this.setTreeModel(this.myTreeModel);
        if (this.myTreeModel != null) {
            this.myTreeModel.nodeStructureChanged(this);
        }
    }

    private void buildPackages() {
        LinkedHashSet<File> files2 = new LinkedHashSet<File>();
        for (String myFilePath : this.myFilePaths) {
            files2.add(new File(myFilePath));
        }
        GroupByPackages groupByPackages = new GroupByPackages(files2);
        List<File> roots = groupByPackages.getRoots();
        this.addFiles(this, roots, files2, groupByPackages, null);
    }

    private void addFiles(@NotNull AbstractTreeNode parentNode, @NotNull List<File> roots, @NotNull Collection<File> files2, @NotNull GroupByPackages groupByPackages, String parentPath) {
        if (parentNode == null) {
            GroupTreeNode.$$$reportNull$$$0(9);
        }
        if (roots == null) {
            GroupTreeNode.$$$reportNull$$$0(10);
        }
        if (files2 == null) {
            GroupTreeNode.$$$reportNull$$$0(11);
        }
        if (groupByPackages == null) {
            GroupTreeNode.$$$reportNull$$$0(12);
        }
        Collections.sort(roots, (file1, file2) -> {
            boolean containsFile2;
            boolean containsFile1;
            if (files2 == null) {
                GroupTreeNode.$$$reportNull$$$0(13);
            }
            if ((containsFile1 = files2.contains(file1)) == (containsFile2 = files2.contains(file2))) {
                return file1.getAbsolutePath().compareToIgnoreCase(file2.getAbsolutePath());
            }
            return containsFile1 ? 1 : -1;
        });
        for (File root : roots) {
            FileOrDirectoryTreeNode child2 = files2.contains(root) ? new FileTreeNode(root.getAbsolutePath(), this.myInvalidAttributes, this.myProject, parentPath) : new DirectoryTreeNode(root.getAbsolutePath(), this.myProject, parentPath);
            Disposer.register((Disposable)((Disposable)parentNode), (Disposable)child2);
            parentNode.add(child2);
            this.addFiles(child2, groupByPackages.getChildren(root), files2, groupByPackages, child2.getFilePath());
        }
    }

    private void buildFiles(@Nullable Pair<PackageSetBase, NamedScopesHolder> filter, boolean showOnlyFilteredItems) {
        Collections.sort(this.myFilePaths, (path1, path2) -> path1.compareToIgnoreCase((String)path2));
        boolean apply2 = false;
        for (String filePath : this.myFilePaths) {
            String error;
            FileTreeNode child2 = new FileTreeNode(filePath, this.myInvalidAttributes, this.myProject, null);
            if (filter != null) {
                if (child2.acceptFilter(filter, showOnlyFilteredItems)) {
                    apply2 = true;
                } else if (showOnlyFilteredItems) {
                    Disposer.dispose((Disposable)child2);
                    continue;
                }
            }
            if ((error = this.myErrorsMap.get(filePath)) != null) {
                child2.setErrorText(error);
            }
            this.add(child2);
            Disposer.register((Disposable)this, (Disposable)child2);
        }
        this.applyFilter(apply2);
    }

    private boolean containsGroups() {
        return this.myFilePaths.isEmpty();
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidAttributes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorsMap";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/update/GroupTreeNode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupByPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/update/GroupTreeNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addFilePath";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addFiles";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addFiles$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

