/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.NotNullFunction;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.RngCompactLanguage;
import org.intellij.plugins.relaxNG.compact.lexer.CompactSyntaxLexerAdapter;
import org.intellij.plugins.relaxNG.compact.parser.RncParser;
import org.intellij.plugins.relaxNG.compact.psi.RncElementVisitor;
import org.intellij.plugins.relaxNG.compact.psi.impl.RncElementImpl;
import org.intellij.plugins.relaxNG.compact.psi.impl.RncFileImpl;
import org.jetbrains.annotations.NotNull;

public class RncParserDefinition
implements ParserDefinition {
    public static final IFileElementType FILE_ELEMENT_TYPE = new IFileElementType((Language)RngCompactLanguage.INSTANCE);
    private static final TokenSet myCommentTypes = TokenSet.orSet((TokenSet[])new TokenSet[]{RncTokenTypes.COMMENTS, RncTokenTypes.DOC_TOKENS});

    @NotNull
    public Lexer createLexer(Project project) {
        CompactSyntaxLexerAdapter compactSyntaxLexerAdapter = new CompactSyntaxLexerAdapter();
        if (compactSyntaxLexerAdapter == null) {
            RncParserDefinition.$$$reportNull$$$0(0);
        }
        return compactSyntaxLexerAdapter;
    }

    public PsiParser createParser(Project project) {
        return new RncParser();
    }

    public IFileElementType getFileNodeType() {
        return FILE_ELEMENT_TYPE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE});
        if (tokenSet == null) {
            RncParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = myCommentTypes;
        if (tokenSet == null) {
            RncParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{RncTokenTypes.LITERAL});
        if (tokenSet == null) {
            RncParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type = node.getElementType();
        if (type instanceof NotNullFunction) {
            PsiElement psiElement = (PsiElement)((NotNullFunction)type).fun((Object)node);
            if (psiElement == null) {
                RncParserDefinition.$$$reportNull$$$0(4);
            }
            return psiElement;
        }
        MyRncElement myRncElement = new MyRncElement(node);
        if (myRncElement == null) {
            RncParserDefinition.$$$reportNull$$$0(5);
        }
        return myRncElement;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new RncFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/intellij/plugins/relaxNG/compact/RncParserDefinition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MyRncElement
    extends RncElementImpl {
        MyRncElement(ASTNode node) {
            super(node);
        }

        @Override
        public void accept(@NotNull RncElementVisitor visitor) {
            if (visitor == null) {
                MyRncElement.$$$reportNull$$$0(0);
            }
            visitor.visitElement(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/intellij/plugins/relaxNG/compact/RncParserDefinition$MyRncElement", "accept"));
        }
    }
}

