/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.mandatory.NullCheckingFactory;
import org.jetbrains.plugins.github.exceptions.GithubJsonException;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u0002H\f\"\u0006\b\u0000\u0010\f\u0018\u00012\u0006\u0010\r\u001a\u00020\u0004H\u0086\b\u00a2\u0006\u0002\u0010\u000eJ)\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\r\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\f0\u0010H\u0007\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J)\u0010\u0016\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\f0\u001aH\u0007\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0001H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiContentHelper;", "", "()V", "JSON_MIME_TYPE", "", "V3_HTML_JSON_MIME_TYPE", "V3_JSON_MIME_TYPE", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "fromJson", "T", "string", "(Ljava/lang/String;)Ljava/lang/Object;", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "loadImage", "Ljava/awt/Image;", "stream", "Ljava/io/InputStream;", "readJson", "reader", "Ljava/io/Reader;", "typeToken", "Lcom/google/gson/reflect/TypeToken;", "(Ljava/io/Reader;Lcom/google/gson/reflect/TypeToken;)Ljava/lang/Object;", "toJson", "content", "intellij.vcs.github"})
public final class GithubApiContentHelper {
    @NotNull
    public static final String JSON_MIME_TYPE = "application/json";
    @NotNull
    public static final String V3_JSON_MIME_TYPE = "application/vnd.github.v3+json";
    @NotNull
    public static final String V3_HTML_JSON_MIME_TYPE = "application/vnd.github.v3.html+json";
    @NotNull
    private static final Gson gson;
    public static final GithubApiContentHelper INSTANCE;

    @NotNull
    public final Gson getGson() {
        return gson;
    }

    private final <T> T fromJson(String string) throws GithubJsonException {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)GithubApiContentHelper.fromJson(string, Object.class);
    }

    @JvmStatic
    public static final <T> T fromJson(@NotNull String string, @NotNull Class<T> clazz) throws GithubJsonException {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        try {
            TypeToken typeToken = TypeToken.get(clazz);
            Intrinsics.checkExpressionValueIsNotNull((Object)typeToken, (String)"TypeToken.get(clazz)");
            return (T)gson.fromJson(string, typeToken.getType());
        }
        catch (JsonParseException e) {
            throw (Throwable)new GithubJsonException("Couldn't parse GitHub response", e);
        }
    }

    @JvmStatic
    public static final <T> T readJson(@NotNull Reader reader, @NotNull TypeToken<T> typeToken) throws GithubJsonException {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        Intrinsics.checkParameterIsNotNull(typeToken, (String)"typeToken");
        try {
            return (T)gson.fromJson(reader, typeToken.getType());
        }
        catch (JsonParseException e) {
            throw (Throwable)new GithubJsonException("Couldn't parse GitHub response", e);
        }
    }

    @JvmStatic
    @NotNull
    public static final String toJson(@NotNull Object content) throws GithubJsonException {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        try {
            String string = gson.toJson(content);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gson.toJson(content)");
            return string;
        }
        catch (JsonIOException e) {
            throw (Throwable)new GithubJsonException("Couldn't serialize GitHub request body", e);
        }
    }

    @JvmStatic
    @NotNull
    public static final Image loadImage(@NotNull InputStream stream) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        BufferedImage bufferedImage = ImageIO.read(stream);
        Intrinsics.checkExpressionValueIsNotNull((Object)bufferedImage, (String)"ImageIO.read(stream)");
        return bufferedImage;
    }

    private GithubApiContentHelper() {
    }

    static {
        GithubApiContentHelper githubApiContentHelper;
        INSTANCE = githubApiContentHelper = new GithubApiContentHelper();
        Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapterFactory((TypeAdapterFactory)NullCheckingFactory.INSTANCE).create();
        Intrinsics.checkExpressionValueIsNotNull((Object)gson, (String)"GsonBuilder()\n    .setDa\u2026y.INSTANCE)\n    .create()");
        GithubApiContentHelper.gson = gson;
    }
}

