/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.LazyInitializer;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.anim.dom.SVGOMAnimatedLength;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.anim.dom.SVGOMRectElement;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class SVGLoader {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.SVGLoader");
    private static SvgColorPatcher ourColorPatcher = null;
    public static final int ICON_DEFAULT_SIZE = 16;
    public static final LazyInitializer.NotNullValue<Double> ICON_MAX_SIZE = new LazyInitializer.NotNullValue<Double>(){

        @Override
        @NotNull
        public Double initialize() {
            double maxSize = 2.147483647E9;
            if (!GraphicsEnvironment.isHeadless()) {
                GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                Rectangle bounds = device.getDefaultConfiguration().getBounds();
                AffineTransform tx = device.getDefaultConfiguration().getDefaultTransform();
                maxSize = (int)Math.max((double)bounds.width * tx.getScaleX(), (double)bounds.height * tx.getScaleY());
            }
            Double d = maxSize;
            if (d == null) {
                1.$$$reportNull$$$0(0);
            }
            return d;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/SVGLoader$1", "initialize"));
        }
    };
    private final TranscoderInput myTranscoderInput;
    private final double myScale;
    private final double myOverridenWidth;
    private final double myOverridenHeight;
    private BufferedImage myImage;

    public static Image load(@NotNull URL url, float scale) throws IOException {
        if (url == null) {
            SVGLoader.$$$reportNull$$$0(0);
        }
        return SVGLoader.load(url, url.openStream(), scale);
    }

    public static Image load(@NotNull InputStream stream, float scale) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(1);
        }
        return SVGLoader.load(null, stream, scale);
    }

    public static Image load(@Nullable URL url, @NotNull InputStream stream, double scale) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(2);
        }
        try {
            return new SVGLoader(url, stream, scale).createImage();
        }
        catch (TranscoderException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Image load(@Nullable URL url, @NotNull InputStream stream, double width, double d) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(3);
        }
        try {
            void height;
            return new SVGLoader(url, stream, width, (double)height, 1.0).createImage();
        }
        catch (TranscoderException ex) {
            throw new IOException(ex);
        }
    }

    public static <T extends BufferedImage> T loadHiDPI(@Nullable URL url, @NotNull InputStream stream, JBUI.ScaleContext ctx) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(4);
        }
        BufferedImage image = (BufferedImage)SVGLoader.load(url, stream, ctx.getScale(JBUI.ScaleType.PIX_SCALE));
        return (T)((BufferedImage)ImageUtil.ensureHiDPI(image, ctx));
    }

    public static Dimension2D loadInfo(@Nullable URL url, @NotNull InputStream stream, double scale) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(5);
        }
        return new SVGLoader(url, stream, scale).getDocumentSize();
    }

    public static double getMaxZoomFactor(@Nullable URL url, @NotNull InputStream stream, @NotNull JBUI.ScaleContext ctx) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(6);
        }
        if (ctx == null) {
            SVGLoader.$$$reportNull$$$0(7);
        }
        SVGLoader loader = new SVGLoader(url, stream, ctx.getScale(JBUI.ScaleType.PIX_SCALE));
        Dimension2D size = loader.getDocumentSize();
        return Math.min(ICON_MAX_SIZE.get() / size.getWidth(), ICON_MAX_SIZE.get() / size.getHeight());
    }

    private SVGLoader(@Nullable URL url, InputStream stream, double scale) throws IOException {
        this(url, stream, -1.0, -1.0, scale);
    }

    private SVGLoader(@Nullable URL url, InputStream stream, double width, double height, double scale) throws IOException {
        String uri = null;
        try {
            if (url != null && "jar".equals(url.getProtocol()) && stream != null) {
                url = new URL(url.getPath());
            }
            uri = url != null ? url.toURI().toString() : null;
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        Document document = new MySAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName()).createDocument(uri, stream);
        if (document == null) {
            throw new IOException("document not created");
        }
        SVGLoader.patchColors(document);
        this.myTranscoderInput = new TranscoderInput(document);
        this.myOverridenWidth = width;
        this.myOverridenHeight = height;
        this.myScale = scale;
    }

    private static void patchColors(Document document) {
        if (ourColorPatcher != null) {
            ourColorPatcher.patchColors(document.getDocumentElement());
        }
    }

    public static void setColorPatcher(@Nullable SvgColorPatcher colorPatcher) {
        ourColorPatcher = colorPatcher;
        IconLoader.clearCache();
    }

    private BufferedImage createImage() throws TranscoderException {
        MyTranscoder transcoder = new MyTranscoder();
        if (this.myOverridenWidth != -1.0) {
            transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, new Float(this.myOverridenWidth));
        }
        if (this.myOverridenHeight != -1.0) {
            transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, new Float(this.myOverridenHeight));
        }
        transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_MAX_WIDTH, new Float(ICON_MAX_SIZE.get()));
        transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_MAX_HEIGHT, new Float(ICON_MAX_SIZE.get()));
        transcoder.transcode(this.myTranscoderInput, null);
        return this.myImage;
    }

    private Dimension2D getDocumentSize() {
        SVGOMDocument document = (SVGOMDocument)this.myTranscoderInput.getDocument();
        BridgeContext ctx = new MyTranscoder().createBridgeContext(document);
        new GVTBuilder().build(ctx, (Document)document);
        Dimension2D size = ctx.getDocumentSize();
        size.setSize(size.getWidth() * this.myScale, size.getHeight() * this.myScale);
        return size;
    }

    @NotNull
    private static SVGDocument createFallbackPlaceholder() {
        SVGDocument sVGDocument;
        try {
            String fallbackIcon = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewBox=\"0 0 16 16\">\n  <rect x=\"1\" y=\"1\" width=\"14\" height=\"14\" fill=\"none\" stroke=\"red\" stroke-width=\"2\"/>\n  <line x1=\"1\" y1=\"1\" x2=\"15\" y2=\"15\" stroke=\"red\" stroke-width=\"2\"/>\n  <line x1=\"1\" y1=\"15\" x2=\"15\" y2=\"1\" stroke=\"red\" stroke-width=\"2\"/>\n</svg>\n";
            SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());
            sVGDocument = (SVGDocument)factory.createDocument(null, (Reader)new StringReader(fallbackIcon));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (sVGDocument == null) {
            SVGLoader.$$$reportNull$$$0(8);
        }
        return sVGDocument;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/SVGLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/SVGLoader";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createFallbackPlaceholder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadHiDPI";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadInfo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMaxZoomFactor";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySVGDOMImplementation
    extends SVGDOMImplementation {
        private MySVGDOMImplementation() {
        }

        static {
            svg11Factories.put("rect", new SVGDOMImplementation.RectElementFactory(){

                public Element create(String prefix, Document doc) {
                    return new SVGOMRectElement(prefix, (AbstractDocument)doc){

                        protected SVGOMAnimatedLength createLiveAnimatedLength(String ns, String ln, String def, short dir, boolean nonneg) {
                            if (def == null && ("width".equals(ln) || "height".equals(ln))) {
                                def = "0";
                            }
                            return super.createLiveAnimatedLength(ns, ln, def, dir, nonneg);
                        }
                    };
                }
            });
        }
    }

    private static class MySAXSVGDocumentFactory
    extends SAXSVGDocumentFactory {
        MySAXSVGDocumentFactory(String parser) {
            super(parser);
            this.implementation = new MySVGDOMImplementation();
        }
    }

    public static interface SvgColorPatcher {
        public void patchColors(Element var1);
    }

    private class MyTranscoder
    extends ImageTranscoder {
        protected MyTranscoder() {
            this.width = 16.0f;
            this.height = 16.0f;
        }

        protected void setImageSize(float docWidth, float docHeight) {
            super.setImageSize((float)((double)docWidth * SVGLoader.this.myScale), (float)((double)docHeight * SVGLoader.this.myScale));
        }

        public BufferedImage createImage(int w, int h) {
            return new BufferedImage(w, h, 2);
        }

        public void writeImage(BufferedImage img, TranscoderOutput output) {
            SVGLoader.this.myImage = img;
        }

        protected UserAgent createUserAgent() {
            return new SVGAbstractTranscoder.SVGAbstractTranscoderUserAgent(){

                public SVGDocument getBrokenLinkDocument(Element e, String url, String message) {
                    LOG.warn(url + " " + message);
                    return SVGLoader.createFallbackPlaceholder();
                }
            };
        }

        public BridgeContext createBridgeContext(SVGOMDocument doc) {
            return super.createBridgeContext(doc);
        }
    }
}

