/*
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_UTIL_API_H
#define _ST_UTIL_API_H

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define ST_NUMERIC			"0123456789"

char		*st_format_bitrate		(int		bitrate);
char		*st_format_samplerate		(int		samplerate);
char		*st_format_channels		(int		channels);

char		*st_format_audio_properties	(int		bitrate,
						 int		samplerate,
						 int		channels);

char		*st_strchr_span			(const char	*str,
						 int		c);
char		*st_strstr_span			(const char	*big,
						 const char	*little);
char		*st_str_has_prefix_span		(const char	*str,
						 const char	*prefix);
gboolean	st_str_like			(const char	*str,
						 const char	*charset);

GdkPixbuf	*st_pixbuf_new_from_file	(const char	*filename);
GtkWidget	*st_hig_section_new		(const char	*title,
						 GtkWidget	*contents);
void		st_set_tooltip			(GtkWidget	*widget,
						 const char	*tooltip);

G_END_DECLS

#endif /* _ST_UTIL_API_H */
