/*
 * 
 * Copyright (C) 2012-2025 Uwe Waldmann
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this font software and associated files (the "Software"),
 * to deal in the Software without restriction, including without
 * limitation the rights to use, copy, modify, merge, publish,
 * distribute, embed, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 * 
 * (1) The above copyright notice, this permission notice, and the
 *     disclaimer below shall be included in all copies or substantial
 *     portions of the Software.
 * 
 * (2) If the design of any glyphs in the fonts that are contained in the
 *     Software or generated during the installation process is modified
 *     or if additional glyphs are added to the fonts, the fonts
 *     must be renamed. The new names may not contain the word "UW",
 *     irrespective of capitalisation; the new names may contain the word
 *     "ttyp0", irrespective of capitalisation, only if preceded by a
 *     foundry name different from "UW".
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

extern u_char UWTtyp0_6x12_data[];

struct wsdisplay_font UWTtyp0_6x12 = {
	"UW Ttyp0 6x12", /* typeface name */
	0, /* firstchar */
	256, /* numchars */
	WSDISPLAY_FONTENC_IBM, /* encoding */
	6, /* width */
	12, /* height */
	1, /* stride */
	WSDISPLAY_FONTORDER_L2R, /* bit order */
	WSDISPLAY_FONTORDER_L2R, /* byte order */
	UWTtyp0_6x12_data /* data */
};

static u_char UWTtyp0_6x12_data[] = {
	/* chr0 */
	0x00,    /* ...... */
	0x68,    /* .##.#. */
	0x08,    /* ....#. */
	0x40,    /* .#.... */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x08,    /* ....#. */
	0x40,    /* .#.... */
	0x58,    /* .#.##. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr1 */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0xAC,    /* #.#.## */
	0x84,    /* #....# */
	0xCC,    /* ##..## */
	0xB4,    /* #.##.# */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr2 */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x78,    /* .####. */
	0xD4,    /* ##.#.# */
	0xFC,    /* ###### */
	0xB4,    /* #.##.# */
	0xCC,    /* ##..## */
	0x78,    /* .####. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr3 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x28,    /* ..#.#. */
	0x7C,    /* .##### */
	0x7C,    /* .##### */
	0x38,    /* ..###. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr4 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x10,    /* ...#.. */
	0x38,    /* ..###. */
	0x7C,    /* .##### */
	0x7C,    /* .##### */
	0x38,    /* ..###. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr5 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x10,    /* ...#.. */
	0x38,    /* ..###. */
	0x54,    /* .#.#.# */
	0x7C,    /* .##### */
	0x54,    /* .#.#.# */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr6 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x10,    /* ...#.. */
	0x38,    /* ..###. */
	0x7C,    /* .##### */
	0x7C,    /* .##### */
	0x10,    /* ...#.. */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr7 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x78,    /* .####. */
	0x78,    /* .####. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr8 */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xCC,    /* ##..## */
	0x84,    /* #....# */
	0x84,    /* #....# */
	0xCC,    /* ##..## */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xFC,    /* ###### */

	/* chr9 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x38,    /* ..###. */
	0x44,    /* .#...# */
	0x44,    /* .#...# */
	0x44,    /* .#...# */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr10 */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xC4,    /* ##...# */
	0xB8,    /* #.###. */
	0xB8,    /* #.###. */
	0xB8,    /* #.###. */
	0xC4,    /* ##...# */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xFC,    /* ###### */

	/* chr11 */
	0x00,    /* ...... */
	0x1C,    /* ...### */
	0x0C,    /* ....## */
	0x14,    /* ...#.# */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr12 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x38,    /* ..###. */
	0x44,    /* .#...# */
	0x44,    /* .#...# */
	0x38,    /* ..###. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x7C,    /* .##### */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */

	/* chr13 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x10,    /* ...#.. */
	0x18,    /* ...##. */
	0x14,    /* ...#.# */
	0x14,    /* ...#.# */
	0x14,    /* ...#.# */
	0x70,    /* .###.. */
	0x70,    /* .###.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr14 */
	0x00,    /* ...... */
	0x04,    /* .....# */
	0x0C,    /* ....## */
	0x14,    /* ...#.# */
	0x24,    /* ..#..# */
	0x24,    /* ..#..# */
	0x2C,    /* ..#.## */
	0x6C,    /* .##.## */
	0x68,    /* .##.#. */
	0x40,    /* .#.... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr15 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0xB0,    /* #.##.. */
	0x4C,    /* .#..## */
	0xC8,    /* ##..#. */
	0x34,    /* ..##.# */
	0x50,    /* .#.#.. */
	0x50,    /* .#.#.. */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr16 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x40,    /* .#.... */
	0x70,    /* .###.. */
	0x7C,    /* .##### */
	0x70,    /* .###.. */
	0x40,    /* .#.... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr17 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x04,    /* .....# */
	0x1C,    /* ...### */
	0x7C,    /* .##### */
	0x1C,    /* ...### */
	0x04,    /* .....# */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr18 */
	0x10,    /* ...#.. */
	0x38,    /* ..###. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x38,    /* ..###. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */

	/* chr19 */
	0x00,    /* ...... */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x00,    /* ...... */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr20 */
	0x00,    /* ...... */
	0x3C,    /* ..#### */
	0x54,    /* .#.#.# */
	0x54,    /* .#.#.# */
	0x34,    /* ..##.# */
	0x14,    /* ...#.# */
	0x14,    /* ...#.# */
	0x14,    /* ...#.# */
	0x14,    /* ...#.# */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr21 */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x20,    /* ..#... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x10,    /* ...#.. */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */

	/* chr22 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x7C,    /* .##### */
	0x7C,    /* .##### */
	0x7C,    /* .##### */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr23 */
	0x10,    /* ...#.. */
	0x38,    /* ..###. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x38,    /* ..###. */
	0x10,    /* ...#.. */
	0x38,    /* ..###. */
	0x00,    /* ...... */

	/* chr24 */
	0x10,    /* ...#.. */
	0x38,    /* ..###. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */

	/* chr25 */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x38,    /* ..###. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */

	/* chr26 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x08,    /* ....#. */
	0xFC,    /* ###### */
	0x08,    /* ....#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr27 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x20,    /* ..#... */
	0x7C,    /* .##### */
	0x20,    /* ..#... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr28 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x7C,    /* .##### */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr29 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x28,    /* ..#.#. */
	0x7C,    /* .##### */
	0x28,    /* ..#.#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr30 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x10,    /* ...#.. */
	0x38,    /* ..###. */
	0x38,    /* ..###. */
	0x7C,    /* .##### */
	0x7C,    /* .##### */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr31 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x7C,    /* .##### */
	0x7C,    /* .##### */
	0x38,    /* ..###. */
	0x38,    /* ..###. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr32 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr33 */
	0x00,    /* ...... */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr34 */
	0x00,    /* ...... */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr35 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x7C,    /* .##### */
	0x28,    /* ..#.#. */
	0x7C,    /* .##### */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr36 */
	0x00,    /* ...... */
	0x10,    /* ...#.. */
	0x38,    /* ..###. */
	0x54,    /* .#.#.# */
	0x50,    /* .#.#.. */
	0x38,    /* ..###. */
	0x14,    /* ...#.# */
	0x54,    /* .#.#.# */
	0x38,    /* ..###. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr37 */
	0x00,    /* ...... */
	0x24,    /* ..#..# */
	0x54,    /* .#.#.# */
	0x28,    /* ..#.#. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x28,    /* ..#.#. */
	0x54,    /* .#.#.# */
	0x48,    /* .#..#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr38 */
	0x00,    /* ...... */
	0x20,    /* ..#... */
	0x50,    /* .#.#.. */
	0x50,    /* .#.#.. */
	0x20,    /* ..#... */
	0x54,    /* .#.#.# */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x34,    /* ..##.# */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr39 */
	0x00,    /* ...... */
	0x18,    /* ...##. */
	0x10,    /* ...#.. */
	0x20,    /* ..#... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr40 */
	0x08,    /* ....#. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x08,    /* ....#. */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr41 */
	0x20,    /* ..#... */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x08,    /* ....#. */
	0x08,    /* ....#. */
	0x08,    /* ....#. */
	0x08,    /* ....#. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x20,    /* ..#... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr42 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x28,    /* ..#.#. */
	0x10,    /* ...#.. */
	0x7C,    /* .##### */
	0x10,    /* ...#.. */
	0x28,    /* ..#.#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr43 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x7C,    /* .##### */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr44 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x30,    /* ..##.. */
	0x20,    /* ..#... */
	0x40,    /* .#.... */
	0x00,    /* ...... */

	/* chr45 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x78,    /* .####. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr46 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr47 */
	0x04,    /* .....# */
	0x04,    /* .....# */
	0x08,    /* ....#. */
	0x08,    /* ....#. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr48 */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x68,    /* .##.#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x58,    /* .#.##. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr49 */
	0x00,    /* ...... */
	0x10,    /* ...#.. */
	0x30,    /* ..##.. */
	0x50,    /* .#.#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr50 */
	0x00,    /* ...... */
	0x70,    /* .###.. */
	0x48,    /* .#..#. */
	0x08,    /* ....#. */
	0x08,    /* ....#. */
	0x10,    /* ...#.. */
	0x20,    /* ..#... */
	0x40,    /* .#.... */
	0x78,    /* .####. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr51 */
	0x00,    /* ...... */
	0x70,    /* .###.. */
	0x08,    /* ....#. */
	0x08,    /* ....#. */
	0x30,    /* ..##.. */
	0x08,    /* ....#. */
	0x08,    /* ....#. */
	0x08,    /* ....#. */
	0x70,    /* .###.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr52 */
	0x00,    /* ...... */
	0x10,    /* ...#.. */
	0x30,    /* ..##.. */
	0x30,    /* ..##.. */
	0x50,    /* .#.#.. */
	0x50,    /* .#.#.. */
	0x78,    /* .####. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr53 */
	0x00,    /* ...... */
	0x78,    /* .####. */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x70,    /* .###.. */
	0x08,    /* ....#. */
	0x08,    /* ....#. */
	0x08,    /* ....#. */
	0x70,    /* .###.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr54 */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x70,    /* .###.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr55 */
	0x00,    /* ...... */
	0x78,    /* .####. */
	0x08,    /* ....#. */
	0x08,    /* ....#. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr56 */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr57 */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x38,    /* ..###. */
	0x08,    /* ....#. */
	0x08,    /* ....#. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr58 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr59 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x30,    /* ..##.. */
	0x20,    /* ..#... */
	0x40,    /* .#.... */
	0x00,    /* ...... */

	/* chr60 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x08,    /* ....#. */
	0x10,    /* ...#.. */
	0x20,    /* ..#... */
	0x40,    /* .#.... */
	0x20,    /* ..#... */
	0x10,    /* ...#.. */
	0x08,    /* ....#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr61 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x7C,    /* .##### */
	0x00,    /* ...... */
	0x7C,    /* .##### */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr62 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x40,    /* .#.... */
	0x20,    /* ..#... */
	0x10,    /* ...#.. */
	0x08,    /* ....#. */
	0x10,    /* ...#.. */
	0x20,    /* ..#... */
	0x40,    /* .#.... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr63 */
	0x00,    /* ...... */
	0x38,    /* ..###. */
	0x44,    /* .#...# */
	0x04,    /* .....# */
	0x08,    /* ....#. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr64 */
	0x00,    /* ...... */
	0x18,    /* ...##. */
	0x24,    /* ..#..# */
	0x4C,    /* .#..## */
	0x54,    /* .#.#.# */
	0x54,    /* .#.#.# */
	0x4C,    /* .#..## */
	0x20,    /* ..#... */
	0x1C,    /* ...### */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr65 */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x78,    /* .####. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr66 */
	0x00,    /* ...... */
	0x70,    /* .###.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x70,    /* .###.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x70,    /* .###.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr67 */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr68 */
	0x00,    /* ...... */
	0x60,    /* .##... */
	0x50,    /* .#.#.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x50,    /* .#.#.. */
	0x60,    /* .##... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr69 */
	0x00,    /* ...... */
	0x78,    /* .####. */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x70,    /* .###.. */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x78,    /* .####. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr70 */
	0x00,    /* ...... */
	0x3C,    /* ..#### */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x38,    /* ..###. */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr71 */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x58,    /* .#.##. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr72 */
	0x00,    /* ...... */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x78,    /* .####. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr73 */
	0x00,    /* ...... */
	0x38,    /* ..###. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr74 */
	0x00,    /* ...... */
	0x18,    /* ...##. */
	0x08,    /* ....#. */
	0x08,    /* ....#. */
	0x08,    /* ....#. */
	0x08,    /* ....#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr75 */
	0x00,    /* ...... */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x50,    /* .#.#.. */
	0x60,    /* .##... */
	0x50,    /* .#.#.. */
	0x50,    /* .#.#.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr76 */
	0x00,    /* ...... */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x78,    /* .####. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr77 */
	0x00,    /* ...... */
	0x44,    /* .#...# */
	0x6C,    /* .##.## */
	0x6C,    /* .##.## */
	0x54,    /* .#.#.# */
	0x54,    /* .#.#.# */
	0x44,    /* .#...# */
	0x44,    /* .#...# */
	0x44,    /* .#...# */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr78 */
	0x00,    /* ...... */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x68,    /* .##.#. */
	0x68,    /* .##.#. */
	0x58,    /* .#.##. */
	0x58,    /* .#.##. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr79 */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr80 */
	0x00,    /* ...... */
	0x70,    /* .###.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x70,    /* .###.. */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr81 */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x68,    /* .##.#. */
	0x58,    /* .#.##. */
	0x30,    /* ..##.. */
	0x08,    /* ....#. */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr82 */
	0x00,    /* ...... */
	0x70,    /* .###.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x70,    /* .###.. */
	0x50,    /* .#.#.. */
	0x50,    /* .#.#.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr83 */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x40,    /* .#.... */
	0x20,    /* ..#... */
	0x10,    /* ...#.. */
	0x08,    /* ....#. */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr84 */
	0x00,    /* ...... */
	0x7C,    /* .##### */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr85 */
	0x00,    /* ...... */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr86 */
	0x00,    /* ...... */
	0x44,    /* .#...# */
	0x44,    /* .#...# */
	0x44,    /* .#...# */
	0x44,    /* .#...# */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr87 */
	0x00,    /* ...... */
	0x44,    /* .#...# */
	0x44,    /* .#...# */
	0x44,    /* .#...# */
	0x54,    /* .#.#.# */
	0x54,    /* .#.#.# */
	0x7C,    /* .##### */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr88 */
	0x00,    /* ...... */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr89 */
	0x00,    /* ...... */
	0x44,    /* .#...# */
	0x44,    /* .#...# */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr90 */
	0x00,    /* ...... */
	0x78,    /* .####. */
	0x08,    /* ....#. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x40,    /* .#.... */
	0x78,    /* .####. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr91 */
	0x38,    /* ..###. */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr92 */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x08,    /* ....#. */
	0x08,    /* ....#. */
	0x04,    /* .....# */
	0x04,    /* .....# */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr93 */
	0x38,    /* ..###. */
	0x08,    /* ....#. */
	0x08,    /* ....#. */
	0x08,    /* ....#. */
	0x08,    /* ....#. */
	0x08,    /* ....#. */
	0x08,    /* ....#. */
	0x08,    /* ....#. */
	0x08,    /* ....#. */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr94 */
	0x00,    /* ...... */
	0x10,    /* ...#.. */
	0x28,    /* ..#.#. */
	0x44,    /* .#...# */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr95 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x78,    /* .####. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr96 */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x10,    /* ...#.. */
	0x08,    /* ....#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr97 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x08,    /* ....#. */
	0x38,    /* ..###. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr98 */
	0x00,    /* ...... */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x70,    /* .###.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x70,    /* .###.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr99 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr100 */
	0x00,    /* ...... */
	0x08,    /* ....#. */
	0x08,    /* ....#. */
	0x38,    /* ..###. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr101 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x78,    /* .####. */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr102 */
	0x00,    /* ...... */
	0x18,    /* ...##. */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x78,    /* .####. */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr103 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x38,    /* ..###. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x78,    /* .####. */
	0x08,    /* ....#. */
	0x48,    /* .#..#. */
	0x70,    /* .###.. */
	0x00,    /* ...... */

	/* chr104 */
	0x00,    /* ...... */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x58,    /* .#.##. */
	0x68,    /* .##.#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr105 */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr106 */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x90,    /* #..#.. */
	0x60,    /* .##... */
	0x00,    /* ...... */

	/* chr107 */
	0x00,    /* ...... */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x48,    /* .#..#. */
	0x50,    /* .#.#.. */
	0x60,    /* .##... */
	0x50,    /* .#.#.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr108 */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr109 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x7C,    /* .##### */
	0x54,    /* .#.#.# */
	0x54,    /* .#.#.# */
	0x54,    /* .#.#.# */
	0x54,    /* .#.#.# */
	0x54,    /* .#.#.# */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr110 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x58,    /* .#.##. */
	0x68,    /* .##.#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr111 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr112 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x70,    /* .###.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x70,    /* .###.. */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x00,    /* ...... */

	/* chr113 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x38,    /* ..###. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x38,    /* ..###. */
	0x08,    /* ....#. */
	0x08,    /* ....#. */
	0x00,    /* ...... */

	/* chr114 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x78,    /* .####. */
	0x28,    /* ..#.#. */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr115 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x38,    /* ..###. */
	0x40,    /* .#.... */
	0x60,    /* .##... */
	0x18,    /* ...##. */
	0x08,    /* ....#. */
	0x70,    /* .###.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr116 */
	0x00,    /* ...... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x78,    /* .####. */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x18,    /* ...##. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr117 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr118 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x44,    /* .#...# */
	0x44,    /* .#...# */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr119 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x44,    /* .#...# */
	0x44,    /* .#...# */
	0x54,    /* .#.#.# */
	0x54,    /* .#.#.# */
	0x38,    /* ..###. */
	0x28,    /* ..#.#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr120 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr121 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x28,    /* ..#.#. */
	0x30,    /* ..##.. */
	0x10,    /* ...#.. */
	0x20,    /* ..#... */
	0x60,    /* .##... */
	0x00,    /* ...... */

	/* chr122 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x78,    /* .####. */
	0x08,    /* ....#. */
	0x10,    /* ...#.. */
	0x20,    /* ..#... */
	0x40,    /* .#.... */
	0x78,    /* .####. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr123 */
	0x0C,    /* ....## */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x60,    /* .##... */
	0x60,    /* .##... */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x0C,    /* ....## */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr124 */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr125 */
	0x60,    /* .##... */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x0C,    /* ....## */
	0x0C,    /* ....## */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x60,    /* .##... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr126 */
	0x00,    /* ...... */
	0x24,    /* ..#..# */
	0x54,    /* .#.#.# */
	0x48,    /* .#..#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr127 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x10,    /* ...#.. */
	0x28,    /* ..#.#. */
	0x44,    /* .#...# */
	0x44,    /* .#...# */
	0x44,    /* .#...# */
	0x7C,    /* .##### */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr128 */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x10,    /* ...#.. */
	0x20,    /* ..#... */
	0x00,    /* ...... */

	/* chr129 */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x00,    /* ...... */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr130 */
	0x10,    /* ...#.. */
	0x20,    /* ..#... */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x78,    /* .####. */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr131 */
	0x10,    /* ...#.. */
	0x28,    /* ..#.#. */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x08,    /* ....#. */
	0x38,    /* ..###. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr132 */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x08,    /* ....#. */
	0x38,    /* ..###. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr133 */
	0x20,    /* ..#... */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x08,    /* ....#. */
	0x38,    /* ..###. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr134 */
	0x10,    /* ...#.. */
	0x28,    /* ..#.#. */
	0x10,    /* ...#.. */
	0x30,    /* ..##.. */
	0x08,    /* ....#. */
	0x38,    /* ..###. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr135 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x38,    /* ..###. */
	0x10,    /* ...#.. */
	0x20,    /* ..#... */
	0x00,    /* ...... */

	/* chr136 */
	0x10,    /* ...#.. */
	0x28,    /* ..#.#. */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x78,    /* .####. */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr137 */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x78,    /* .####. */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr138 */
	0x20,    /* ..#... */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x78,    /* .####. */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr139 */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr140 */
	0x10,    /* ...#.. */
	0x28,    /* ..#.#. */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr141 */
	0x20,    /* ..#... */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr142 */
	0x6C,    /* .##.## */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x78,    /* .####. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr143 */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x78,    /* .####. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr144 */
	0x10,    /* ...#.. */
	0x20,    /* ..#... */
	0x78,    /* .####. */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x70,    /* .###.. */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x78,    /* .####. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr145 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x6C,    /* .##.## */
	0x14,    /* ...#.# */
	0x3C,    /* ..#### */
	0x50,    /* .#.#.. */
	0x50,    /* .#.#.. */
	0x6C,    /* .##.## */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr146 */
	0x00,    /* ...... */
	0x3C,    /* ..#### */
	0x30,    /* ..##.. */
	0x50,    /* .#.#.. */
	0x5C,    /* .#.### */
	0x70,    /* .###.. */
	0x50,    /* .#.#.. */
	0x50,    /* .#.#.. */
	0x5C,    /* .#.### */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr147 */
	0x10,    /* ...#.. */
	0x28,    /* ..#.#. */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr148 */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr149 */
	0x20,    /* ..#... */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr150 */
	0x10,    /* ...#.. */
	0x28,    /* ..#.#. */
	0x00,    /* ...... */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr151 */
	0x20,    /* ..#... */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr152 */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x00,    /* ...... */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x28,    /* ..#.#. */
	0x30,    /* ..##.. */
	0x10,    /* ...#.. */
	0x20,    /* ..#... */
	0x60,    /* .##... */
	0x00,    /* ...... */

	/* chr153 */
	0x6C,    /* .##.## */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr154 */
	0x6C,    /* .##.## */
	0x00,    /* ...... */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr155 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x10,    /* ...#.. */
	0x38,    /* ..###. */
	0x50,    /* .#.#.. */
	0x50,    /* .#.#.. */
	0x50,    /* .#.#.. */
	0x50,    /* .#.#.. */
	0x38,    /* ..###. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr156 */
	0x00,    /* ...... */
	0x18,    /* ...##. */
	0x24,    /* ..#..# */
	0x20,    /* ..#... */
	0x70,    /* .###.. */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x44,    /* .#...# */
	0x7C,    /* .##### */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr157 */
	0x00,    /* ...... */
	0x44,    /* .#...# */
	0x44,    /* .#...# */
	0x28,    /* ..#.#. */
	0x7C,    /* .##### */
	0x10,    /* ...#.. */
	0x7C,    /* .##### */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr158 */
	0x00,    /* ...... */
	0x78,    /* .####. */
	0x44,    /* .#...# */
	0x78,    /* .####. */
	0x48,    /* .#..#. */
	0x5C,    /* .#.### */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x4C,    /* .#..## */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr159 */
	0x00,    /* ...... */
	0x18,    /* ...##. */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x78,    /* .####. */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0xC0,    /* ##.... */
	0x00,    /* ...... */

	/* chr160 */
	0x10,    /* ...#.. */
	0x20,    /* ..#... */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x08,    /* ....#. */
	0x38,    /* ..###. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr161 */
	0x10,    /* ...#.. */
	0x20,    /* ..#... */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr162 */
	0x10,    /* ...#.. */
	0x20,    /* ..#... */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr163 */
	0x10,    /* ...#.. */
	0x20,    /* ..#... */
	0x00,    /* ...... */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr164 */
	0x28,    /* ..#.#. */
	0x50,    /* .#.#.. */
	0x00,    /* ...... */
	0x58,    /* .#.##. */
	0x68,    /* .##.#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr165 */
	0x28,    /* ..#.#. */
	0x50,    /* .#.#.. */
	0x48,    /* .#..#. */
	0x68,    /* .##.#. */
	0x68,    /* .##.#. */
	0x58,    /* .#.##. */
	0x58,    /* .#.##. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr166 */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x08,    /* ....#. */
	0x38,    /* ..###. */
	0x78,    /* .####. */
	0x00,    /* ...... */
	0x78,    /* .####. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr167 */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x78,    /* .####. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr168 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x10,    /* ...#.. */
	0x20,    /* ..#... */
	0x40,    /* .#.... */
	0x44,    /* .#...# */
	0x38,    /* ..###. */
	0x00,    /* ...... */

	/* chr169 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x78,    /* .####. */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr170 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x78,    /* .####. */
	0x08,    /* ....#. */
	0x08,    /* ....#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr171 */
	0x00,    /* ...... */
	0x20,    /* ..#... */
	0x60,    /* .##... */
	0x24,    /* ..#..# */
	0x28,    /* ..#.#. */
	0x30,    /* ..##.. */
	0x28,    /* ..#.#. */
	0x54,    /* .#.#.# */
	0x04,    /* .....# */
	0x08,    /* ....#. */
	0x1C,    /* ...### */
	0x00,    /* ...... */

	/* chr172 */
	0x00,    /* ...... */
	0x20,    /* ..#... */
	0x60,    /* .##... */
	0x24,    /* ..#..# */
	0x28,    /* ..#.#. */
	0x30,    /* ..##.. */
	0x28,    /* ..#.#. */
	0x58,    /* .#.##. */
	0x18,    /* ...##. */
	0x3C,    /* ..#### */
	0x08,    /* ....#. */
	0x00,    /* ...... */

	/* chr173 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */

	/* chr174 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x24,    /* ..#..# */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x24,    /* ..#..# */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr175 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x48,    /* .#..#. */
	0x24,    /* ..#..# */
	0x24,    /* ..#..# */
	0x48,    /* .#..#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr176 */
	0x44,    /* .#...# */
	0x88,    /* #...#. */
	0x20,    /* ..#... */
	0x10,    /* ...#.. */
	0x44,    /* .#...# */
	0x88,    /* #...#. */
	0x20,    /* ..#... */
	0x10,    /* ...#.. */
	0x44,    /* .#...# */
	0x88,    /* #...#. */
	0x20,    /* ..#... */
	0x10,    /* ...#.. */

	/* chr177 */
	0x54,    /* .#.#.# */
	0xA8,    /* #.#.#. */
	0x54,    /* .#.#.# */
	0xA8,    /* #.#.#. */
	0x54,    /* .#.#.# */
	0xA8,    /* #.#.#. */
	0x54,    /* .#.#.# */
	0xA8,    /* #.#.#. */
	0x54,    /* .#.#.# */
	0xA8,    /* #.#.#. */
	0x54,    /* .#.#.# */
	0xA8,    /* #.#.#. */

	/* chr178 */
	0x74,    /* .###.# */
	0xB8,    /* #.###. */
	0xEC,    /* ###.## */
	0xDC,    /* ##.### */
	0x74,    /* .###.# */
	0xB8,    /* #.###. */
	0xEC,    /* ###.## */
	0xDC,    /* ##.### */
	0x74,    /* .###.# */
	0xB8,    /* #.###. */
	0xEC,    /* ###.## */
	0xDC,    /* ##.### */

	/* chr179 */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */

	/* chr180 */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0xF0,    /* ####.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */

	/* chr181 */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0xF0,    /* ####.. */
	0x10,    /* ...#.. */
	0xF0,    /* ####.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */

	/* chr182 */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0xE8,    /* ###.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */

	/* chr183 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0xF8,    /* #####. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */

	/* chr184 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0xF0,    /* ####.. */
	0x10,    /* ...#.. */
	0xF0,    /* ####.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */

	/* chr185 */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0xE8,    /* ###.#. */
	0x08,    /* ....#. */
	0xE8,    /* ###.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */

	/* chr186 */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */

	/* chr187 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0xF8,    /* #####. */
	0x08,    /* ....#. */
	0xE8,    /* ###.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */

	/* chr188 */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0xE8,    /* ###.#. */
	0x08,    /* ....#. */
	0xF8,    /* #####. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr189 */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0xF8,    /* #####. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr190 */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0xF0,    /* ####.. */
	0x10,    /* ...#.. */
	0xF0,    /* ####.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr191 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0xF0,    /* ####.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */

	/* chr192 */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x1C,    /* ...### */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr193 */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0xFC,    /* ###### */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr194 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0xFC,    /* ###### */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */

	/* chr195 */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x1C,    /* ...### */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */

	/* chr196 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0xFC,    /* ###### */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr197 */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0xFC,    /* ###### */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */

	/* chr198 */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x1C,    /* ...### */
	0x10,    /* ...#.. */
	0x1C,    /* ...### */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */

	/* chr199 */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x2C,    /* ..#.## */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */

	/* chr200 */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x2C,    /* ..#.## */
	0x20,    /* ..#... */
	0x3C,    /* ..#### */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr201 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x3C,    /* ..#### */
	0x20,    /* ..#... */
	0x2C,    /* ..#.## */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */

	/* chr202 */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0xEC,    /* ###.## */
	0x00,    /* ...... */
	0xFC,    /* ###### */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr203 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0xFC,    /* ###### */
	0x00,    /* ...... */
	0xEC,    /* ###.## */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */

	/* chr204 */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x2C,    /* ..#.## */
	0x20,    /* ..#... */
	0x2C,    /* ..#.## */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */

	/* chr205 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0xFC,    /* ###### */
	0x00,    /* ...... */
	0xFC,    /* ###### */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr206 */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0xEC,    /* ###.## */
	0x00,    /* ...... */
	0xEC,    /* ###.## */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */

	/* chr207 */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0xFC,    /* ###### */
	0x00,    /* ...... */
	0xFC,    /* ###### */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr208 */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0xFC,    /* ###### */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr209 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0xFC,    /* ###### */
	0x00,    /* ...... */
	0xFC,    /* ###### */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */

	/* chr210 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0xFC,    /* ###### */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */

	/* chr211 */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x3C,    /* ..#### */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr212 */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x1C,    /* ...### */
	0x10,    /* ...#.. */
	0x1C,    /* ...### */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr213 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x1C,    /* ...### */
	0x10,    /* ...#.. */
	0x1C,    /* ...### */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */

	/* chr214 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x3C,    /* ..#### */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */

	/* chr215 */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0xEC,    /* ###.## */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */

	/* chr216 */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0xFC,    /* ###### */
	0x00,    /* ...... */
	0xFC,    /* ###### */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */

	/* chr217 */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0xF0,    /* ####.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr218 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x1C,    /* ...### */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */

	/* chr219 */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xFC,    /* ###### */

	/* chr220 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xFC,    /* ###### */

	/* chr221 */
	0xE0,    /* ###... */
	0xE0,    /* ###... */
	0xE0,    /* ###... */
	0xE0,    /* ###... */
	0xE0,    /* ###... */
	0xE0,    /* ###... */
	0xE0,    /* ###... */
	0xE0,    /* ###... */
	0xE0,    /* ###... */
	0xE0,    /* ###... */
	0xE0,    /* ###... */
	0xE0,    /* ###... */

	/* chr222 */
	0x1C,    /* ...### */
	0x1C,    /* ...### */
	0x1C,    /* ...### */
	0x1C,    /* ...### */
	0x1C,    /* ...### */
	0x1C,    /* ...### */
	0x1C,    /* ...### */
	0x1C,    /* ...### */
	0x1C,    /* ...### */
	0x1C,    /* ...### */
	0x1C,    /* ...### */
	0x1C,    /* ...### */

	/* chr223 */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0xFC,    /* ###### */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr224 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x24,    /* ..#..# */
	0x54,    /* .#.#.# */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x34,    /* ..##.# */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr225 */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x50,    /* .#.#.. */
	0x50,    /* .#.#.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x58,    /* .#.##. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr226 */
	0x00,    /* ...... */
	0x3C,    /* ..#### */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr227 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x78,    /* .####. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr228 */
	0x00,    /* ...... */
	0x78,    /* .####. */
	0x40,    /* .#.... */
	0x20,    /* ..#... */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x20,    /* ..#... */
	0x40,    /* .#.... */
	0x78,    /* .####. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr229 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x3C,    /* ..#### */
	0x50,    /* .#.#.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr230 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x58,    /* .#.##. */
	0x68,    /* .##.#. */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x00,    /* ...... */

	/* chr231 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x78,    /* .####. */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x18,    /* ...##. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr232 */
	0x00,    /* ...... */
	0x10,    /* ...#.. */
	0x38,    /* ..###. */
	0x54,    /* .#.#.# */
	0x54,    /* .#.#.# */
	0x54,    /* .#.#.# */
	0x54,    /* .#.#.# */
	0x38,    /* ..###. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr233 */
	0x00,    /* ...... */
	0x38,    /* ..###. */
	0x44,    /* .#...# */
	0x44,    /* .#...# */
	0x7C,    /* .##### */
	0x44,    /* .#...# */
	0x44,    /* .#...# */
	0x44,    /* .#...# */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr234 */
	0x00,    /* ...... */
	0x38,    /* ..###. */
	0x44,    /* .#...# */
	0x44,    /* .#...# */
	0x44,    /* .#...# */
	0x44,    /* .#...# */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x6C,    /* .##.## */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr235 */
	0x00,    /* ...... */
	0x38,    /* ..###. */
	0x40,    /* .#.... */
	0x20,    /* ..#... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr236 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x28,    /* ..#.#. */
	0x54,    /* .#.#.# */
	0x54,    /* .#.#.# */
	0x28,    /* ..#.#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr237 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x08,    /* ....#. */
	0x54,    /* .#.#.# */
	0x54,    /* .#.#.# */
	0x54,    /* .#.#.# */
	0x54,    /* .#.#.# */
	0x38,    /* ..###. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */

	/* chr238 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x38,    /* ..###. */
	0x40,    /* .#.... */
	0x70,    /* .###.. */
	0x40,    /* .#.... */
	0x40,    /* .#.... */
	0x38,    /* ..###. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr239 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x38,    /* ..###. */
	0x44,    /* .#...# */
	0x44,    /* .#...# */
	0x44,    /* .#...# */
	0x44,    /* .#...# */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr240 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x7C,    /* .##### */
	0x00,    /* ...... */
	0x7C,    /* .##### */
	0x00,    /* ...... */
	0x7C,    /* .##### */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr241 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x7C,    /* .##### */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x7C,    /* .##### */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr242 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x40,    /* .#.... */
	0x30,    /* ..##.. */
	0x08,    /* ....#. */
	0x30,    /* ..##.. */
	0x40,    /* .#.... */
	0x00,    /* ...... */
	0x78,    /* .####. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr243 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x08,    /* ....#. */
	0x30,    /* ..##.. */
	0x40,    /* .#.... */
	0x30,    /* ..##.. */
	0x08,    /* ....#. */
	0x00,    /* ...... */
	0x78,    /* .####. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr244 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x0C,    /* ....## */
	0x14,    /* ...#.# */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */

	/* chr245 */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x50,    /* .#.#.. */
	0x60,    /* .##... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr246 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x7C,    /* .##### */
	0x00,    /* ...... */
	0x10,    /* ...#.. */
	0x10,    /* ...#.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr247 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x24,    /* ..#..# */
	0x54,    /* .#.#.# */
	0x48,    /* .#..#. */
	0x00,    /* ...... */
	0x24,    /* ..#..# */
	0x54,    /* .#.#.# */
	0x48,    /* .#..#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr248 */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x48,    /* .#..#. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr249 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x78,    /* .####. */
	0x78,    /* .####. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr250 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x30,    /* ..##.. */
	0x30,    /* ..##.. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr251 */
	0x04,    /* .....# */
	0x04,    /* .....# */
	0x04,    /* .....# */
	0x08,    /* ....#. */
	0x68,    /* .##.#. */
	0x28,    /* ..#.#. */
	0x30,    /* ..##.. */
	0x30,    /* ..##.. */
	0x20,    /* ..#... */
	0x20,    /* ..#... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr252 */
	0x00,    /* ...... */
	0x38,    /* ..###. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x28,    /* ..#.#. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr253 */
	0x30,    /* ..##.. */
	0x48,    /* .#..#. */
	0x10,    /* ...#.. */
	0x20,    /* ..#... */
	0x78,    /* .####. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr254 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x78,    /* .####. */
	0x78,    /* .####. */
	0x78,    /* .####. */
	0x78,    /* .####. */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

	/* chr255 */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x44,    /* .#...# */
	0x44,    /* .#...# */
	0x7C,    /* .##### */
	0x00,    /* ...... */
	0x00,    /* ...... */
	0x00,    /* ...... */

};
