/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import org.graalvm.visualvm.core.datasupport.ComparableWeakReference;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class VisualVM {
    private static final VisualVM INSTANCE = new VisualVM();
    private final int TASK_PROCESSOR_THROUGHPUT_DEFAULT = 30;
    private final int TASK_PROCESSOR_THROUGHPUT = Integer.getInteger("org.graalvm.visualvm.core.taskProcessorThroughput", 30);
    private final RequestProcessor taskProcessor = new RequestProcessor("VisualVM Shared RequestProcessor", this.TASK_PROCESSOR_THROUGHPUT);
    private Collection<ComparableWeakReference<Runnable>> closingHandlers;

    private VisualVM() {
    }

    public static VisualVM getInstance() {
        return INSTANCE;
    }

    public final void runTask(Runnable task) {
        this.taskProcessor.post(task);
    }

    public final void runTask(Runnable task, int timeToWait) {
        this.taskProcessor.post(task, timeToWait);
    }

    public final synchronized void notifyWhenClosing(Runnable handler) {
        if (this.closingHandlers == null) {
            this.closingHandlers = new ArrayList<ComparableWeakReference<Runnable>>();
        }
        this.closingHandlers.add(new ComparableWeakReference<Runnable>(handler));
    }

    synchronized boolean closing() {
        if (this.closingHandlers != null) {
            for (WeakReference weakReference : this.closingHandlers) {
                Runnable handler = (Runnable)weakReference.get();
                if (handler == null) continue;
                try {
                    handler.run();
                }
                catch (Exception e) {
                    System.err.println("Exception handling VisualVM.closing(): " + e);
                }
            }
        }
        return true;
    }

    public final String getOptionsHandle() {
        return Utilities.isMac() ? NbBundle.getMessage(VisualVM.class, (String)"OptionsHandleMac") : NbBundle.getMessage(VisualVM.class, (String)"OptionsHandle");
    }

    public final String getLogfileHandle() {
        return Utilities.isMac() ? NbBundle.getMessage(VisualVM.class, (String)"LogfileHandleMac") : NbBundle.getMessage(VisualVM.class, (String)"LogfileHandle");
    }
}

