/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr;

import java.io.File;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.jvm.JvmFactory;
import org.graalvm.visualvm.core.datasource.Storage;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.datasupport.Utils;
import org.graalvm.visualvm.core.model.ModelProvider;
import org.graalvm.visualvm.core.snapshot.RegisteredSnapshotCategories;
import org.graalvm.visualvm.core.snapshot.SnapshotCategory;
import org.graalvm.visualvm.core.ui.DataSourceViewProvider;
import org.graalvm.visualvm.core.ui.DataSourceViewsManager;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.JFRSnapshotsContainer;
import org.graalvm.visualvm.jfr.impl.JFRRecordingProvider;
import org.graalvm.visualvm.jfr.impl.JFRSnapshotCategory;
import org.graalvm.visualvm.jfr.impl.JFRSnapshotDescriptorProvider;
import org.graalvm.visualvm.jfr.impl.JFRSnapshotProvider;
import org.graalvm.visualvm.jfr.view.JFRViewProvider;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.tools.jfr.JfrModel;
import org.graalvm.visualvm.tools.jfr.JfrModelFactory;
import org.openide.util.NbBundle;

public final class JFRSnapshotSupport {
    private static final String JFRSNAPSHOTS_STORAGE_DIRNAME = "jfrsnapshots";
    private static final Object jfrSnapshotsStorageDirectoryLock = new Object();
    private static File jfrSnapshotsStorageDirectory;
    private static final Object jfrSnapshotsStorageDirectoryStringLock;
    private static String jfrSnapshotsStorageDirectoryString;
    private static final JFRSnapshotCategory category;
    private static JFRRecordingProvider jfrDumpProvider;

    public static SnapshotCategory<JFRSnapshot> getCategory() {
        return category;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getStorageDirectoryString() {
        Object object = jfrSnapshotsStorageDirectoryStringLock;
        synchronized (object) {
            if (jfrSnapshotsStorageDirectoryString == null) {
                jfrSnapshotsStorageDirectoryString = Storage.getPersistentStorageDirectoryString() + File.separator + JFRSNAPSHOTS_STORAGE_DIRNAME;
            }
            return jfrSnapshotsStorageDirectoryString;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getStorageDirectory() {
        Object object = jfrSnapshotsStorageDirectoryLock;
        synchronized (object) {
            if (jfrSnapshotsStorageDirectory == null) {
                String snapshotsStorageString = JFRSnapshotSupport.getStorageDirectoryString();
                jfrSnapshotsStorageDirectory = new File(snapshotsStorageString);
                if (jfrSnapshotsStorageDirectory.exists() && jfrSnapshotsStorageDirectory.isFile()) {
                    throw new IllegalStateException("Cannot create JFR snapshots storage directory " + snapshotsStorageString + ", file in the way");
                }
                if (!(!jfrSnapshotsStorageDirectory.exists() || jfrSnapshotsStorageDirectory.canRead() && jfrSnapshotsStorageDirectory.canWrite())) {
                    throw new IllegalStateException("Cannot access JFR snapshots storage directory " + snapshotsStorageString + ", read&write permission required");
                }
                if (!Utils.prepareDirectory((File)jfrSnapshotsStorageDirectory)) {
                    throw new IllegalStateException("Cannot create JFR snapshots storage directory " + snapshotsStorageString);
                }
            }
            return jfrSnapshotsStorageDirectory;
        }
    }

    public static boolean storageDirectoryExists() {
        return new File(JFRSnapshotSupport.getStorageDirectoryString()).isDirectory();
    }

    static void register() {
        DataSourceDescriptorFactory.getDefault().registerProvider((ModelProvider)new JFRSnapshotDescriptorProvider());
        JFRSnapshotsContainer.sharedInstance();
        JFRSnapshotProvider.register();
        RegisteredSnapshotCategories.sharedInstance().registerCategory((SnapshotCategory)category);
        DataSourceViewsManager views = DataSourceViewsManager.sharedInstance();
        views.addViewProvider((DataSourceViewProvider)new JFRViewProvider(), JFRSnapshot.class);
        jfrDumpProvider = new JFRRecordingProvider();
        jfrDumpProvider.initialize();
    }

    public static void takeJfrDump(Application application, boolean stopJfr, boolean openView) {
        jfrDumpProvider.createJfrDump(application, stopJfr, openView);
    }

    public static void takeRemoteJfrDump(Application application, String dumpFile, boolean customizeDumpFile) {
        jfrDumpProvider.createRemoteJfrDump(application, dumpFile, customizeDumpFile);
    }

    public static boolean supportsJfrDump(Application application) {
        if (application.getState() != 1) {
            return false;
        }
        Jvm jvm = JvmFactory.getJVMFor((Application)application);
        if (!jvm.isJfrAvailable()) {
            return false;
        }
        return !jvm.jfrCheck().isEmpty();
    }

    public static boolean supportsRemoteJfrDump(Application application) {
        if (application.getState() != 1) {
            return false;
        }
        if (application.isLocalApplication()) {
            return false;
        }
        JfrModel jfrModel = JfrModelFactory.getJFRFor((Application)application);
        if (jfrModel == null) {
            return false;
        }
        return !jfrModel.jfrCheck().isEmpty();
    }

    public static void jfrStartRecording(Application application) {
        JFRSnapshotSupport.jfrStartRecording(application, null);
    }

    public static void jfrStartRecording(Application application, String params) {
        JFRSnapshotSupport.checkNotifyCommercialFeatures(application);
        jfrDumpProvider.jfrStartRecording(application, params);
    }

    public static void remoteJfrStartRecording(Application application) {
        JFRSnapshotSupport.checkNotifyCommercialFeatures(application);
        jfrDumpProvider.remoteJfrStartRecording(application);
    }

    public static boolean supportsJfrStart(Application application) {
        if (application.getState() != 1) {
            return false;
        }
        Jvm jvm = JvmFactory.getJVMFor((Application)application);
        if (!jvm.isJfrAvailable()) {
            return false;
        }
        return jvm.jfrCheck().isEmpty();
    }

    public static boolean supportsRemoteJfrStart(Application application) {
        if (application.getState() != 1) {
            return false;
        }
        if (application.isLocalApplication()) {
            return false;
        }
        JfrModel jfrModel = JfrModelFactory.getJFRFor((Application)application);
        if (jfrModel == null) {
            return false;
        }
        return jfrModel.jfrCheck().isEmpty();
    }

    public static void jfrStopRecording(Application application) {
        jfrDumpProvider.jfrStopRecording(application);
    }

    public static void remoteJfrStopRecording(Application application) {
        jfrDumpProvider.remoteJfrStopRecording(application);
    }

    public static boolean supportsJfrStop(Application application) {
        if (application.getState() != 1) {
            return false;
        }
        Jvm jvm = JvmFactory.getJVMFor((Application)application);
        if (!jvm.isJfrAvailable()) {
            return false;
        }
        return !jvm.jfrCheck().isEmpty();
    }

    public static boolean supportsRemoteJfrStop(Application application) {
        if (application.getState() != 1) {
            return false;
        }
        if (application.isLocalApplication()) {
            return false;
        }
        JfrModel jfrModel = JfrModelFactory.getJFRFor((Application)application);
        if (jfrModel == null) {
            return false;
        }
        return !jfrModel.jfrCheck().isEmpty();
    }

    public static void checkNotifyCommercialFeatures(Application application) {
        if (JFRSnapshotSupport.requiresUnlockCommercialFeatures(application)) {
            JFRSnapshotSupport.displayUnlockCommercialFeaturesNotification(application);
        }
    }

    public static boolean requiresUnlockCommercialFeatures(Application application) {
        if (application.getState() != 1) {
            return false;
        }
        Jvm jvm = JvmFactory.getJVMFor((Application)application);
        if (!(jvm.is18() || jvm.is19() || jvm.is100())) {
            return false;
        }
        String vmVendor = jvm.getVmVendor();
        return vmVendor != null && vmVendor.contains("Oracle");
    }

    private static void displayUnlockCommercialFeaturesNotification(Application application) {
        ProfilerDialogs.displayWarningDNSA((String)NbBundle.getMessage(JFRSnapshotSupport.class, (String)"Msg_CommercialFeatures"), (String)NbBundle.getMessage(JFRSnapshotSupport.class, (String)"Caption_CommercialFeatures"), null, (String)"JFRSnapshotSupport_NotifyCommercialFeatures", (boolean)true);
    }

    static {
        jfrSnapshotsStorageDirectoryStringLock = new Object();
        category = new JFRSnapshotCategory();
    }
}

