/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.TableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.openide.awt.HtmlRenderer;
import org.openide.explorer.propertysheet.BaseTable;
import org.openide.explorer.propertysheet.ButtonPanel;
import org.openide.explorer.propertysheet.CleanComboUI;
import org.openide.explorer.propertysheet.ComboBoxAutoCompleteSupport;
import org.openide.explorer.propertysheet.CustomEditorAction;
import org.openide.explorer.propertysheet.IncrementPropertyValueSupport;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertySetModel;
import org.openide.explorer.propertysheet.PropertySetModelEvent;
import org.openide.explorer.propertysheet.PropertySetModelImpl;
import org.openide.explorer.propertysheet.PropertySetModelListener;
import org.openide.explorer.propertysheet.ProxyNode;
import org.openide.explorer.propertysheet.ReusablePropertyEnv;
import org.openide.explorer.propertysheet.ReusablePropertyModel;
import org.openide.explorer.propertysheet.SheetCellEditor;
import org.openide.explorer.propertysheet.SheetCellRenderer;
import org.openide.explorer.propertysheet.SheetColumnModel;
import org.openide.explorer.propertysheet.SheetTableModel;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

final class SheetTable
extends BaseTable
implements PropertySetModelListener,
CustomEditorAction.Invoker {
    private static final String ACTION_EXPAND = "expandSet";
    private static final String ACTION_COLLAPSE = "collapseSet";
    private static final String ACTION_CUSTOM_EDITOR = "invokeCustomEditor";
    private static final String ACTION_EDCLASS = "edclass";
    private static int instanceCount = 0;
    private transient boolean initialized = false;
    private FeatureDescriptor storedFd = null;
    private boolean wasEditing = false;
    private Object partialValue = null;
    private int lastSelectedRow = -1;
    private SheetCellRenderer renderer = null;
    private SheetCellEditor sheetCellEditor = null;
    private Action customEditorAction = null;
    private Action expandAction;
    private Action collapseAction;
    private Action edClassAction;
    private String beanName;
    private boolean customEditorIsOpen = false;
    private ReusablePropertyEnv reusableEnv = new ReusablePropertyEnv();
    private ReusablePropertyModel reusableModel = new ReusablePropertyModel(this.reusableEnv);
    boolean lastIncludeMargin = false;
    private HtmlRenderer.Renderer htmlrenderer = null;
    int countDown = -1;
    boolean lastFailed = false;

    public SheetTable() {
        super(new SheetTableModel(), new SheetColumnModel(), new DefaultListSelectionModel());
        Serializable serializable;
        this.setPropertySetModel(new PropertySetModelImpl());
        this.setRowHeight(16);
        this.setShowGrid(PropUtils.noAltBg());
        this.setShowVerticalLines(PropUtils.noAltBg());
        this.setShowHorizontalLines(PropUtils.noAltBg());
        this.setAutoResizeMode(1);
        if (!PropUtils.noAltBg()) {
            this.setIntercellSpacing(new Dimension(0, 0));
        } else {
            serializable = UIManager.getDimension("PropSheet.intercellSpacing");
            if (serializable != null) {
                this.setIntercellSpacing((Dimension)serializable);
            }
        }
        this.setGridColor(PropUtils.getSetRendererColor());
        serializable = UIManager.getColor("PropSheet.selectionBackground");
        if (serializable != null) {
            this.setSelectionBackground((Color)serializable);
        }
        if ((serializable = UIManager.getColor("PropSheet.selectionForeground")) != null) {
            this.setSelectionForeground((Color)serializable);
        }
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SheetTable.class, (String)"ACSN_SHEET_TABLE"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SheetTable.class, (String)"ACSD_SHEET_TABLE"));
        this.setTransferHandler(new SheetTableTransferHandler());
        Color color = UIManager.getColor("netbeans.ps.background");
        if (color != null) {
            this.setBackground(color);
        }
        this.setFocusTraversalPolicy(new STPolicy());
        ++instanceCount;
    }

    protected void finalize() {
        if (--instanceCount == 0) {
            this.renderer = null;
            this.sheetCellEditor = null;
            SheetTable.cleanup();
        }
    }

    SheetCellRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = new SheetCellRenderer(true, this.reusableEnv, this.reusableModel);
        }
        return this.renderer;
    }

    SheetCellEditor getEditor() {
        if (this.sheetCellEditor == null) {
            this.sheetCellEditor = new SheetCellEditor(this.getReusablePropertyEnv());
        }
        return this.sheetCellEditor;
    }

    private TableCellRenderer getCustomRenderer(int n) {
        FeatureDescriptor featureDescriptor = this.getPropertySetModel().getFeatureDescriptor(n);
        if (featureDescriptor instanceof Node.PropertySet) {
            return null;
        }
        Object object = featureDescriptor.getValue("custom.cell.renderer");
        if (object instanceof TableCellRenderer) {
            this.prepareCustomEditor(object);
            return (TableCellRenderer)object;
        }
        return null;
    }

    private TableCellEditor getCustomEditor(int n) {
        FeatureDescriptor featureDescriptor = this.getPropertySetModel().getFeatureDescriptor(n);
        if (featureDescriptor instanceof Node.PropertySet) {
            return null;
        }
        Object object = featureDescriptor.getValue("custom.cell.editor");
        if (object instanceof TableCellEditor) {
            this.prepareCustomEditor(object);
            return (TableCellEditor)object;
        }
        return null;
    }

    private void prepareCustomEditor(Object object) {
        JComboBox jComboBox = null;
        if (object instanceof DefaultCellEditor) {
            if (((DefaultCellEditor)object).getComponent() instanceof JComboBox) {
                jComboBox = (JComboBox)((DefaultCellEditor)object).getComponent();
            }
        } else if (object instanceof JComboBox) {
            jComboBox = (JComboBox)object;
        }
        if (null != jComboBox && !(jComboBox.getUI() instanceof CleanComboUI)) {
            jComboBox.setUI(new CleanComboUI(true));
            ComboBoxAutoCompleteSupport.install(jComboBox);
        }
    }

    void setBeanName(String string) {
        this.beanName = string;
    }

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        TableCellEditor tableCellEditor;
        if (0 == n2 && null != (tableCellEditor = this.getCustomEditor(n))) {
            return tableCellEditor;
        }
        return this.getEditor();
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer;
        if (0 == n2 && null != (tableCellRenderer = this.getCustomRenderer(n))) {
            return tableCellRenderer;
        }
        return this.getRenderer();
    }

    @Override
    public void setModel(TableModel tableModel) {
        if (this.initialized) {
            throw new UnsupportedOperationException("Changing the model of a property sheet table is not supported.  If you want to change the set of properties, ordering or other characteristings, see setPropertySetModel().");
        }
        super.setModel(tableModel);
    }

    @Override
    public void setColumnModel(TableColumnModel tableColumnModel) {
        if (this.initialized) {
            throw new UnsupportedOperationException("Changing the column model of a property sheet table is not supported.  If you want to change the set of properties, ordering or other characteristings, see setPropertySetModel().");
        }
        super.setColumnModel(tableColumnModel);
    }

    @Override
    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (this.initialized) {
            throw new UnsupportedOperationException("Changing the selection model of a property sheet table is not supported.  If you want to change the set of properties, ordering or other characteristings, see setPropertySetModel().");
        }
        super.setSelectionModel(listSelectionModel);
    }

    public void setPropertySetModel(PropertySetModel propertySetModel) {
        PropertySetModel propertySetModel2 = this.getSheetModel().getPropertySetModel();
        if (propertySetModel2 == propertySetModel) {
            return;
        }
        if (propertySetModel2 != null) {
            propertySetModel2.removePropertySetModelListener(this);
        }
        this.getSheetModel().setPropertySetModel(propertySetModel);
        propertySetModel.addPropertySetModelListener(this);
    }

    PropertySetModel getPropertySetModel() {
        return this.getSheetModel().getPropertySetModel();
    }

    SheetTableModel getSheetModel() {
        return (SheetTableModel)this.getModel();
    }

    @Override
    public JTableHeader getTableHeader() {
        return null;
    }

    @Override
    protected void initKeysAndActions() {
        super.initKeysAndActions();
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(39, 0));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(37, 0));
        this.expandAction = new ExpandAction();
        this.collapseAction = new CollapseAction();
        this.edClassAction = new EditorClassAction();
        InputMap inputMap = this.getInputMap();
        InputMap inputMap2 = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(67, 2);
        inputMap.put(keyStroke, null);
        inputMap.put(KeyStroke.getKeyStroke(37, 0), ACTION_EXPAND);
        inputMap.put(KeyStroke.getKeyStroke(39, 0), ACTION_COLLAPSE);
        if (!GraphicsEnvironment.isHeadless()) {
            inputMap.put(KeyStroke.getKeyStroke(36, 0x40 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), ACTION_EDCLASS);
        }
        inputMap.put(KeyStroke.getKeyStroke(9, 0), "next");
        inputMap.put(KeyStroke.getKeyStroke(9, 64), "prev");
        inputMap2.put(KeyStroke.getKeyStroke(32, 128), ACTION_CUSTOM_EDITOR);
        inputMap2.remove(KeyStroke.getKeyStroke(39, 0));
        inputMap2.remove(KeyStroke.getKeyStroke(37, 0));
        actionMap.put(ACTION_EXPAND, this.expandAction);
        actionMap.put(ACTION_COLLAPSE, this.collapseAction);
        actionMap.put(ACTION_CUSTOM_EDITOR, this.getCustomEditorAction());
        actionMap.put(ACTION_EDCLASS, this.edClassAction);
        Action action = actionMap.get("selectNextRow");
        if (null != action) {
            actionMap.put("selectNextRow", new IncrementAction(false, action));
        }
        if (null != (action = actionMap.get("selectPreviousRow"))) {
            actionMap.put("selectPreviousRow", new IncrementAction(true, action));
        }
    }

    Action getCustomEditorAction() {
        if (this.customEditorAction == null) {
            this.customEditorAction = new CustomEditorAction(this);
        }
        return this.customEditorAction;
    }

    @Override
    protected boolean matchText(Object object, String string) {
        if (object instanceof FeatureDescriptor) {
            return ((FeatureDescriptor)object).getDisplayName().toUpperCase().startsWith(string.toUpperCase());
        }
        return false;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        boolean bl = PropUtils.shouldDrawMargin(this.getPropertySetModel());
        this.getRenderer().setIncludeMargin(bl);
        super.paintComponent(graphics);
        if (!PropUtils.noAltBg()) {
            this.paintCenterLine(graphics);
        }
        if (bl) {
            this.paintMargin(graphics);
        }
        this.paintExpandableSets(graphics);
        this.lastIncludeMargin = bl;
    }

    private void paintComponent(Graphics graphics, Component component, int n, int n2, int n3, int n4) {
        component.setBounds(n, n2, n3, n4);
        graphics.translate(n, n2);
        component.paint(graphics);
        graphics.translate(-n, -n2);
        component.setBounds(-n3, -n4, 0, 0);
    }

    private void paintCenterLine(Graphics graphics) {
        Color color = PropUtils.getAltBg();
        graphics.setColor(color);
        int n = this.getColumn(SheetColumnModel.NAMES_IDENTIFIER).getWidth() - 1;
        graphics.drawLine(n, 0, n, this.getHeight());
    }

    void repaintProperty(String string) {
        if (!this.isShowing()) {
            return;
        }
        if (PropUtils.isLoggable(SheetTable.class)) {
            PropUtils.log(SheetTable.class, "RepaintProperty: " + string);
        }
        PropertySetModel propertySetModel = this.getPropertySetModel();
        int n = this.getFirstVisibleRow();
        if (n == -1) {
            return;
        }
        int n2 = n + this.getVisibleRowCount();
        for (int i = n; i < n2; ++i) {
            FeatureDescriptor featureDescriptor = propertySetModel.getFeatureDescriptor(i);
            if (null == featureDescriptor || !featureDescriptor.getName().equals(string)) continue;
            this.paintRow(i);
            return;
        }
        if (PropUtils.isLoggable(SheetTable.class)) {
            PropUtils.log(SheetTable.class, "Property is either scrolled offscreen or property name is bogus: " + string);
        }
    }

    private void paintMargin(Graphics graphics) {
        graphics.setColor(PropUtils.getSetRendererColor());
        int n = PropUtils.getMarginWidth();
        int n2 = this.getHeight();
        if (graphics.hitClip(0, 0, n, n2)) {
            graphics.fillRect(0, 0, n, n2);
        }
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        if (n < 0 || n >= this.getRowCount()) {
            return component;
        }
        Object object = this.getValueAt(n, n2);
        if (component != null && object instanceof Node.Property && n2 == 1) {
            component.setEnabled(((Node.Property)object).canWrite());
        }
        return component;
    }

    private void paintExpandableSets(Graphics graphics) {
        int n = 0;
        int n2 = this.getRowCount();
        Insets insets = this.getInsets();
        boolean bl = this.isKnownComponent(KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner());
        for (int i = 0; i < n2; ++i) {
            boolean bl2;
            boolean bl3;
            int n3 = n + i;
            Object object = this.getValueAt(n3, 0);
            if (!(object instanceof Node.PropertySet)) continue;
            Rectangle rectangle = this.getCellRect(n3, 0, false);
            rectangle.x = insets.left;
            rectangle.width = this.getWidth() - (insets.left + insets.right);
            if (!graphics.hitClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) continue;
            Node.PropertySet propertySet = (Node.PropertySet)object;
            String string = propertySet.getHtmlDisplayName();
            boolean bl4 = bl3 = string != null;
            if (!bl3) {
                string = propertySet.getDisplayName();
            }
            if (this.htmlrenderer == null) {
                this.htmlrenderer = HtmlRenderer.createRenderer();
            }
            JComponent jComponent = (JComponent)this.htmlrenderer.getTableCellRendererComponent((JTable)this, (Object)string, false, false, n3, 0);
            this.htmlrenderer.setHtml(bl3);
            this.htmlrenderer.setParentFocused(true);
            this.htmlrenderer.setIconTextGap(2);
            this.htmlrenderer.setIcon(this.getPropertySetModel().isExpanded((FeatureDescriptor)propertySet) ? PropUtils.getExpandedIcon() : PropUtils.getCollapsedIcon());
            boolean bl5 = bl2 = bl && this.getSelectedRow() == n3;
            if (!bl2) {
                jComponent.setBackground(PropUtils.getSetRendererColor());
                jComponent.setForeground(PropUtils.getSetForegroundColor());
            } else {
                jComponent.setBackground(PropUtils.getSelectedSetRendererColor());
                jComponent.setForeground(PropUtils.getSelectedSetForegroundColor());
            }
            if (PropUtils.isAqua) {
                jComponent.setOpaque(false);
                Graphics2D graphics2D = (Graphics2D)graphics;
                Paint paint = graphics2D.getPaint();
                graphics2D.setPaint(new GradientPaint(rectangle.x, rectangle.y, Color.white, rectangle.x, rectangle.y + rectangle.height / 2, jComponent.getBackground()));
                graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics2D.setPaint(paint);
            } else {
                jComponent.setOpaque(true);
            }
            this.paintComponent(graphics, jComponent, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        super.editingStopped(changeEvent);
        if (!PropUtils.psCommitOnFocusLoss && !this.getEditor().isLastUpdateSuccessful()) {
            this.countDown = 2;
        }
    }

    private void autoEdit() {
        this.editCellAt(this.getSelectedRow(), this.getSelectedColumn(), null);
        if (this.editorComp != null) {
            this.editorComp.requestFocus();
        }
        this.countDown = -1;
    }

    @Override
    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        this.countDown = -1;
        super.changeSelection(n, n2, bl, bl2);
    }

    @Override
    public void processFocusEvent(FocusEvent focusEvent) {
        block6: {
            block5: {
                super.processFocusEvent(focusEvent);
                if (focusEvent.getID() == 1004) {
                    --this.countDown;
                    if (this.countDown == 0) {
                        this.autoEdit();
                    }
                }
                if (focusEvent.getID() == 1004) break block5;
                if (focusEvent.getOppositeComponent() == null) break block6;
                if (focusEvent.getID() != 1005 || this.isAncestorOf(focusEvent.getOppositeComponent())) break block6;
            }
            this.fireChange();
        }
    }

    @Override
    protected void focusLostCancel() {
        if (PropUtils.psCommitOnFocusLoss && this.isEditing()) {
            this.getEditor().stopCellEditing();
        } else {
            super.focusLostCancel();
        }
    }

    @Override
    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            int n;
            int n2;
            if (mouseEvent.getClickCount() > 1) {
                Object object;
                FeatureDescriptor featureDescriptor;
                n2 = this.rowAtPoint(mouseEvent.getPoint());
                n = this.columnAtPoint(mouseEvent.getPoint());
                if (n == 0 && null != (featureDescriptor = this.getPropertySetModel().getFeatureDescriptor(n2)) && (object = featureDescriptor.getValue("nb.propertysheet.mouse.doubleclick.listener")) instanceof MouseListener) {
                    ((MouseListener)object).mouseClicked(mouseEvent);
                    return;
                }
            }
            if (this.onCustomEditorButton(mouseEvent) && !this.hasFocus()) {
                if (PropUtils.psCommitOnFocusLoss && this.isEditing()) {
                    this.getEditor().stopCellEditing();
                    if (this.isGoingToBeClosed()) {
                        return;
                    }
                }
                n2 = this.rowAtPoint(mouseEvent.getPoint());
                n = this.columnAtPoint(mouseEvent.getPoint());
                if (n2 != -1 && n != -1) {
                    this.changeSelection(n2, n, false, false);
                    this.getCustomEditorAction().actionPerformed(new ActionEvent(this, 1001, ACTION_CUSTOM_EDITOR));
                    mouseEvent.consume();
                    return;
                }
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }

    @Override
    protected boolean isKnownComponent(Component component) {
        Container container;
        boolean bl = super.isKnownComponent(component);
        if (bl) {
            return bl;
        }
        if (component == null) {
            return false;
        }
        if (component instanceof ButtonPanel) {
            return true;
        }
        InplaceEditor inplaceEditor = this.getEditor().getInplaceEditor();
        if (inplaceEditor != null) {
            container = inplaceEditor.getComponent();
            if (container == component) {
                return true;
            }
            if (container.isAncestorOf(component)) {
                return true;
            }
        }
        if (component.getParent() instanceof ButtonPanel) {
            return true;
        }
        if (this.getParent() != null && this.getParent().isAncestorOf(component)) {
            return true;
        }
        container = this.getParent();
        if (container != null && container.isAncestorOf(component)) {
            return true;
        }
        if (component instanceof InplaceEditor) {
            return true;
        }
        InplaceEditor inplaceEditor2 = this.getEditor().getInplaceEditor();
        if (inplaceEditor2 != null) {
            return inplaceEditor2.isKnownComponent(component);
        }
        return false;
    }

    private boolean onCustomEditorButton(MouseEvent mouseEvent) {
        PropertyEditor propertyEditor;
        boolean bl;
        Point point = mouseEvent.getPoint();
        int n = this.rowAtPoint(point);
        int n2 = this.columnAtPoint(point);
        FeatureDescriptor featureDescriptor = this.getSheetModel().getPropertySetModel().getFeatureDescriptor(n);
        if (null == featureDescriptor) {
            return false;
        }
        if (PropUtils.noCustomButtons) {
            bl = false;
        } else {
            boolean bl2 = bl = mouseEvent.getX() > this.getWidth() - PropUtils.getCustomButtonWidth();
        }
        if ((mouseEvent.getID() == 501 || mouseEvent.getID() == 502 || mouseEvent.getID() == 500) && !(bl |= Boolean.FALSE.equals(featureDescriptor.getValue("canEditAsText"))) && featureDescriptor instanceof Node.Property && (propertyEditor = PropUtils.getPropertyEditor((Node.Property)featureDescriptor)) != null && propertyEditor.supportsCustomEditor()) {
            bl |= propertyEditor.isPaintable() && propertyEditor.getAsText() == null && propertyEditor.getTags() == null;
        }
        try {
            if (bl && featureDescriptor instanceof Node.Property && n2 == 1) {
                boolean bl3 = PropUtils.getPropertyEditor((Node.Property)featureDescriptor).supportsCustomEditor();
                return bl3;
            }
        }
        catch (IllegalStateException illegalStateException) {
            Logger.getLogger(SheetTable.class.getName()).log(Level.WARNING, null, illegalStateException);
        }
        return false;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        String string;
        if (this.customEditorIsOpen) {
            return null;
        }
        Point point = mouseEvent.getPoint();
        int n = this.rowAtPoint(point);
        int n2 = this.columnAtPoint(point);
        if (n2 == 1 && this.onCustomEditorButton(mouseEvent)) {
            string = NbBundle.getMessage(SheetTable.class, (String)"CTL_EDBUTTON_TIP");
        } else {
            string = this.getSheetModel().getDescriptionFor(n, n2);
            if (n2 == 1 && string != null && string.length() > 100) {
                string = PropUtils.createHtmlTooltip(this.getPropertySetModel().getFeatureDescriptor(n).getDisplayName(), string);
            }
        }
        if (string != null && "".equals(string.trim())) {
            string = null;
        }
        return string;
    }

    @Override
    public final FeatureDescriptor getSelection() {
        return this._getSelection();
    }

    public final FeatureDescriptor _getSelection() {
        int n = this.getSelectedRow();
        FeatureDescriptor featureDescriptor = n < this.getPropertySetModel().getCount() ? this.getSheetModel().getPropertySetModel().getFeatureDescriptor(this.getSelectedRow()) : null;
        return featureDescriptor;
    }

    public void select(FeatureDescriptor featureDescriptor, boolean bl) {
        PropertySetModel propertySetModel = this.getPropertySetModel();
        int n = propertySetModel.indexOf(featureDescriptor);
        if (n < 0) {
            return;
        }
        this.getSelectionModel().setSelectionInterval(n, n);
        if (bl && propertySetModel.isProperty(n)) {
            this.editCellAt(n, 1, new MouseEvent(this, 0, System.currentTimeMillis(), 0, 0, 0, 1, false));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InplaceEditor inplaceEditor;
                    SheetCellEditor sheetCellEditor = SheetTable.this.getEditor();
                    if (null != sheetCellEditor && null != (inplaceEditor = sheetCellEditor.getInplaceEditor()) && null != inplaceEditor.getComponent()) {
                        inplaceEditor.getComponent().requestFocus();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        boolean bl;
        assert (SwingUtilities.isEventDispatchThread());
        this.enterEditRequest();
        if (this.editingRow == n && this.isEditing()) {
            if (0 == n2) {
                this.getEditor().stopCellEditing();
                this.removeEditor();
            }
            this.exitEditRequest();
            return false;
        }
        if (PropUtils.psCommitOnFocusLoss && this.isEditing()) {
            this.getEditor().stopCellEditing();
            if (this.isGoingToBeClosed()) {
                return false;
            }
        }
        if (eventObject instanceof MouseEvent && this.onCenterLine((MouseEvent)eventObject)) {
            this.exitEditRequest();
            return false;
        }
        if (eventObject instanceof MouseEvent && this.onCustomEditorButton((MouseEvent)eventObject)) {
            if (PropUtils.isLoggable(SheetTable.class)) {
                PropUtils.log(SheetTable.class, "Got a mouse click on the custom editor button");
            }
            if (this.isEditing() && this.editingRow != n) {
                this.removeEditor();
            }
            int n3 = this.getSelectedRow();
            this.changeSelection(n, n2, false, false);
            if (n3 != -1) {
                this.paintRow(n3);
            }
            this.paintSelectionRow();
            this.getCustomEditorAction().actionPerformed(new ActionEvent(this, 0, null));
            this.exitEditRequest();
            return false;
        }
        FeatureDescriptor featureDescriptor = this.getPropertySetModel().getFeatureDescriptor(n);
        if (featureDescriptor instanceof Node.PropertySet) {
            if (this.isEditing()) {
                this.removeEditor();
                this.changeSelection(n, n2, false, false);
            }
            this.maybeToggleExpanded(n, eventObject);
            this.exitEditRequest();
            return false;
        }
        boolean bl2 = bl = eventObject instanceof MouseEvent && PropUtils.forceRadioButtons || featureDescriptor != null && featureDescriptor.getValue("stringValues") != null;
        if (!bl && (n2 == 1 || eventObject instanceof KeyEvent) && this.checkEditBoolean(n)) {
            this.exitEditRequest();
            return false;
        }
        boolean bl3 = false;
        try {
            bl3 = super.editCellAt(n, n2, eventObject);
        }
        finally {
            this.exitEditRequest();
        }
        return bl3;
    }

    @Override
    public void removeEditor() {
        this.enterEditorRemoveRequest();
        try {
            super.removeEditor();
            this.getEditor().setInplaceEditor(null);
        }
        finally {
            this.exitEditorRemoveRequest();
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        boolean bl;
        if (n2 == 0) {
            return null != this.getCustomEditor(n);
        }
        FeatureDescriptor featureDescriptor = this.getPropertySetModel().getFeatureDescriptor(n);
        if (featureDescriptor instanceof Node.PropertySet) {
            bl = false;
        } else {
            Object object;
            Node.Property property = (Node.Property)featureDescriptor;
            bl = property.canWrite();
            if (bl && (object = property.getValue("canEditAsText")) != null && !(bl &= Boolean.TRUE.equals(object))) {
                PropertyEditor propertyEditor = PropUtils.getPropertyEditor(property);
                bl |= propertyEditor.getTags() != null;
            }
        }
        return bl;
    }

    private void maybeToggleExpanded(int n, EventObject eventObject) {
        boolean bl = true;
        if (eventObject instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            boolean bl2 = bl = mouseEvent.getClickCount() > 1;
            if (!bl) {
                boolean bl3 = bl = mouseEvent.getPoint().x <= PropUtils.getMarginWidth();
            }
        }
        if (bl) {
            this.toggleExpanded(n);
        }
    }

    private void toggleExpanded(int n) {
        if (this.isEditing()) {
            this.getEditor().cancelCellEditing();
        }
        PropertySetModel propertySetModel = this.getSheetModel().getPropertySetModel();
        propertySetModel.toggleExpanded(n);
    }

    boolean checkEditBoolean(int n) {
        Class clazz;
        Node.Property property;
        FeatureDescriptor featureDescriptor = this.getSheetModel().getPropertySetModel().getFeatureDescriptor(n);
        if (featureDescriptor != null && featureDescriptor.getValue("stringValues") != null) {
            return false;
        }
        Node.Property property2 = property = featureDescriptor instanceof Node.Property ? (Node.Property)featureDescriptor : null;
        if (property != null && ((clazz = property.getValueType()) == Boolean.class || clazz == Boolean.TYPE)) {
            if (!this.isCellEditable(n, 1)) {
                return true;
            }
            try {
                Object object;
                Boolean bl = null;
                try {
                    object = property.getValue();
                    if (!(object instanceof Boolean)) {
                        return false;
                    }
                    bl = (Boolean)object;
                }
                catch (ProxyNode.DifferentValuesException differentValuesException) {
                    bl = Boolean.FALSE;
                }
                if (this.isEditing()) {
                    this.removeEditor();
                }
                this.changeSelection(n, 1, false, false);
                object = bl == null || Boolean.FALSE.equals(bl) ? Boolean.TRUE : Boolean.FALSE;
                property.setValue(object);
                this.paintRow(n);
                return true;
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        return false;
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        InplaceEditor inplaceEditor;
        if (tableCellEditor == null) {
            return null;
        }
        Component component = super.prepareEditor(tableCellEditor, n, n2);
        if (component == null) {
            return null;
        }
        if (1 == n2 && (inplaceEditor = this.getEditor().getInplaceEditor()).supportsTextEntry()) {
            component.setBackground(PropUtils.getTextFieldBackground());
            component.setForeground(PropUtils.getTextFieldForeground());
        }
        if (component instanceof JComponent) {
            ((JComponent)component).setBorder(BorderFactory.createEmptyBorder(0, PropUtils.getTextMargin(), 0, 0));
        }
        return component;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        boolean bl = this.isEditing();
        int n = this.lastSelectedRow = bl ? this.getEditingRow() : this.getSelectionModel().getAnchorSelectionIndex();
        if (bl) {
            this.getEditor().stopCellEditing();
        }
        super.tableChanged(tableModelEvent);
        this.restoreEditingState();
    }

    void saveEditingState() {
        InplaceEditor inplaceEditor;
        this.storedFd = this._getSelection();
        if (this.isEditing() && (inplaceEditor = this.getEditor().getInplaceEditor()) != null) {
            this.partialValue = inplaceEditor.getValue();
        }
    }

    void restoreEditingState() {
        boolean bl;
        int n = this.indexOfLastSelected();
        boolean bl2 = bl = n != -1;
        if (!bl) {
            n = this.lastSelectedRow;
        }
        if (n == -1) {
            this.clearSavedEditingState();
            return;
        }
        if (n < this.getRowCount()) {
            this.changeSelection(n, 1, false, false);
            if (bl && this.wasEditing) {
                this.editCellAt(n, 1);
                InplaceEditor inplaceEditor = this.getEditor().getInplaceEditor();
                if (inplaceEditor != null && this.partialValue != null) {
                    inplaceEditor.setValue(this.partialValue);
                }
            }
        }
        this.clearSavedEditingState();
    }

    private void clearSavedEditingState() {
        this.storedFd = null;
        this.wasEditing = false;
        this.partialValue = null;
    }

    private int indexOfLastSelected() {
        if (this.storedFd == null) {
            return -1;
        }
        PropertySetModel propertySetModel = this.getPropertySetModel();
        int n = propertySetModel.indexOf(this.storedFd);
        this.storedFd = null;
        return n;
    }

    @Override
    public void pendingChange(PropertySetModelEvent propertySetModelEvent) {
        if (propertySetModelEvent.isReordering()) {
            this.wasEditing = this.isEditing();
            this.saveEditingState();
        } else {
            this.storedFd = null;
            this.wasEditing = false;
            this.partialValue = null;
        }
    }

    @Override
    public void boundedChange(PropertySetModelEvent propertySetModelEvent) {
    }

    @Override
    public void wholesaleChange(PropertySetModelEvent propertySetModelEvent) {
    }

    @Override
    public Component getCursorChangeComponent() {
        Container container = this.getTopLevelAncestor();
        return container instanceof JFrame ? ((JFrame)container).getContentPane() : (container instanceof JDialog ? ((JDialog)container).getContentPane() : container);
    }

    @Override
    public Object getPartialValue() {
        Object object = null;
        if (this.isEditing() && this.editingRow == this.getSelectedRow()) {
            InplaceEditor inplaceEditor = this.getEditor().getInplaceEditor();
            if (inplaceEditor != null) {
                object = inplaceEditor.getValue();
                inplaceEditor.reset();
                this.getEditor().cancelCellEditing();
            }
        } else {
            object = null;
            if (this.isEditing()) {
                this.removeEditor();
            }
        }
        return object;
    }

    @Override
    public void editorClosed() {
        if (this.lastFailed) {
            this.editCellAt(this.getSelectedRow(), 1, null);
        }
        this.repaint();
        this.customEditorIsOpen = false;
    }

    @Override
    public void editorOpened() {
        this.paintSelectionRow();
        this.customEditorIsOpen = true;
    }

    @Override
    public void editorOpening() {
        this.lastFailed = false;
        this.customEditorIsOpen = true;
    }

    @Override
    public void valueChanged(PropertyEditor propertyEditor) {
        this.lastFailed = false;
    }

    @Override
    public boolean allowInvoke() {
        return true;
    }

    @Override
    public void failed() {
        this.lastFailed = true;
    }

    @Override
    public boolean wantAllChanges() {
        return false;
    }

    @Override
    public ReusablePropertyEnv getReusablePropertyEnv() {
        return this.reusableEnv;
    }

    public ReusablePropertyModel getReusablePropertyModel() {
        return this.reusableModel;
    }

    private boolean isGoingToBeClosed() {
        return this.getRowCount() <= 0;
    }

    @Override
    public void setUI(TableUI tableUI) {
        super.setUI(tableUI);
        this.renderer = null;
        this.sheetCellEditor = null;
    }

    private class IncrementAction
    extends AbstractAction {
        private final boolean isIncrement;
        private final Action changeRowAction;

        private IncrementAction(boolean bl, Action action) {
            this.isIncrement = bl;
            this.changeRowAction = action;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SheetCellEditor sheetCellEditor;
            InplaceEditor inplaceEditor;
            if (SheetTable.this.isEditing() && (inplaceEditor = (sheetCellEditor = SheetTable.this.getEditor()).getInplaceEditor()) instanceof IncrementPropertyValueSupport) {
                boolean bl;
                IncrementPropertyValueSupport incrementPropertyValueSupport = (IncrementPropertyValueSupport)((Object)inplaceEditor);
                boolean bl2 = bl = this.isIncrement ? incrementPropertyValueSupport.incrementValue() : incrementPropertyValueSupport.decrementValue();
                if (bl) {
                    return;
                }
            }
            this.changeRowAction.actionPerformed(actionEvent);
        }
    }

    private static class SheetTableTransferable
    implements Transferable {
        private static DataFlavor[] stringFlavors;
        private static DataFlavor[] plainFlavors;
        protected String plainData;

        public SheetTableTransferable(String string) {
            this.plainData = string;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            int n = this.isPlainSupported() ? plainFlavors.length : 0;
            int n2 = this.isPlainSupported() ? stringFlavors.length : 0;
            int n3 = n + n2;
            DataFlavor[] dataFlavorArray = new DataFlavor[n3];
            int n4 = 0;
            if (n > 0) {
                System.arraycopy(plainFlavors, 0, dataFlavorArray, n4, n);
                n4 += n;
            }
            if (n2 > 0) {
                System.arraycopy(stringFlavors, 0, dataFlavorArray, n4, n2);
                n4 += n2;
            }
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (this.isPlainFlavor(dataFlavor)) {
                String string = this.getPlainData();
                String string2 = string = string == null ? "" : string;
                if (String.class.equals(dataFlavor.getRepresentationClass())) {
                    return string;
                }
                if (Reader.class.equals(dataFlavor.getRepresentationClass())) {
                    return new StringReader(string);
                }
                if (InputStream.class.equals(dataFlavor.getRepresentationClass())) {
                    return new StringBufferInputStream(string);
                }
            } else if (this.isStringFlavor(dataFlavor)) {
                String string = this.getPlainData();
                string = string == null ? "" : string;
                return string;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        protected boolean isPlainFlavor(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = plainFlavors;
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        protected boolean isPlainSupported() {
            return this.plainData != null;
        }

        protected String getPlainData() {
            return this.plainData;
        }

        protected boolean isStringFlavor(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = stringFlavors;
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        static {
            block2: {
                try {
                    plainFlavors = new DataFlavor[3];
                    SheetTableTransferable.plainFlavors[0] = new DataFlavor("text/plain;class=java.lang.String");
                    SheetTableTransferable.plainFlavors[1] = new DataFlavor("text/plain;class=java.io.Reader");
                    SheetTableTransferable.plainFlavors[2] = new DataFlavor("text/plain;charset=unicode;class=java.io.InputStream");
                    stringFlavors = new DataFlavor[2];
                    SheetTableTransferable.stringFlavors[0] = new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.String");
                    SheetTableTransferable.stringFlavors[1] = DataFlavor.stringFlavor;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError((Object)classNotFoundException);
                }
            }
        }
    }

    private static class SheetTableTransferHandler
    extends TransferHandler {
        private SheetTableTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            if (jComponent instanceof SheetTable) {
                SheetTable sheetTable = (SheetTable)jComponent;
                FeatureDescriptor featureDescriptor = sheetTable.getSelection();
                if (featureDescriptor == null) {
                    return null;
                }
                String string = featureDescriptor.getDisplayName();
                if (featureDescriptor instanceof Node.Property) {
                    Node.Property property = (Node.Property)featureDescriptor;
                    string = string + "\t" + PropUtils.getPropertyEditor(property).getAsText();
                }
                return new SheetTableTransferable(string);
            }
            return null;
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 1;
        }
    }

    private class STPolicy
    extends ContainerOrderFocusTraversalPolicy {
        private STPolicy() {
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            if (SheetTable.this.inEditorRemoveRequest()) {
                return SheetTable.this;
            }
            Component component2 = super.getComponentAfter(container, component);
            return component2;
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            if (SheetTable.this.inEditorRemoveRequest()) {
                return SheetTable.this;
            }
            return super.getComponentBefore(container, component);
        }

        @Override
        public Component getFirstComponent(Container container) {
            if (!SheetTable.this.inEditorRemoveRequest() && SheetTable.this.isEditing()) {
                return SheetTable.this.editorComp;
            }
            return SheetTable.this;
        }

        @Override
        public Component getDefaultComponent(Container container) {
            if (!SheetTable.this.inEditorRemoveRequest() && SheetTable.this.isEditing() && SheetTable.this.editorComp.isShowing()) {
                return SheetTable.this.editorComp;
            }
            return SheetTable.this;
        }

        @Override
        protected boolean accept(Component component) {
            InplaceEditor inplaceEditor;
            if (SheetTable.this.isEditing() && SheetTable.this.inEditorRemoveRequest() && (inplaceEditor = SheetTable.this.getEditor().getInplaceEditor()) != null && (component == inplaceEditor.getComponent() || inplaceEditor.isKnownComponent(component))) {
                return false;
            }
            return super.accept(component) && component.isShowing();
        }
    }

    private class EditorClassAction
    extends AbstractAction {
        public EditorClassAction() {
            super(SheetTable.ACTION_EDCLASS);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = SheetTable.this.getSelectedRow();
            if (n != -1) {
                FeatureDescriptor featureDescriptor = SheetTable.this.getPropertySetModel().getFeatureDescriptor(n);
                if (featureDescriptor instanceof Node.Property) {
                    PropertyEditor propertyEditor = PropUtils.getPropertyEditor((Node.Property)featureDescriptor);
                    System.err.println(propertyEditor.getClass().getName());
                } else {
                    System.err.println("PropertySets - no editor");
                }
            } else {
                System.err.println("No selection");
            }
        }

        @Override
        public boolean isEnabled() {
            return SheetTable.this.getSelectedRow() != -1;
        }
    }

    private class CollapseAction
    extends AbstractAction {
        public CollapseAction() {
            super(SheetTable.ACTION_COLLAPSE);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FeatureDescriptor featureDescriptor = SheetTable.this._getSelection();
            if (featureDescriptor instanceof Node.PropertySet) {
                int n = SheetTable.this.getSelectedRow();
                boolean bl = SheetTable.this.getPropertySetModel().isExpanded(featureDescriptor);
                if (!bl) {
                    SheetTable.this.toggleExpanded(n);
                }
            }
        }

        @Override
        public boolean isEnabled() {
            boolean bl = SheetTable.this._getSelection() instanceof Node.PropertySet;
            return bl;
        }
    }

    private class ExpandAction
    extends AbstractAction {
        public ExpandAction() {
            super(SheetTable.ACTION_EXPAND);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FeatureDescriptor featureDescriptor = SheetTable.this._getSelection();
            if (featureDescriptor instanceof Node.PropertySet) {
                int n = SheetTable.this.getSelectedRow();
                boolean bl = SheetTable.this.getPropertySetModel().isExpanded(featureDescriptor);
                if (bl) {
                    SheetTable.this.toggleExpanded(n);
                }
            }
        }

        @Override
        public boolean isEnabled() {
            return SheetTable.this._getSelection() instanceof Node.PropertySet;
        }
    }
}

