/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util.http;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public final class FastHttpDateFormat {
    protected static final int CACHE_SIZE = 1000;
    protected static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    protected static final ThreadLocal<SimpleDateFormat> FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat f = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            f.setTimeZone(GMT_TIME_ZONE);
            return f;
        }
    };
    protected static final TimeZone gmtZone = TimeZone.getTimeZone("GMT");
    protected static final ThreadLocal FORMATS = new ThreadLocal(){

        protected Object initialValue() {
            SimpleDateFormat[] f = new SimpleDateFormat[3];
            f[0] = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            f[0].setTimeZone(GMT_TIME_ZONE);
            f[1] = new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US);
            f[1].setTimeZone(GMT_TIME_ZONE);
            f[2] = new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US);
            f[2].setTimeZone(GMT_TIME_ZONE);
            return f;
        }
    };
    protected static volatile long nextGeneration;
    protected static volatile String currentDate;
    protected static final ConcurrentHashMap<Long, String> formatCache;
    protected static final ConcurrentHashMap<String, Long> parseCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getCurrentDate() {
        long now = System.currentTimeMillis();
        if (now > nextGeneration) {
            ThreadLocal<SimpleDateFormat> threadLocal = FORMAT;
            synchronized (threadLocal) {
                if (now > nextGeneration) {
                    nextGeneration = now + 1000L;
                    currentDate = FORMAT.get().format(new Date(now));
                }
            }
        }
        return currentDate;
    }

    public static final String formatDate(long value, DateFormat threadLocalformat) {
        Long longValue = value = value / 1000L * 1000L;
        String cachedDate = formatCache.get(longValue);
        if (cachedDate != null) {
            return cachedDate;
        }
        String newDate = null;
        Date dateValue = new Date(value);
        newDate = threadLocalformat != null ? threadLocalformat.format(dateValue) : FORMAT.get().format(dateValue);
        FastHttpDateFormat.updateFormatCache(longValue, newDate);
        return newDate;
    }

    public static final long parseDate(String value, DateFormat[] threadLocalformats) {
        Long cachedDate = parseCache.get(value);
        if (cachedDate != null) {
            return cachedDate;
        }
        long date = threadLocalformats != null ? FastHttpDateFormat.internalParseDate(value, threadLocalformats) : FastHttpDateFormat.internalParseDate(value, (SimpleDateFormat[])FORMATS.get());
        if (date != -1L) {
            FastHttpDateFormat.updateParseCache(value, date);
        }
        return date;
    }

    private static final long internalParseDate(String value, DateFormat[] formats) {
        int i = 0;
        if (i < formats.length) {
            try {
                return formats[i].parse(value).getTime();
            }
            catch (ParseException e) {
                return -1L;
            }
        }
        return -1L;
    }

    private static void updateFormatCache(Long key, String value) {
        if (value == null) {
            return;
        }
        if (formatCache.size() > 1000) {
            formatCache.clear();
        }
        formatCache.put(key, value);
    }

    private static void updateParseCache(String key, Long value) {
        if (parseCache.size() > 1000) {
            parseCache.clear();
        }
        parseCache.put(key, value);
    }

    static {
        formatCache = new ConcurrentHashMap(1000, 0.75f, 64);
        parseCache = new ConcurrentHashMap(1000, 0.75f, 64);
    }
}

