/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.concurrent.LocalAwareExecutorService;
import org.apache.cassandra.concurrent.SEPExecutor;
import org.apache.cassandra.concurrent.SEPWorker;

public class SharedExecutorPool {
    public static final SharedExecutorPool SHARED = new SharedExecutorPool("SharedPool");
    final String poolName;
    final AtomicLong workerId = new AtomicLong();
    final List<SEPExecutor> executors = new CopyOnWriteArrayList<SEPExecutor>();
    final AtomicInteger spinningCount = new AtomicInteger();
    final AtomicLong stopCheck = new AtomicLong();
    final ConcurrentSkipListMap<Long, SEPWorker> spinning = new ConcurrentSkipListMap();
    final ConcurrentSkipListMap<Long, SEPWorker> descheduled = new ConcurrentSkipListMap();

    public SharedExecutorPool(String poolName) {
        this.poolName = poolName;
    }

    void schedule(SEPWorker.Work work) {
        Map.Entry<Long, SEPWorker> e;
        while (null != (e = this.spinning.pollFirstEntry()) || null != (e = this.descheduled.pollFirstEntry())) {
            if (!e.getValue().assign(work, false)) continue;
            return;
        }
        if (!work.isStop()) {
            new SEPWorker(this.workerId.incrementAndGet(), work, this);
        }
    }

    void maybeStartSpinningWorker() {
        int current = this.spinningCount.get();
        if (current == 0 && this.spinningCount.compareAndSet(0, 1)) {
            this.schedule(SEPWorker.Work.SPINNING);
        }
    }

    public LocalAwareExecutorService newExecutor(int maxConcurrency, int maxQueuedTasks, String jmxPath, String name) {
        SEPExecutor executor = new SEPExecutor(this, maxConcurrency, maxQueuedTasks, jmxPath, name);
        this.executors.add(executor);
        return executor;
    }
}

