/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.igoweb.go.Game;
import org.igoweb.go.Go;
import org.igoweb.go.Loc;
import org.igoweb.go.Rules;
import org.igoweb.go.sgf.Node;
import org.igoweb.go.sgf.Prop;
import org.igoweb.go.sgf.Tree;
import org.igoweb.go.sgf.TreeChanger;
import org.igoweb.go.swing.CommentWidget;
import org.igoweb.go.swing.Estimator;
import org.igoweb.go.swing.FwdBackIcon;
import org.igoweb.go.swing.GobanWidget;
import org.igoweb.go.swing.PlayerWidget;
import org.igoweb.go.swing.Updater;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.Multicaster;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.APopupMenu;
import org.igoweb.util.swing.BlinkLabel;
import org.igoweb.util.swing.Defs;
import org.igoweb.util.swing.GCLayout;
import org.igoweb.util.swing.GuiUtil;
import org.igoweb.util.swing.Prefs;
import org.igoweb.util.swing.SingletonWindow;

public abstract class GamePanel
extends JPanel
implements ActionListener,
TreeChanger {
    public static final int TITLE_CHANGED_EVENT = 0;
    private static final String AUTO_PLAY_SPEED_PREF = "}~y0y<Z3";
    public static final int NEW_NODECHANGE_EVENT = 1;
    public static final int DISPOSE_REQUEST_EVENT = 2;
    public static Estimator estimator = null;
    protected final JPanel controlPanel = new JPanel(new GCLayout());
    final JPanel titlePanel = new TitlePanel();
    private GobanWidget gobanWidget;
    private Game game;
    private Tree tree;
    private final PlayerWidget[] playerWidgets = new PlayerWidget[2];
    protected PlayerWidget timerStarted = null;
    protected final JButton helpBut = new JButton(Defs.getString(1436228516));
    protected final APopupMenu gameOptionsMenu = new APopupMenu();
    protected final JButton gameInfoBut = new JButton(Defs.getString(-451068489));
    protected final JMenuItem rulesMI = new JMenuItem(Defs.getString(-451068487));
    protected final JMenuItem scoreEstMI = Defs.isApp() ? new JMenuItem(Defs.getString(-451068483)) : null;
    protected final JButton closeBut = new JButton(Defs.getString(1436228514));
    private JComponent commentWidget;
    private final JButton[] fwdBackButs = new JButton[4];
    private final CardLayout fwdBackLayout = new CardLayout();
    private final JPanel fwdBackPanel = new JPanel(this.fwdBackLayout);
    private final ArrayList<JComponent> controlButtonList = new ArrayList();
    private final JSlider autoPlaySpeedIn = new JSlider();
    private final JButton stopAutoPlayBut = new JButton(new FwdBackIcon(4));
    private Timer autoPlayTimer;
    private static final double AUTO_PLAY_MIN = 5.52146091786225;
    private static final double AUTO_PLAY_MAX = 11.0020998412042;
    private boolean nodeChangeEnabled = true;
    private EventListener listener = null;
    private final BlinkLabel moveLabel = new BlinkLabel("", 0);
    private final BlinkLabel titleLabel = new BlinkLabel("", 0);
    private final JPanel buttonPanel = AFrame.createBorderedPanel(new GCLayout());
    private Rules rules;
    private final SingletonWindow gameInfoWin = new SingletonWindow();
    private static final int BACKFULL = 0;
    private static final int BACK = 1;
    private static final int FWD = 2;
    private static final int FWDFULL = 3;
    private static final int STOP = 4;
    private static final int UP = 5;
    private static final int DOWN = 6;
    private static final int SKIP_BACK = 7;
    private static final int SKIP_FWD = 8;
    private final ChangeNodeAction[] changeNodeActions = new ChangeNodeAction[]{new ChangeNodeAction(0, 0, "a", 36), new ChangeNodeAction(1, 0, "b", 37), new ChangeNodeAction(2, 0, "c", 39), new ChangeNodeAction(3, 0, "d", 35), new ChangeNodeAction(4, 2, "e", 88), new ChangeNodeAction(5, 0, "f", 38), new ChangeNodeAction(6, 0, "g", 40), new ChangeNodeAction(7, 2, "h", 37), new ChangeNodeAction(8, 2, "i", 39), new ChangeNodeAction(5, 2, "f", 38), new ChangeNodeAction(6, 2, "g", 40)};
    private final EventListener moveUpdater = new EventListener(){
        int whoseMove = 2;
        int moveNum = -1;
        Loc moveLoc = null;

        @Override
        public void handleEvent(Event event) {
            int newWhoseMove = GamePanel.this.game.getWhoseMove();
            int newMoveNum = GamePanel.this.game.getMoveNum();
            Loc newMoveLoc = GamePanel.this.game.getLastMove();
            if (newWhoseMove != this.whoseMove || newMoveNum != this.moveNum || newMoveLoc != this.moveLoc) {
                this.whoseMove = newWhoseMove;
                this.moveNum = newMoveNum;
                this.moveLoc = newMoveLoc;
                GamePanel.this.changeMoveText();
            }
        }
    };
    private final EventListener rootNodeListener = new EventListener(){

        @Override
        public void handleEvent(Event event) {
            if (event.type == 0 || event.type == 1) {
                Prop param = (Prop)event.arg;
                if (param.type == 2 || param.type == 3 || param.type == 1) {
                    if (param.type == 2) {
                        GamePanel.this.playerWidgets[param.getColor()].setPlayerName(event.type == 0 ? param.getText() : Defs.getString(param.getColor() == 0 ? -451068516 : -451068474));
                    } else if (param.type == 3) {
                        GamePanel.this.playerWidgets[param.getColor()].setRank(event.type == 0 ? param.getInt() : 0);
                    }
                    GamePanel.this.changeTitleText();
                } else if (param.type == 28) {
                    GamePanel.this.changeMoveText();
                }
            }
        }
    };
    private final EventListener treeListener = new EventListener(){

        @Override
        public void handleEvent(Event event) {
            GamePanel.this.treeEvent(event);
        }
    };
    private final ContainerListener keyAccelStripper = new ContainerListener(){

        @Override
        public void componentAdded(ContainerEvent e) {
            GamePanel.this.stripSgfKeyAccelerators(e.getChild());
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
        }
    };

    protected void init(Tree newTree, LayoutManager2 layout) {
        this.tree = newTree;
        this.setLayout(layout);
        this.setOpaque(false);
        this.helpBut.addActionListener(this);
        this.closeBut.addActionListener(this);
        this.rulesMI.addActionListener(this);
        if (this.scoreEstMI != null) {
            this.scoreEstMI.addActionListener(this);
        }
        this.rules = newTree.root.findProp(0).getRules();
        this.game = new Game(this.rules);
        this.gobanWidget = this.buildGobanWidget(this.game);
        this.add(this.gobanWidget);
        this.gobanWidget.addLabelAccelerator();
        JPanel panel = new JPanel(new BorderLayout());
        this.titlePanel.add(panel);
        panel.add("North", this.titleLabel);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        panel.add(this.moveLabel);
        this.add(this.titlePanel);
        this.controlPanel.setOpaque(false);
        this.controlPanel.add("xSpan=2,xGrow=t,yGrow=f", this.buttonPanel);
        this.buildControlButtonList(this.controlButtonList);
        this.gameInfoBut.addActionListener(this);
        this.gameInfoBut.setIcon(new FwdBackIcon(2));
        this.gameInfoBut.setHorizontalTextPosition(2);
        this.gameOptionsMenu.addTriggerComponent(this.gameInfoBut);
        this.addChangeNodeAccelerators(this.buttonPanel);
        JPanel innerFwdBack = new JPanel(new GridLayout(1, 4, 0, 0));
        this.fwdBackPanel.add("", innerFwdBack);
        for (int butNum = 0; butNum < 4; ++butNum) {
            this.fwdBackButs[butNum] = new JButton(new FwdBackIcon(butNum));
            innerFwdBack.add(this.fwdBackButs[butNum]);
            this.fwdBackButs[butNum].addActionListener(new ChangeNodeAction(butNum, 0, "", 0));
        }
        this.fwdBackButs[2].setToolTipText(Defs.getString(-451068473));
        this.updateFwdBackButtons();
        innerFwdBack = new JPanel(new BorderLayout());
        innerFwdBack.add("Before", this.stopAutoPlayBut);
        this.stopAutoPlayBut.addActionListener(this.changeNodeActions[4]);
        innerFwdBack.add(this.autoPlaySpeedIn);
        this.autoPlaySpeedIn.setPreferredSize(new Dimension(10, 10));
        this.fwdBackPanel.add(AUTO_PLAY_SPEED_PREF, innerFwdBack);
        this.fwdBackLayout.first(this.fwdBackPanel);
        this.autoPlaySpeedIn.setMinimum(0);
        this.autoPlaySpeedIn.setMaximum(1000);
        this.autoPlaySpeedIn.setValue(Prefs.getInt(AUTO_PLAY_SPEED_PREF, 500));
        this.autoPlayTimer = new Timer(this.getAutoPlayDelay(), this.changeNodeActions[2]);
        this.autoPlaySpeedIn.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                GamePanel.this.autoPlayDelayChanged();
            }
        });
        for (int i = 1; i >= 0; --i) {
            Prop nameProp = newTree.root.findProp(2, i);
            Prop rankProp = newTree.root.findProp(3, i);
            this.playerWidgets[i] = this.buildPlayerWidget(i, nameProp == null ? Defs.getString(i == 0 ? -451068516 : -451068474) : nameProp.getText(), rankProp == null ? 0 : rankProp.getInt());
        }
        this.add(this.controlPanel);
        this.addUpdater(this.gobanWidget, newTree);
        this.add(this.getCommentWidget());
        newTree.addListener(this.treeListener);
        this.game.addListener(this.moveUpdater);
        newTree.root.addListener(this.rootNodeListener);
        if (newTree.getActiveNode() != newTree.root) {
            newTree.getActiveNode().addListener(this.rootNodeListener);
        }
        this.moveUpdater.handleEvent(null);
        this.changeTitleText();
    }

    protected PlayerWidget buildPlayerWidget(int color, String name, int rank) {
        return new PlayerWidget(color, this.game, this.rules.buildClock(), name, rank);
    }

    protected JComponent buildCommentWidget() {
        CommentWidget cw = new CommentWidget(this.tree, true);
        cw.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        return cw;
    }

    protected void setGameInfoMenuItems(JMenuItem[] menuItems) {
        for (int i = 0; i < menuItems.length; ++i) {
            if (menuItems[i] == null) {
                this.gameOptionsMenu.addSeparator();
                continue;
            }
            this.gameOptionsMenu.add(menuItems[i]);
        }
    }

    protected void addUpdater(GobanWidget newGobanWidget, Tree newTree) {
        new Updater(newGobanWidget, newTree, false, this.playerWidgets[1].getClock(), this.playerWidgets[0].getClock());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.closeBut) {
            this.closePressed();
        } else if (source == this.helpBut) {
            GuiUtil.loadHelp(this.helpUrl());
        } else if (source == this.rulesMI) {
            if (!this.gameInfoWin.raiseIfOpen()) {
                this.gameInfoWin.setWindow(this.buildGameInfoWindow());
            }
        } else if (source == this.gameInfoBut) {
            if (!this.gameOptionsMenu.isVisible()) {
                this.showGameOptionsPopup();
                this.gameOptionsMenu.show(this.gameInfoBut);
            }
        } else if (source == this.scoreEstMI) {
            estimator.estimate(this.game, this, this.titleLabel.getText());
        }
    }

    public void setPaused(int player, boolean pauseValue) {
        this.playerWidgets[player].setPaused(pauseValue);
    }

    public PlayerWidget getPlayerWidget(int color) {
        return this.playerWidgets[color];
    }

    protected void setNodeChangeEnabled(boolean newEnabled) {
        if (this.nodeChangeEnabled != newEnabled) {
            this.nodeChangeEnabled = newEnabled;
            this.updateFwdBackButtons();
            this.emit(1);
        }
    }

    public final boolean isNodeChangeEnabled() {
        return this.nodeChangeEnabled;
    }

    public abstract void changeActiveNode(Node var1);

    public void addListener(EventListener newListener) {
        this.listener = Multicaster.add(this.listener, newListener);
    }

    public void removeListener(EventListener oldListener) {
        this.listener = Multicaster.remove(this.listener, oldListener);
    }

    private void updateFwdBackButtons() {
        boolean back = this.nodeChangeEnabled && this.tree.getActiveNode().parent != null;
        this.fwdBackButs[0].setEnabled(back);
        this.fwdBackButs[1].setEnabled(back);
        boolean fwd = this.nodeChangeEnabled && this.tree.getActiveNode().getActiveChild() != null;
        this.fwdBackButs[2].setEnabled(fwd);
        this.fwdBackButs[3].setEnabled(fwd);
    }

    protected void stopAutoPlay() {
        this.fwdBackLayout.first(this.fwdBackPanel);
        this.autoPlayTimer.stop();
    }

    private void fwdBackButPressed(int butNum, int eventModifierMask) {
        Node node = this.tree.getActiveNode();
        switch (butNum) {
            case 0: {
                while (node.parent != null) {
                    node = node.parent;
                }
                break;
            }
            case 7: {
                while (node.parent != null && !(node = node.parent).isAnnotated() && node.countChildren() <= 1) {
                }
                break;
            }
            case 1: {
                node = node.parent;
                break;
            }
            case 2: {
                if ((eventModifierMask & 1) == 0) {
                    if ((node = node.getActiveChild()) != null || !this.autoPlayTimer.isRunning()) break;
                    this.fwdBackButPressed(4, 0);
                    return;
                }
                this.fwdBackLayout.last(this.fwdBackPanel);
                this.autoPlayTimer.start();
                break;
            }
            case 8: {
                while (node.getActiveChild() != null && !(node = node.getActiveChild()).isAnnotated() && node.countChildren() <= 1) {
                }
                break;
            }
            case 3: {
                while (node.getActiveChild() != null) {
                    node = node.getActiveChild();
                }
                break;
            }
            case 5: 
            case 6: {
                Node newActiveChild = node.findNextChild(butNum == 5 ? -1 : 1);
                if (newActiveChild == null) break;
                this.tree.getActiveNode().setActiveChild(newActiveChild);
                break;
            }
            case 4: {
                this.stopAutoPlay();
            }
        }
        if (node != null) {
            this.changeActiveNode(node);
        }
    }

    public abstract void closePressed();

    protected abstract AFrame buildGameInfoWindow();

    protected AFrame getGameInfoWindow() {
        return this.gameInfoWin.getWindow();
    }

    protected abstract String helpUrl();

    private void addChangeNodeAccelerators(JComponent comp) {
        for (int i = 0; i < this.changeNodeActions.length; ++i) {
            this.getInputMap(2).put(KeyStroke.getKeyStroke(this.changeNodeActions[i].key, this.changeNodeActions[i].ctrlKey), this.changeNodeActions[i].command);
            this.getActionMap().put(this.changeNodeActions[i].command, this.changeNodeActions[i]);
        }
    }

    protected void showGameOptionsPopup() {
        if (this.scoreEstMI != null && estimator != null) {
            this.scoreEstMI.setEnabled(estimator.possible(this.game));
        }
    }

    protected Component createPlayerWidget(int color, PlayerWidget origWidget) {
        return origWidget;
    }

    protected void emit(int type) {
        this.emit(type, null);
    }

    protected void emit(int type, Object arg) {
        if (this.listener != null) {
            this.listener.handleEvent(new Event(this, type, arg));
        }
    }

    protected JComponent getTitlePanel() {
        return this.titlePanel;
    }

    protected void buildControlButtonList(ArrayList<JComponent> list) {
        list.add(this.fwdBackPanel);
    }

    @Override
    public void removeNotify() {
        this.tree.removeListener(this.treeListener);
        this.game.removeListener(this.moveUpdater);
        this.tree.root.removeListener(this.rootNodeListener);
        super.removeNotify();
    }

    public final void addProp(Prop param) {
        this.addProp(null, param);
    }

    @Override
    public abstract void addProp(Node var1, Prop var2);

    public final void removeProp(Prop param) {
        this.removeProp(this.tree.getActiveNode(), param);
    }

    @Override
    public abstract void removeProp(Node var1, Prop var2);

    public final void addNode() {
        this.addNode(this.tree.getActiveNode(), true);
    }

    public abstract void addNode(Node var1, boolean var2);

    public final void changeTitleText() {
        String titleText = this.getTitleText();
        this.titleLabel.setBlinking(this.isTitleTextBlinking());
        if (!titleText.equals(this.titleLabel.getText())) {
            this.titleLabel.setText(titleText);
            this.emit(0, titleText);
        }
    }

    public final void changeMoveText() {
        this.moveLabel.setText(this.getMoveText());
        this.moveLabel.setBlinking(this.isMoveTextBlinking());
    }

    public String getTitleText() {
        Node root = this.tree.root;
        Prop p = root.findProp(1);
        if (p != null) {
            return p.getText();
        }
        Object[] players = new String[2];
        for (int i = 0; i <= 1; ++i) {
            int pn = 1 - i;
            p = root.findProp(2, i);
            if (p == null) {
                players[pn] = Defs.getString(i == 0 ? -451068516 : -451068474);
                continue;
            }
            players[pn] = p.getText();
            p = root.findProp(3, i);
            if (p == null) continue;
            players[pn] = Defs.getString(-451068477, new Object[]{players[pn], Go.formatRank(p.getInt()), new Integer(1)});
        }
        return Defs.getString(-1337055791, players);
    }

    public boolean isTitleTextBlinking() {
        return false;
    }

    public String getMoveText() {
        Prop param = this.tree.getActiveNode().findProp(28);
        String moveDesc = param == null ? this.game.lastMoveDesc() : param.getText();
        return Defs.getString(-451068495, new Object[]{new Integer(this.game.getMoveNum()), moveDesc, new Integer(this.game.getWhoseMove())});
    }

    public boolean isMoveTextBlinking() {
        return false;
    }

    protected void buildControlPanel(boolean wide) {
        this.buttonPanel.removeAll();
        this.buildButtonPanel(this.buttonPanel, this.controlButtonList, wide);
        this.controlPanel.removeAll();
        this.controlPanel.setLayout(new GCLayout());
        if (wide) {
            this.controlPanel.add("xSpan=2,xGrow=t", this.buttonPanel);
            this.controlPanel.add("x=0,xSpan=1,xGrow=t", this.playerWidgets[1]);
            this.controlPanel.add(this.playerWidgets[0]);
        } else {
            this.controlPanel.add("xSpan=1,xGrow=t,yGrow=f", this.buttonPanel);
            this.controlPanel.add("x=0,yGrow=t", this.playerWidgets[1]);
            this.controlPanel.add("x=0,yGrow=t", this.playerWidgets[0]);
        }
    }

    protected void addControlButton(JComponent component) {
        this.controlButtonList.add(component);
        ((LayoutManager2)this.getLayout()).invalidateLayout(this);
    }

    protected void buildButtonPanel(JPanel newButtonPanel, ArrayList<JComponent> buttons, boolean wide) {
        newButtonPanel.setLayout(new GCLayout());
        Iterator<JComponent> iter = buttons.iterator();
        if (wide) {
            if ((buttons.size() & 1) == 0) {
                newButtonPanel.add("x=0,xSpan=2,yBorder=2", iter.next());
            }
            while (iter.hasNext()) {
                JComponent component = iter.next();
                if (iter.hasNext()) {
                    newButtonPanel.add("x=0,xSpan=1,xBorder=2,yBorder=2,xGrow=t", component);
                    newButtonPanel.add(iter.next());
                    continue;
                }
                newButtonPanel.add("x=0,xSpan=2,yBorder=2", component);
            }
        } else {
            while (iter.hasNext()) {
                newButtonPanel.add("x=0,yBorder=2,xGrow=t,yGrow=t", iter.next());
            }
        }
    }

    protected void displayLocName(Loc loc) {
    }

    public void startPropBundle() {
    }

    public void endPropBundle() {
    }

    protected void treeEvent(Event event) {
        Node node = (Node)event.source;
        switch (event.type) {
            case 7: {
                if (node != this.tree.root) {
                    node.removeListener(this.rootNodeListener);
                }
                if ((node = this.tree.getActiveNode()) != this.tree.root) {
                    node.addListener(this.rootNodeListener);
                }
                if (!this.nodeChangeEnabled) break;
                this.updateFwdBackButtons();
                break;
            }
            case 5: {
                if (!this.nodeChangeEnabled || node != this.tree.getActiveNode()) break;
                this.updateFwdBackButtons();
                break;
            }
            case 6: {
                if (!this.nodeChangeEnabled || node.parent != this.tree.getActiveNode()) break;
                this.updateFwdBackButtons();
            }
        }
    }

    private void autoPlayDelayChanged() {
        Prefs.putInt(AUTO_PLAY_SPEED_PREF, this.autoPlaySpeedIn.getValue());
        int delay = this.getAutoPlayDelay();
        this.autoPlayTimer.setDelay(delay);
        this.autoPlayTimer.setInitialDelay(delay);
        this.autoPlayTimer.restart();
    }

    private int getAutoPlayDelay() {
        double val = this.autoPlaySpeedIn.getValue();
        double max = this.autoPlaySpeedIn.getMaximum();
        return (int)Math.exp((max - val) / max * 5.480638923341951 + 5.52146091786225);
    }

    public Game getGame() {
        return this.game;
    }

    public Tree getSgfTree() {
        return this.tree;
    }

    public GobanWidget getGobanWidget() {
        return this.gobanWidget;
    }

    protected final JComponent getCommentWidget() {
        if (this.commentWidget == null) {
            this.commentWidget = this.buildCommentWidget();
        }
        return this.commentWidget;
    }

    protected abstract void changeScoreMarks(boolean var1);

    protected abstract boolean changeWhoseMove(int var1);

    @Override
    public void addNotify() {
        super.addNotify();
        this.stripSgfKeyAccelerators(this);
    }

    private void stripSgfKeyAccelerators(Component comp) {
        KeyStroke[] ksl = new KeyStroke[this.changeNodeActions.length];
        for (int i = 0; i < ksl.length; ++i) {
            ksl[i] = KeyStroke.getKeyStroke(this.changeNodeActions[i].key, this.changeNodeActions[i].ctrlKey);
        }
        this.stripSgfKeyAccelerators(comp, ksl);
    }

    private void stripSgfKeyAccelerators(Component comp, KeyStroke[] keystrokes) {
        int i;
        if (comp instanceof JTextComponent) {
            return;
        }
        if (comp != this && comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            for (i = 0; i < keystrokes.length; ++i) {
                if (jcomp.getActionForKeyStroke(keystrokes[i]) == null) continue;
                for (int j = 0; j < 3; ++j) {
                    if (jcomp.getInputMap(j).get(keystrokes[i]) == null) continue;
                    jcomp.getInputMap(j).put(keystrokes[i], "bogus");
                }
            }
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (i = 0; i < cont.getComponentCount(); ++i) {
                this.stripSgfKeyAccelerators(cont.getComponent(i), keystrokes);
            }
            java.util.EventListener[] oldListeners = cont.getListeners(ContainerListener.class);
            for (int i2 = 0; i2 < oldListeners.length; ++i2) {
                if (oldListeners[i2] != this.keyAccelStripper) continue;
                return;
            }
            cont.addContainerListener(this.keyAccelStripper);
        }
    }

    protected JComponent getControlPanel() {
        return this.controlPanel;
    }

    protected GobanWidget buildGobanWidget(Game newGame) {
        return new GobanWidget(newGame);
    }

    private class ChangeNodeAction
    extends AbstractAction {
        public final int butNum;
        public final int ctrlKey;
        public final String command;
        public final int key;

        public ChangeNodeAction(int butNum, int ctrlKey, String command, int key) {
            this.butNum = butNum;
            this.ctrlKey = ctrlKey;
            this.command = command;
            this.key = key;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            GamePanel.this.fwdBackButPressed(this.butNum, this.ctrlKey == 0 ? event.getModifiers() : 0);
        }
    }

    private static class TitlePanel
    extends JPanel {
        public TitlePanel() {
            super(new BorderLayout());
            AFrame.createBorderedPanel(this);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension result = super.getPreferredSize();
            result.width = 10;
            return result;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension result = super.getMinimumSize();
            result.width = 10;
            return result;
        }
    }
}

