/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.vmconversion;

import com.amazon.aes.webservices.client.vmconversion.BytesToValue;
import com.amazon.aes.webservices.client.vmconversion.IOHelpers;
import com.amazon.aes.webservices.client.vmconversion.ImageFormatVerifier;
import com.amazon.aes.webservices.client.vmconversion.VMDKDescriptor;
import com.amazon.aes.webservices.client.vmconversion.VerificationException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class StreamOptimizedVMDKVerifier
implements ImageFormatVerifier {
    public static final int HEADER_SIZE = 512;
    public static final int HEADER_OFFSET = 0;
    public static final int MAGIC_NUMBER_OFFSET = 0;
    public static final int MAGIC_NUMBER = 1447904331;
    public static final int DESCRIPTOR_OFFSET = 28;
    public static final int DESCRIPTOR_SIZE_OFFSET = 36;
    public static final int FLAGS_OFFSET = 8;
    public static final int SECTOR_SIZE = 512;
    public static final int END_OF_LINES_OFFSET = 73;
    public static final int END_OF_LINES = 169872650;
    public static final int COMPRESS_ALGORITHM_OFFSET = 77;
    public static final int COMPRESSION_DEFLATE = 1;
    public static final int COMPRESSION_NONE = 0;
    public static final int CAPACITY_OFFSET = 12;
    public static final String NO_PARENT_STRING = "ffffffff";
    public static final String STREAM_OPTIMIZED_TYPE = "streamOptimized";
    File diskImage;
    long capacity;
    long descriptorOffset;
    int descriptorSize;

    public static boolean isESXServerSparseVMDK(File diskImage) {
        try {
            String hdr = new String(IOHelpers.readFromFile(diskImage, 3));
            return hdr.equals("COW");
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isHostedVMDK(File diskImage) {
        try {
            String hdr = new String(IOHelpers.readFromFile(diskImage, 4));
            return hdr.equals("KDMV");
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isStreamOptimizedVMDK(File diskImage) {
        return StreamOptimizedVMDKVerifier.isHostedVMDK(diskImage) && StreamOptimizedVMDKVerifier.isCompressed(diskImage);
    }

    public static boolean isCompressed(File diskImage) {
        try {
            byte[] buffer = IOHelpers.readFromFile(diskImage, 32);
            int headerFlags = BytesToValue.toIntegerLittleEndian(buffer, 8);
            int oneShifted16 = 65536;
            return (headerFlags & oneShifted16) == oneShifted16;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean mayBeFlatVMDK(File diskImage) {
        return !StreamOptimizedVMDKVerifier.isHostedVMDK(diskImage) && !StreamOptimizedVMDKVerifier.isESXServerSparseVMDK(diskImage) && !StreamOptimizedVMDKVerifier.isStreamOptimizedVMDK(diskImage);
    }

    public StreamOptimizedVMDKVerifier(File diskImage_) throws VerificationException {
        this.diskImage = diskImage_;
        try {
            RandomAccessFile source = new RandomAccessFile(this.diskImage, "r");
            this.capacity = this.validateHeadersAndExtractCapacity(source);
            source.close();
        }
        catch (VerificationException e) {
            throw e;
        }
        catch (IOException e) {
            throw new VerificationException("Unable to verify file format: " + e.getMessage() + ".");
        }
        catch (Exception e) {
            throw new VerificationException("Unable to verify file format.");
        }
    }

    public long convertedSize() {
        return this.capacity;
    }

    public String descriptiveFormatName() {
        return "Stream-optimized VMDK";
    }

    private String throwCorrupted(String msg) throws VerificationException {
        throw new VerificationException("This VMDK file appears to be corrupted (" + msg + ").");
    }

    protected long validateHeadersAndExtractCapacity(RandomAccessFile source) throws VerificationException, IOException {
        long size;
        byte[] buff = new byte[512];
        source.seek(0L);
        IOHelpers.reallyRead(source, buff, 512);
        int magicNumber = BytesToValue.toIntegerLittleEndian(buff, 0);
        if (magicNumber != 1447904331) {
            this.throwCorrupted("invalid magic number");
        }
        this.descriptorOffset = BytesToValue.toLongLittleEndian(buff, 28) * 512L;
        if (this.descriptorOffset == 0L) {
            this.throwCorrupted("invalid descriptor");
        }
        if ((size = BytesToValue.toLongLittleEndian(buff, 36) * 512L) > Integer.MAX_VALUE) {
            this.throwCorrupted("VMDK descriptor is too large");
        }
        this.descriptorSize = (int)size;
        String createType = this.parseDescriptor(source);
        if (!createType.equals(STREAM_OPTIMIZED_TYPE)) {
            throw new VerificationException("This VMDK file is of the unsupported type: " + createType + ".");
        }
        int endOfLines = BytesToValue.toIntegerBigEndian(buff, 73);
        if (endOfLines != 169872650) {
            throw new VerificationException("The END_OF_LINES byte of this VMDK file is corrupted.  Perhaps this file has been transferred over ftp in text mode?");
        }
        int compressAlgorithm = BytesToValue.toUnsigned(buff[77]);
        if (compressAlgorithm == 0 && StreamOptimizedVMDKVerifier.isCompressed(this.diskImage)) {
            this.throwCorrupted("detected inconsistent values for its compression settings");
        }
        if (compressAlgorithm != 1) {
            throw new VerificationException("This VMDK file is compressed using the unsupported algorithm " + compressAlgorithm + ".");
        }
        return BytesToValue.toLongLittleEndian(buff, 12) * 512L;
    }

    protected String parseDescriptor(RandomAccessFile source) throws IOException, VerificationException {
        byte[] buff = new byte[this.descriptorSize];
        source.seek(this.descriptorOffset);
        IOHelpers.reallyRead(source, buff, this.descriptorSize);
        VMDKDescriptor descriptor = new VMDKDescriptor(buff);
        String parentCid = descriptor.getParentCid();
        if (parentCid == null) {
            this.throwCorrupted("could not locate the parent CID");
        }
        if (!parentCid.equals(NO_PARENT_STRING)) {
            throw new VerificationException("This VMDK file is a Child VMDK file, which is not supported.");
        }
        String createType = descriptor.getCreateType();
        if (createType == null) {
            this.throwCorrupted("could not locate the create type");
        }
        return createType;
    }
}

