/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.session;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.session.EmptyRowSet;
import org.elasticsearch.xpack.sql.session.ListRowSet;
import org.elasticsearch.xpack.sql.session.SchemaRowSet;
import org.elasticsearch.xpack.sql.session.SingletonRowSet;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.Schema;
import org.elasticsearch.xpack.sql.util.Check;

public abstract class Rows {
    public static Schema schema(List<Attribute> attr) {
        ArrayList<String> names = new ArrayList<String>(attr.size());
        ArrayList<DataType> types = new ArrayList<DataType>(attr.size());
        for (Attribute a : attr) {
            names.add(a.name());
            types.add(a.dataType());
        }
        return new Schema(names, types);
    }

    public static SchemaRowSet of(List<Attribute> attrs, List<List<?>> values) {
        if (values.isEmpty()) {
            return Rows.empty(attrs);
        }
        if (values.size() == 1) {
            return Rows.singleton(attrs, values.get(0).toArray());
        }
        Schema schema = Rows.schema(attrs);
        return new ListRowSet(schema, values);
    }

    public static SchemaRowSet singleton(List<Attribute> attrs, Object ... values) {
        return Rows.singleton(Rows.schema(attrs), values);
    }

    public static SchemaRowSet singleton(Schema schema, Object ... values) {
        Check.isTrue(schema.size() == values.length, "Schema {} and values {} are out of sync", schema, values);
        return new SingletonRowSet(schema, values);
    }

    public static SchemaRowSet empty(Schema schema) {
        return new EmptyRowSet(schema);
    }

    public static SchemaRowSet empty(List<Attribute> attrs) {
        return new EmptyRowSet(Rows.schema(attrs));
    }
}

