/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class PasswordReader
extends Thread {
    private static volatile BufferedReader TEST_READER = null;
    private final AtomicBoolean stopRequested;
    private final Object startMutex = new Object();

    private PasswordReader() {
        this.stopRequested = new AtomicBoolean(false);
        this.setName("Password Reader Thread");
        this.setDaemon(true);
        this.setPriority(10);
    }

    public static char[] readPasswordChars() throws LDAPException {
        BufferedReader testReader = TEST_READER;
        if (testReader != null) {
            try {
                return testReader.readLine().toCharArray();
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_PW_READER_FAILURE.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
        return System.console().readPassword();
    }

    public static byte[] readPassword() throws LDAPException {
        char[] pwChars = PasswordReader.readPasswordChars();
        ByteStringBuffer buffer = new ByteStringBuffer();
        buffer.append(pwChars);
        Arrays.fill(pwChars, '\u0000');
        byte[] pwBytes = buffer.toByteArray();
        buffer.clear(true);
        return pwBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.startMutex;
        synchronized (object) {
            this.startMutex.notifyAll();
        }
        while (!this.stopRequested.get()) {
            System.out.print("\b ");
            PasswordReader.yield();
        }
    }

    @InternalUseOnly
    public static void setTestReaderLines(String ... lines) {
        ByteStringBuffer buffer = new ByteStringBuffer();
        for (String line : lines) {
            buffer.append(line);
            buffer.append(StaticUtils.EOL_BYTES);
        }
        TEST_READER = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(buffer.toByteArray())));
    }

    @InternalUseOnly
    public static void setTestReader(BufferedReader reader) {
        TEST_READER = reader;
    }
}

