/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.fault;

import java.net.InetAddress;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.trogdor.common.Node;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.common.Topology;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkPartitionFaultWorker
implements TaskWorker {
    private static final Logger log = LoggerFactory.getLogger(NetworkPartitionFaultWorker.class);
    private final String id;
    private final List<Set<String>> partitionSets;

    public NetworkPartitionFaultWorker(String id, List<Set<String>> partitionSets) {
        this.id = id;
        this.partitionSets = partitionSets;
    }

    @Override
    public void start(Platform platform, AtomicReference<String> status, KafkaFutureImpl<String> errorFuture) throws Exception {
        log.info("Activating NetworkPartitionFault {}.", (Object)this.id);
        this.runIptablesCommands(platform, "-A");
    }

    @Override
    public void stop(Platform platform) throws Exception {
        log.info("Deactivating NetworkPartitionFault {}.", (Object)this.id);
        this.runIptablesCommands(platform, "-D");
    }

    private void runIptablesCommands(Platform platform, String iptablesAction) throws Exception {
        Node curNode = platform.curNode();
        Topology topology = platform.topology();
        TreeSet<String> toBlock = new TreeSet<String>();
        for (Set<String> partitionSet : this.partitionSets) {
            if (partitionSet.contains(curNode.name())) continue;
            for (String nodeName : partitionSet) {
                toBlock.add(nodeName);
            }
        }
        for (String nodeName : toBlock) {
            Node node = topology.node(nodeName);
            InetAddress addr = InetAddress.getByName(node.hostname());
            platform.runCommand(new String[]{"sudo", "iptables", iptablesAction, "INPUT", "-p", "tcp", "-s", addr.getHostAddress(), "-j", "DROP", "-m", "comment", "--comment", nodeName});
        }
    }
}

