/* Warning: automatically generated code */
#ifndef FIRM_IR_OPCODES_H
#define FIRM_IR_OPCODES_H

/** The opcodes of the libFirm predefined operations.
 * @ingroup ir_op
 */
typedef enum ir_opcode {
	iro_ASM,
	iro_Add,
	iro_Alloc,
	iro_Anchor,
	iro_And,
	iro_Bad,
	iro_Block,
	iro_Borrow,
	iro_Bound,
	iro_Builtin,
	iro_Call,
	iro_Carry,
	iro_Cast,
	iro_Cmp,
	iro_Cond,
	iro_Confirm,
	iro_Const,
	iro_Conv,
	iro_CopyB,
	iro_Deleted,
	iro_Div,
	iro_Dummy,
	iro_End,
	iro_Eor,
	iro_Free,
	iro_IJmp,
	iro_Id,
	iro_InstOf,
	iro_Jmp,
	iro_Load,
	iro_Minus,
	iro_Mod,
	iro_Mul,
	iro_Mulh,
	iro_Mux,
	iro_NoMem,
	iro_Not,
	iro_Or,
	iro_Phi,
	iro_Pin,
	iro_Proj,
	iro_Raise,
	iro_Return,
	iro_Rotl,
	iro_Sel,
	iro_Shl,
	iro_Shr,
	iro_Shrs,
	iro_Start,
	iro_Store,
	iro_Sub,
	iro_Switch,
	iro_SymConst,
	iro_Sync,
	iro_Tuple,
	iro_Unknown,
	iro_First = iro_ASM,
	iro_Last  = iro_Unknown,
	beo_First,
	/* backend specific nodes */
	beo_Spill = beo_First,
	beo_Reload,
	beo_Perm,
	beo_MemPerm,
	beo_Copy,
	beo_Keep,
	beo_CopyKeep,
	beo_Call,
	beo_Return,
	beo_AddSP,
	beo_SubSP,
	beo_IncSP,
	beo_Start,
	beo_FrameAddr,
	/* last backend node number */
	beo_Last = beo_FrameAddr,
	iro_MaxOpcode
} ir_opcode;


/**
 * @ingroup ASM
 * ASM opcode
 */
FIRM_API ir_op *op_ASM;
/**
 * @ingroup Add
 * Add opcode
 */
FIRM_API ir_op *op_Add;
/**
 * @ingroup Alloc
 * Alloc opcode
 */
FIRM_API ir_op *op_Alloc;
/**
 * @ingroup Anchor
 * Anchor opcode
 */
FIRM_API ir_op *op_Anchor;
/**
 * @ingroup And
 * And opcode
 */
FIRM_API ir_op *op_And;
/**
 * @ingroup Bad
 * Bad opcode
 */
FIRM_API ir_op *op_Bad;
/**
 * @ingroup Block
 * Block opcode
 */
FIRM_API ir_op *op_Block;
/**
 * @ingroup Borrow
 * Borrow opcode
 */
FIRM_API ir_op *op_Borrow;
/**
 * @ingroup Bound
 * Bound opcode
 */
FIRM_API ir_op *op_Bound;
/**
 * @ingroup Builtin
 * Builtin opcode
 */
FIRM_API ir_op *op_Builtin;
/**
 * @ingroup Call
 * Call opcode
 */
FIRM_API ir_op *op_Call;
/**
 * @ingroup Carry
 * Carry opcode
 */
FIRM_API ir_op *op_Carry;
/**
 * @ingroup Cast
 * Cast opcode
 */
FIRM_API ir_op *op_Cast;
/**
 * @ingroup Cmp
 * Cmp opcode
 */
FIRM_API ir_op *op_Cmp;
/**
 * @ingroup Cond
 * Cond opcode
 */
FIRM_API ir_op *op_Cond;
/**
 * @ingroup Confirm
 * Confirm opcode
 */
FIRM_API ir_op *op_Confirm;
/**
 * @ingroup Const
 * Const opcode
 */
FIRM_API ir_op *op_Const;
/**
 * @ingroup Conv
 * Conv opcode
 */
FIRM_API ir_op *op_Conv;
/**
 * @ingroup CopyB
 * CopyB opcode
 */
FIRM_API ir_op *op_CopyB;
/**
 * @ingroup Deleted
 * Deleted opcode
 */
FIRM_API ir_op *op_Deleted;
/**
 * @ingroup Div
 * Div opcode
 */
FIRM_API ir_op *op_Div;
/**
 * @ingroup Dummy
 * Dummy opcode
 */
FIRM_API ir_op *op_Dummy;
/**
 * @ingroup End
 * End opcode
 */
FIRM_API ir_op *op_End;
/**
 * @ingroup Eor
 * Eor opcode
 */
FIRM_API ir_op *op_Eor;
/**
 * @ingroup Free
 * Free opcode
 */
FIRM_API ir_op *op_Free;
/**
 * @ingroup IJmp
 * IJmp opcode
 */
FIRM_API ir_op *op_IJmp;
/**
 * @ingroup Id
 * Id opcode
 */
FIRM_API ir_op *op_Id;
/**
 * @ingroup InstOf
 * InstOf opcode
 */
FIRM_API ir_op *op_InstOf;
/**
 * @ingroup Jmp
 * Jmp opcode
 */
FIRM_API ir_op *op_Jmp;
/**
 * @ingroup Load
 * Load opcode
 */
FIRM_API ir_op *op_Load;
/**
 * @ingroup Minus
 * Minus opcode
 */
FIRM_API ir_op *op_Minus;
/**
 * @ingroup Mod
 * Mod opcode
 */
FIRM_API ir_op *op_Mod;
/**
 * @ingroup Mul
 * Mul opcode
 */
FIRM_API ir_op *op_Mul;
/**
 * @ingroup Mulh
 * Mulh opcode
 */
FIRM_API ir_op *op_Mulh;
/**
 * @ingroup Mux
 * Mux opcode
 */
FIRM_API ir_op *op_Mux;
/**
 * @ingroup NoMem
 * NoMem opcode
 */
FIRM_API ir_op *op_NoMem;
/**
 * @ingroup Not
 * Not opcode
 */
FIRM_API ir_op *op_Not;
/**
 * @ingroup Or
 * Or opcode
 */
FIRM_API ir_op *op_Or;
/**
 * @ingroup Phi
 * Phi opcode
 */
FIRM_API ir_op *op_Phi;
/**
 * @ingroup Pin
 * Pin opcode
 */
FIRM_API ir_op *op_Pin;
/**
 * @ingroup Proj
 * Proj opcode
 */
FIRM_API ir_op *op_Proj;
/**
 * @ingroup Raise
 * Raise opcode
 */
FIRM_API ir_op *op_Raise;
/**
 * @ingroup Return
 * Return opcode
 */
FIRM_API ir_op *op_Return;
/**
 * @ingroup Rotl
 * Rotl opcode
 */
FIRM_API ir_op *op_Rotl;
/**
 * @ingroup Sel
 * Sel opcode
 */
FIRM_API ir_op *op_Sel;
/**
 * @ingroup Shl
 * Shl opcode
 */
FIRM_API ir_op *op_Shl;
/**
 * @ingroup Shr
 * Shr opcode
 */
FIRM_API ir_op *op_Shr;
/**
 * @ingroup Shrs
 * Shrs opcode
 */
FIRM_API ir_op *op_Shrs;
/**
 * @ingroup Start
 * Start opcode
 */
FIRM_API ir_op *op_Start;
/**
 * @ingroup Store
 * Store opcode
 */
FIRM_API ir_op *op_Store;
/**
 * @ingroup Sub
 * Sub opcode
 */
FIRM_API ir_op *op_Sub;
/**
 * @ingroup Switch
 * Switch opcode
 */
FIRM_API ir_op *op_Switch;
/**
 * @ingroup SymConst
 * SymConst opcode
 */
FIRM_API ir_op *op_SymConst;
/**
 * @ingroup Sync
 * Sync opcode
 */
FIRM_API ir_op *op_Sync;
/**
 * @ingroup Tuple
 * Tuple opcode
 */
FIRM_API ir_op *op_Tuple;
/**
 * @ingroup Unknown
 * Unknown opcode
 */
FIRM_API ir_op *op_Unknown;


/**
 * @ingroup ASM
 * Returns opcode for ASM nodes.
 */
FIRM_API ir_op *get_op_ASM(void);
/**
 * @ingroup Add
 * Returns opcode for Add nodes.
 */
FIRM_API ir_op *get_op_Add(void);
/**
 * @ingroup Alloc
 * Returns opcode for Alloc nodes.
 */
FIRM_API ir_op *get_op_Alloc(void);
/**
 * @ingroup Anchor
 * Returns opcode for Anchor nodes.
 */
FIRM_API ir_op *get_op_Anchor(void);
/**
 * @ingroup And
 * Returns opcode for And nodes.
 */
FIRM_API ir_op *get_op_And(void);
/**
 * @ingroup Bad
 * Returns opcode for Bad nodes.
 */
FIRM_API ir_op *get_op_Bad(void);
/**
 * @ingroup Block
 * Returns opcode for Block nodes.
 */
FIRM_API ir_op *get_op_Block(void);
/**
 * @ingroup Borrow
 * Returns opcode for Borrow nodes.
 */
FIRM_API ir_op *get_op_Borrow(void);
/**
 * @ingroup Bound
 * Returns opcode for Bound nodes.
 */
FIRM_API ir_op *get_op_Bound(void);
/**
 * @ingroup Builtin
 * Returns opcode for Builtin nodes.
 */
FIRM_API ir_op *get_op_Builtin(void);
/**
 * @ingroup Call
 * Returns opcode for Call nodes.
 */
FIRM_API ir_op *get_op_Call(void);
/**
 * @ingroup Carry
 * Returns opcode for Carry nodes.
 */
FIRM_API ir_op *get_op_Carry(void);
/**
 * @ingroup Cast
 * Returns opcode for Cast nodes.
 */
FIRM_API ir_op *get_op_Cast(void);
/**
 * @ingroup Cmp
 * Returns opcode for Cmp nodes.
 */
FIRM_API ir_op *get_op_Cmp(void);
/**
 * @ingroup Cond
 * Returns opcode for Cond nodes.
 */
FIRM_API ir_op *get_op_Cond(void);
/**
 * @ingroup Confirm
 * Returns opcode for Confirm nodes.
 */
FIRM_API ir_op *get_op_Confirm(void);
/**
 * @ingroup Const
 * Returns opcode for Const nodes.
 */
FIRM_API ir_op *get_op_Const(void);
/**
 * @ingroup Conv
 * Returns opcode for Conv nodes.
 */
FIRM_API ir_op *get_op_Conv(void);
/**
 * @ingroup CopyB
 * Returns opcode for CopyB nodes.
 */
FIRM_API ir_op *get_op_CopyB(void);
/**
 * @ingroup Deleted
 * Returns opcode for Deleted nodes.
 */
FIRM_API ir_op *get_op_Deleted(void);
/**
 * @ingroup Div
 * Returns opcode for Div nodes.
 */
FIRM_API ir_op *get_op_Div(void);
/**
 * @ingroup Dummy
 * Returns opcode for Dummy nodes.
 */
FIRM_API ir_op *get_op_Dummy(void);
/**
 * @ingroup End
 * Returns opcode for End nodes.
 */
FIRM_API ir_op *get_op_End(void);
/**
 * @ingroup Eor
 * Returns opcode for Eor nodes.
 */
FIRM_API ir_op *get_op_Eor(void);
/**
 * @ingroup Free
 * Returns opcode for Free nodes.
 */
FIRM_API ir_op *get_op_Free(void);
/**
 * @ingroup IJmp
 * Returns opcode for IJmp nodes.
 */
FIRM_API ir_op *get_op_IJmp(void);
/**
 * @ingroup Id
 * Returns opcode for Id nodes.
 */
FIRM_API ir_op *get_op_Id(void);
/**
 * @ingroup InstOf
 * Returns opcode for InstOf nodes.
 */
FIRM_API ir_op *get_op_InstOf(void);
/**
 * @ingroup Jmp
 * Returns opcode for Jmp nodes.
 */
FIRM_API ir_op *get_op_Jmp(void);
/**
 * @ingroup Load
 * Returns opcode for Load nodes.
 */
FIRM_API ir_op *get_op_Load(void);
/**
 * @ingroup Minus
 * Returns opcode for Minus nodes.
 */
FIRM_API ir_op *get_op_Minus(void);
/**
 * @ingroup Mod
 * Returns opcode for Mod nodes.
 */
FIRM_API ir_op *get_op_Mod(void);
/**
 * @ingroup Mul
 * Returns opcode for Mul nodes.
 */
FIRM_API ir_op *get_op_Mul(void);
/**
 * @ingroup Mulh
 * Returns opcode for Mulh nodes.
 */
FIRM_API ir_op *get_op_Mulh(void);
/**
 * @ingroup Mux
 * Returns opcode for Mux nodes.
 */
FIRM_API ir_op *get_op_Mux(void);
/**
 * @ingroup NoMem
 * Returns opcode for NoMem nodes.
 */
FIRM_API ir_op *get_op_NoMem(void);
/**
 * @ingroup Not
 * Returns opcode for Not nodes.
 */
FIRM_API ir_op *get_op_Not(void);
/**
 * @ingroup Or
 * Returns opcode for Or nodes.
 */
FIRM_API ir_op *get_op_Or(void);
/**
 * @ingroup Phi
 * Returns opcode for Phi nodes.
 */
FIRM_API ir_op *get_op_Phi(void);
/**
 * @ingroup Pin
 * Returns opcode for Pin nodes.
 */
FIRM_API ir_op *get_op_Pin(void);
/**
 * @ingroup Proj
 * Returns opcode for Proj nodes.
 */
FIRM_API ir_op *get_op_Proj(void);
/**
 * @ingroup Raise
 * Returns opcode for Raise nodes.
 */
FIRM_API ir_op *get_op_Raise(void);
/**
 * @ingroup Return
 * Returns opcode for Return nodes.
 */
FIRM_API ir_op *get_op_Return(void);
/**
 * @ingroup Rotl
 * Returns opcode for Rotl nodes.
 */
FIRM_API ir_op *get_op_Rotl(void);
/**
 * @ingroup Sel
 * Returns opcode for Sel nodes.
 */
FIRM_API ir_op *get_op_Sel(void);
/**
 * @ingroup Shl
 * Returns opcode for Shl nodes.
 */
FIRM_API ir_op *get_op_Shl(void);
/**
 * @ingroup Shr
 * Returns opcode for Shr nodes.
 */
FIRM_API ir_op *get_op_Shr(void);
/**
 * @ingroup Shrs
 * Returns opcode for Shrs nodes.
 */
FIRM_API ir_op *get_op_Shrs(void);
/**
 * @ingroup Start
 * Returns opcode for Start nodes.
 */
FIRM_API ir_op *get_op_Start(void);
/**
 * @ingroup Store
 * Returns opcode for Store nodes.
 */
FIRM_API ir_op *get_op_Store(void);
/**
 * @ingroup Sub
 * Returns opcode for Sub nodes.
 */
FIRM_API ir_op *get_op_Sub(void);
/**
 * @ingroup Switch
 * Returns opcode for Switch nodes.
 */
FIRM_API ir_op *get_op_Switch(void);
/**
 * @ingroup SymConst
 * Returns opcode for SymConst nodes.
 */
FIRM_API ir_op *get_op_SymConst(void);
/**
 * @ingroup Sync
 * Returns opcode for Sync nodes.
 */
FIRM_API ir_op *get_op_Sync(void);
/**
 * @ingroup Tuple
 * Returns opcode for Tuple nodes.
 */
FIRM_API ir_op *get_op_Tuple(void);
/**
 * @ingroup Unknown
 * Returns opcode for Unknown nodes.
 */
FIRM_API ir_op *get_op_Unknown(void);

#endif
