/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public final class SimpleConsoleFormatter
extends Formatter {
    private final SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");

    private synchronized String ts(Date date) {
        return this.formatter.format(date);
    }

    @Override
    public String format(LogRecord record) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            pw.print(this.ts(new Date(record.getMillis())));
            pw.print(' ');
            pw.print(record.getLevel().getName());
            pw.print(": ");
            pw.print(this.formatMessage(record));
            pw.println();
            Throwable thrown = record.getThrown();
            if (thrown != null) {
                thrown.printStackTrace(pw);
            }
        }
        return sw.toString();
    }
}

