/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.analysis.executables;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.analysis.FileAnalyzer;
import org.opensolaris.opengrok.analysis.FileAnalyzerFactory;
import org.opensolaris.opengrok.analysis.StreamSource;
import org.opensolaris.opengrok.web.Util;

public class ELFAnalyzer
extends FileAnalyzer {
    private static final List<String> READABLE_SECTIONS = new ArrayList<String>();

    protected ELFAnalyzer(FileAnalyzerFactory factory) {
        super(factory);
    }

    @Override
    public void analyze(Document doc, StreamSource src, Writer xrefOut) throws IOException {
        String content;
        String fullpath = doc.get("fullpath");
        try (RandomAccessFile raf = new RandomAccessFile(fullpath, "r");){
            content = this.parseELF(raf.getChannel());
        }
        if (content != null && !content.isEmpty()) {
            doc.add((IndexableField)new TextField("full", content, Field.Store.NO));
            if (xrefOut != null) {
                xrefOut.append("</pre>");
                Util.htmlize(content, (Appendable)xrefOut);
                xrefOut.append("<pre>");
            }
        }
    }

    public String parseELF(FileChannel fch) throws IOException {
        MappedByteBuffer fmap = fch.map(FileChannel.MapMode.READ_ONLY, 0L, fch.size());
        ELFHeader eh = new ELFHeader(fmap);
        if (eh.e_shnum <= 0) {
            OpenGrokLogger.getLogger().log(Level.FINE, "Skipping file, no section headers");
            return null;
        }
        fmap.position(eh.e_shoff + eh.e_shstrndx * eh.e_shentsize);
        ELFSection stringSection = new ELFSection(fmap);
        if (stringSection.sh_size == 0) {
            OpenGrokLogger.getLogger().log(Level.FINE, "Skipping file, no section name string table");
            return null;
        }
        HashMap<String, Integer> sectionMap = new HashMap<String, Integer>();
        ELFSection[] sections = new ELFSection[eh.e_shnum];
        int[] readables = new int[eh.e_shnum];
        int ri = 0;
        for (int i = 0; i < eh.e_shnum; ++i) {
            fmap.position(eh.e_shoff + i * eh.e_shentsize);
            sections[i] = new ELFSection(fmap);
            String sectionName = this.getName(stringSection.sh_offset, sections[i].sh_name, fmap);
            if (sectionName != null) {
                sectionMap.put(sectionName, sections[i].sh_offset);
            }
            if (sections[i].sh_type == 3) {
                readables[ri++] = i;
                continue;
            }
            if (!READABLE_SECTIONS.contains(sectionName)) continue;
            readables[ri++] = i;
        }
        boolean lastPrintable = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ri; ++i) {
            fmap.position(sections[readables[i]].sh_offset);
            int size = sections[readables[i]].sh_size;
            while (size-- > 0) {
                byte c = fmap.get();
                if (this.isReadable(c)) {
                    lastPrintable = true;
                    sb.append((char)c);
                    continue;
                }
                if (!lastPrintable) continue;
                lastPrintable = false;
                sb.append(' ');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    private boolean isReadable(int c) {
        return c > 32 && c <= 127;
    }

    private String getName(int tab, int stroff, MappedByteBuffer fmap) {
        byte c;
        if (tab == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(20);
        int start = tab + stroff;
        while ((c = fmap.get(start++)) != 0) {
            sb.append((char)c);
        }
        return sb.toString();
    }

    static {
        READABLE_SECTIONS.add(".debug_str");
        READABLE_SECTIONS.add(".comment");
        READABLE_SECTIONS.add(".data");
        READABLE_SECTIONS.add(".data1");
        READABLE_SECTIONS.add(".rodata");
        READABLE_SECTIONS.add(".rodata1");
    }

    private static enum E_Version {
        EV_NONE(0),
        EV_CURRENT(1);

        final String[] textual = new String[]{"Invalid", "Current"};
        private final int value;

        private E_Version(int value) {
            this.value = value;
        }

        static E_Version valueOf(int value) throws IllegalArgumentException {
            switch (value) {
                case 0: {
                    return EV_NONE;
                }
                case 1: {
                    return EV_CURRENT;
                }
            }
            throw new IllegalArgumentException("Illegal (or unknown) version number: " + value);
        }

        public int value() {
            return this.value;
        }

        public String toString() {
            return this.textual[this.value];
        }
    }

    private static enum E_Machine {
        EM_NONE(0),
        EM_M32(1),
        EM_SPARC(2),
        EM_386(3),
        EM_68K(4),
        EM_88K(5),
        EM_860(7),
        EM_MIPS(8),
        EM_UNKNOWN(65535);

        final String[] textual = new String[]{"No machine", "AT&T WE 32100", "SPARC", "Intel 80386", "Motorola 68000", "Motorola 88000", null, "Intel 80860", "MIPS RS3000"};
        private final int value;

        private E_Machine(int value) {
            this.value = value;
        }

        static E_Machine valueOf(short value) {
            switch (value) {
                case 0: {
                    return EM_NONE;
                }
                case 1: {
                    return EM_M32;
                }
                case 2: {
                    return EM_SPARC;
                }
                case 3: {
                    return EM_386;
                }
                case 4: {
                    return EM_68K;
                }
                case 5: {
                    return EM_88K;
                }
                case 7: {
                    return EM_860;
                }
                case 8: {
                    return EM_MIPS;
                }
            }
            return EM_UNKNOWN;
        }

        public int value() {
            return this.value;
        }

        public String toString() {
            if (this.value == EM_UNKNOWN.value()) {
                return "Unknown";
            }
            return this.textual[this.value];
        }
    }

    private static enum E_Type {
        ET_NONE(0),
        ET_REL(1),
        ET_EXEC(2),
        ET_DYN(3),
        ET_CORE(4),
        ET_UNKNOWN(65535);

        final String[] textual = new String[]{"None", "Relocable", "Executable", "Shared object", "Core"};
        private final int value;

        private E_Type(int value) {
            this.value = value;
        }

        static E_Type valueOf(short value) {
            switch (value) {
                case 0: {
                    return ET_NONE;
                }
                case 1: {
                    return ET_REL;
                }
                case 2: {
                    return ET_EXEC;
                }
                case 3: {
                    return ET_DYN;
                }
                case 4: {
                    return ET_CORE;
                }
            }
            return ET_UNKNOWN;
        }

        public int value() {
            return this.value;
        }

        public String toString() {
            if (this.value == ET_UNKNOWN.value()) {
                return "Unknown";
            }
            return this.textual[this.value];
        }
    }

    private static enum EI_Data {
        ELFDATANONE(0),
        ELFDATA2LSB(1),
        ELFDATA2MSB(2);

        private final int value;

        private EI_Data(int value) {
            this.value = value;
        }

        static EI_Data valueOf(byte value) throws IllegalArgumentException {
            switch (value) {
                case 0: {
                    return ELFDATANONE;
                }
                case 1: {
                    return ELFDATA2LSB;
                }
                case 2: {
                    return ELFDATA2MSB;
                }
            }
            throw new IllegalArgumentException("Invalid EI_DATA value:" + value);
        }

        public int value() {
            return this.value;
        }
    }

    private static enum EI_Class {
        ELFCLASSNONE(0),
        ELFCLASS32(1),
        ELFCLASS64(2);

        final String[] textual = new String[]{"None", "32", "64"};
        private final int value;

        private EI_Class(int value) {
            this.value = value;
        }

        static EI_Class valueOf(byte value) throws IllegalArgumentException {
            switch (value) {
                case 0: {
                    return ELFCLASSNONE;
                }
                case 1: {
                    return ELFCLASS32;
                }
                case 2: {
                    return ELFCLASS64;
                }
            }
            throw new IllegalArgumentException("Invalid EI_CLASS value:" + value);
        }

        public int value() {
            return this.value;
        }

        public String toString() {
            return this.textual[this.value];
        }
    }

    private static enum ELFIdentification {
        EI_MAG0(0),
        EI_MAG1(1),
        EI_MAG2(2),
        EI_MAG3(3),
        EI_CLASS(4),
        EI_DATA(5),
        EI_VERSION(6),
        EI_PAD(7),
        EI_NIDENT(16);

        private final int value;

        private ELFIdentification(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }

    private static class ELFSection {
        public static final int SHT_NULL = 0;
        public static final int SHT_PROGBITS = 1;
        public static final int SHT_SYMTAB = 2;
        public static final int SHT_STRTAB = 3;
        public static final int SHT_RELA = 4;
        public static final int SHT_HASH = 5;
        public static final int SHT_DYNAMIC = 6;
        public static final int SHT_NOTE = 7;
        public static final int SHT_NOBITS = 8;
        public static final int SHT_REL = 9;
        public static final int SHT_SHLIB = 10;
        public static final int SHT_DYNSYM = 11;
        public static final int SHT_INIT_ARRAY = 14;
        public static final int SHT_FINI_ARRAY = 15;
        public static final int SHT_PREINIT_ARRAY = 16;
        public static final int SHT_GROUP = 17;
        public static final int SHT_SYMTAB_SHNDX = 18;
        public static final int SHT_NUM = 19;
        public static final int SHT_LOOS = 0x60000000;
        public static final int SHT_GNU_LIBLIST = 0x6FFFFFF7;
        public static final int SHT_CHECKSUM = 0x6FFFFFF8;
        public static final int SHT_LOSUNW = 0x6FFFFFFA;
        public static final int SHT_SUNW_COMDAT = 0x6FFFFFFB;
        public static final int SHT_HISUNW = 0x6FFFFFFF;
        public static final int SHT_HIOS = 0x6FFFFFFF;
        public static final int SHT_LOPROC = 0x70000000;
        public static final int SHT_HIPROC = Integer.MAX_VALUE;
        public static final int SHT_LOUSER = Integer.MIN_VALUE;
        public static final int SHT_HIUSER = -1879048193;
        public int sh_name;
        public int sh_type;
        public int sh_flags;
        public int sh_addr;
        public int sh_offset;
        public int sh_size;
        public int sh_link;
        public int sh_info;
        public int sh_addralign;
        public int sh_entsize;

        public ELFSection(MappedByteBuffer fmap) {
            this.sh_name = fmap.getInt();
            this.sh_type = fmap.getInt();
            this.sh_flags = fmap.getInt();
            this.sh_addr = fmap.getInt();
            this.sh_offset = fmap.getInt();
            this.sh_size = fmap.getInt();
            this.sh_link = fmap.getInt();
            this.sh_info = fmap.getInt();
            this.sh_addralign = fmap.getInt();
            this.sh_entsize = fmap.getInt();
        }

        public String toString() {
            return "\nsh_name : " + this.sh_name + "\nsh_type : " + this.sh_type + "\nsh_flags: " + this.sh_flags + "\nsh_addr: " + this.sh_addr + "\nsh_offset: " + this.sh_offset + "\nsh_size: " + this.sh_size + "\nsh_link: " + this.sh_link + "\nsh_info: " + this.sh_info + "\nsh_addralign: " + this.sh_addralign + "\nsh_entsize: " + this.sh_entsize;
        }
    }

    private static class ELFHeader {
        public EI_Class ei_class;
        public EI_Data ei_data;
        public int ei_version;
        public E_Type e_type;
        public E_Machine e_machine;
        public E_Version e_version;
        public int e_entry;
        public int e_phoff;
        public int e_shoff;
        public int e_flags;
        public int e_ehsize;
        public int e_phentsize;
        public int e_phnum;
        public int e_shentsize;
        public int e_shnum;
        public int e_shstrndx;

        public ELFHeader(MappedByteBuffer fmap) throws IllegalArgumentException {
            if (fmap.get(ELFIdentification.EI_MAG0.value()) != 127 || fmap.get(ELFIdentification.EI_MAG1.value()) != 69 || fmap.get(ELFIdentification.EI_MAG2.value()) != 76 || fmap.get(ELFIdentification.EI_MAG3.value()) != 70) {
                throw new IllegalArgumentException("Not an ELF file");
            }
            this.ei_class = EI_Class.valueOf(fmap.get(ELFIdentification.EI_CLASS.value()));
            this.ei_data = EI_Data.valueOf(fmap.get(ELFIdentification.EI_DATA.value()));
            this.ei_version = fmap.get(ELFIdentification.EI_VERSION.value());
            if (this.ei_data == EI_Data.ELFDATA2LSB) {
                fmap.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                fmap.order(ByteOrder.BIG_ENDIAN);
            }
            fmap.position(ELFIdentification.EI_NIDENT.value());
            this.e_type = E_Type.valueOf(fmap.getShort());
            this.e_machine = E_Machine.valueOf(fmap.getShort());
            this.e_version = E_Version.valueOf(fmap.getInt());
            this.e_entry = fmap.getInt();
            this.e_phoff = fmap.getInt();
            this.e_shoff = fmap.getInt();
            this.e_flags = fmap.getInt();
            this.e_ehsize = fmap.getShort();
            this.e_phentsize = fmap.getShort();
            this.e_phnum = fmap.getShort();
            this.e_shentsize = fmap.getShort();
            this.e_shnum = fmap.getShort();
            this.e_shstrndx = fmap.getShort();
        }

        public String toString() {
            return this.e_machine.toString() + " " + this.ei_class.toString() + " \ne_type: " + this.e_type.toString() + "\ne_machine: " + this.e_machine.value() + "\ne_version: " + (Object)((Object)this.e_version) + "\ne_entry: " + this.e_entry + "\ne_phoff: " + this.e_phoff + "\ne_shoff: " + this.e_shoff + "\ne_flags: " + this.e_flags + "\ne_ehsize: " + this.e_ehsize + "\ne_phentsize:" + this.e_phentsize + "\ne_phnum: " + this.e_phnum + "\ne_shentsize" + this.e_shentsize + "\ne_shnum: " + this.e_shnum + "\ne_shstrndx: " + this.e_shstrndx;
        }
    }
}

