/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryEntry;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.SubversionRepository;
import org.opensolaris.opengrok.util.Executor;
import org.opensolaris.opengrok.util.Interner;
import org.xml.sax.Attributes;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

class SubversionHistoryParser
implements Executor.StreamHandler {
    private SAXParser saxParser = null;
    private Handler handler;

    SubversionHistoryParser() {
    }

    private void initSaxParser() throws HistoryException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        this.saxParser = null;
        try {
            this.saxParser = factory.newSAXParser();
        }
        catch (Exception ex) {
            throw new HistoryException("Failed to create SAX parser", ex);
        }
    }

    History parse(File file, SubversionRepository repos, String sinceRevision) throws HistoryException {
        this.initSaxParser();
        this.handler = new Handler(repos.getDirectoryName(), repos.reposPath, RuntimeEnvironment.getInstance().getSourceRootPath().length(), repos.getDateFormat());
        Executor executor = repos.getHistoryLogExecutor(file, sinceRevision);
        int status = executor.exec(true, this);
        if (status != 0) {
            throw new HistoryException("Failed to get history for: \"" + file.getAbsolutePath() + "\" Exit code: " + status);
        }
        List<HistoryEntry> entries = this.handler.entries;
        if (sinceRevision != null) {
            repos.removeAndVerifyOldestChangeset(entries, sinceRevision);
        }
        return new History(entries);
    }

    @Override
    public void processStream(InputStream input) {
        try {
            this.initSaxParser();
            this.saxParser.parse((InputStream)new BufferedInputStream(input), (DefaultHandler)this.handler);
        }
        catch (Exception e) {
            OpenGrokLogger.getLogger().log(Level.SEVERE, "An error occurred while parsing the xml output", e);
        }
    }

    History parse(String buffer) throws IOException {
        this.handler = new Handler("/", "", 0, new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.getDefault()));
        this.processStream(new ByteArrayInputStream(buffer.getBytes("UTF-8")));
        return new History(this.handler.entries);
    }

    private static class Handler
    extends DefaultHandler2 {
        final String prefix;
        final String home;
        final int length;
        final List<HistoryEntry> entries = new ArrayList<HistoryEntry>();
        final DateFormat format;
        HistoryEntry entry;
        StringBuilder sb;
        private final Interner<String> stringInterner = new Interner();

        Handler(String home, String prefix, int length, DateFormat df) {
            this.home = home;
            this.prefix = prefix;
            this.length = length;
            this.format = df;
            this.sb = new StringBuilder();
        }

        @Override
        public void startElement(String uri, String localName, String qname, Attributes attr) {
            if ("logentry".equals(qname)) {
                this.entry = new HistoryEntry();
                this.entry.setActive(true);
                this.entry.setRevision(attr.getValue("revision"));
            }
            this.sb.setLength(0);
        }

        @Override
        public void endElement(String uri, String localName, String qname) {
            String s = this.sb.toString();
            if ("author".equals(qname)) {
                this.entry.setAuthor(s);
            } else if ("date".equals(qname)) {
                try {
                    this.entry.setDate(this.format.parse(s));
                }
                catch (ParseException ex) {
                    OpenGrokLogger.getLogger().log(Level.SEVERE, "Failed to parse: " + s, ex);
                }
            } else if ("path".equals(qname)) {
                if (s.startsWith(this.prefix) && !s.equals(this.prefix)) {
                    File file = new File(this.home, s.substring(this.prefix.length()));
                    String path = file.getAbsolutePath().substring(this.length);
                    path = this.stringInterner.intern(path);
                    this.entry.addFile(path);
                } else {
                    OpenGrokLogger.getLogger().log(Level.FINER, "Skipping file outside repository: " + s);
                }
            } else if ("msg".equals(qname)) {
                this.entry.setMessage(s);
            }
            if ("logentry".equals(qname)) {
                this.entries.add(this.entry);
            }
            this.sb.setLength(0);
        }

        @Override
        public void characters(char[] arg0, int arg1, int arg2) {
            this.sb.append(arg0, arg1, arg2);
        }
    }
}

