/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.bean;

import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import org.wiztools.restclient.bean.KeyStoreType;
import org.wiztools.restclient.bean.SSLKeyStore;
import org.wiztools.restclient.util.SSLUtil;

public class SSLKeyStoreBean
implements SSLKeyStore {
    private File file;
    private KeyStoreType type = KeyStoreType.JKS;
    private char[] password;

    public void setFile(File file) {
        this.file = file;
    }

    public void setType(KeyStoreType type) {
        this.type = type;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public KeyStoreType getType() {
        return this.type;
    }

    @Override
    public char[] getPassword() {
        if (this.type == KeyStoreType.PEM) {
            return "changeit".toCharArray();
        }
        return this.password;
    }

    @Override
    public KeyStore getKeyStore() throws KeyStoreException, IOException, InvalidKeySpecException, NoSuchAlgorithmException, CertificateException {
        return SSLUtil.getKeyStore(this.file, this.type, this.password);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("@SSLKeyStore[");
        sb.append("type=").append((Object)this.type).append(", ");
        sb.append("file=").append(this.file.getPath()).append(", ");
        sb.append("password=").append(this.password != null ? this.password.length : 0).append(", ");
        sb.append("]");
        return sb.toString();
    }
}

